/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.debug;

import java.io.File;
import java.util.regex.Pattern;
import mirah.lang.ast.Position;

public class Breakpoint {
    private String filename;
    private int line;
    private Pattern pattern;

    public Breakpoint(String filename, int line) {
        this.filename = filename;
        this.pattern = Pattern.compile("(?:^|" + File.separatorChar + ")" + Pattern.quote(filename) + "$");
        this.line = line;
    }

    public boolean matches(Position position) {
        if (position == null) {
            return false;
        }
        if (position.startLine() != this.line) {
            return false;
        }
        String name = position.source().name();
        return this.pattern.matcher(name).find();
    }

    public String toString() {
        return this.filename + ":" + this.line;
    }
}

