/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.Types;
import org.mirah.jvm.mirrors.MirrorProxy;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.model.Cycle;
import org.mirah.jvm.model.IntersectionType;
import org.mirah.util.Context;

public class LubFinder {
    private Types types;
    private static Logger log = Logger.getLogger(LubFinder.class.getName());
    private Context context;
    private HashMap cycles;

    public LubFinder(Context context) {
        this.context = context;
        this.types = (Types)context.get(Types.class);
        this.cycles = new HashMap();
    }

    public DeclaredType leastUpperBound(Collection types) {
        DeclaredType declaredType;
        if (this.cycles.containsKey(types)) {
            declaredType = (DeclaredType)this.cycles.get(types);
        } else {
            Cycle val0 = new Cycle();
            this.cycles.put(types, val0);
            Cycle cycle_guard = val0;
            Map ecs = this.erasedCandidateSet(types);
            log.finer("EC(" + types + ") = " + ecs);
            this.minimizeErasedCandidates(ecs.keySet());
            log.finer("MEC = " + ecs.keySet());
            Collection gensym4 = ecs.values();
            ArrayList<TypeMirror> gensym5 = new ArrayList<TypeMirror>(gensym4.size());
            for (Set x : gensym4) {
                gensym5.add(this.candidateInvocation(x));
            }
            List supertypes = gensym5;
            log.fine("lub candidates(" + types + ") = " + supertypes);
            DeclaredType result = supertypes.size() == 1 ? (DeclaredType)supertypes.get(0) : (supertypes.size() == 0 ? null : new IntersectionType(this.context, supertypes));
            this.cycles.remove(types);
            cycle_guard.target_set((MirrorType)((Object)result));
            declaredType = result;
        }
        return declaredType;
    }

    public Map erasedSupertypes(TypeMirror t) {
        LinkedHashMap<TypeMirror, HashSet<TypeMirror>> supertypes = new LinkedHashMap<TypeMirror, HashSet<TypeMirror>>();
        HashSet<TypeMirror> processed = new HashSet<TypeMirror>();
        LinkedList<? extends TypeMirror> to_process = new LinkedList<TypeMirror>();
        to_process.add(t);
        while (!to_process.isEmpty()) {
            TypeMirror type = this.unwrap((TypeMirror)to_process.removeFirst());
            if (processed.contains(type)) continue;
            TypeMirror erased = this.unwrap(this.types.erasure(type));
            log.finest("Processing " + type);
            processed.add(type);
            processed.add(erased);
            HashSet<TypeMirror> instantiations = (HashSet<TypeMirror>)supertypes.get(erased);
            if (instantiations == null) {
                HashSet<TypeMirror> val0 = new HashSet<TypeMirror>();
                supertypes.put(erased, val0);
                instantiations = val0;
            }
            if (!instantiations.add(type)) continue;
            to_process.addAll(this.types.directSupertypes(type));
        }
        return supertypes;
    }

    public TypeMirror unwrap(TypeMirror t) {
        while (t instanceof MirrorProxy) {
            t = ((MirrorProxy)t).target();
        }
        return t;
    }

    public Map combineCandidates(Map a, Map b) {
        if (a == null) {
            return b;
        }
        Iterator it = a.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            if (b.containsKey(e.getKey())) {
                ((Set)e.getValue()).addAll((Set)b.get(e.getKey()));
                continue;
            }
            it.remove();
        }
        return a;
    }

    public Map erasedCandidateSet(Collection types) {
        Map candidates = null;
        for (Object t : types) {
            candidates = this.combineCandidates(candidates, this.erasedSupertypes((TypeMirror)t));
        }
        Map $or$1 = candidates;
        return $or$1 != null ? $or$1 : Collections.emptyMap();
    }

    public void minimizeErasedCandidates(Set candidates) {
        HashSet<TypeMirror> minimal = new HashSet<TypeMirror>();
        for (TypeMirror c : candidates) {
            Iterator mit = minimal.iterator();
            boolean isMinimal = true;
            while (mit.hasNext()) {
                TypeMirror m = (TypeMirror)mit.next();
                if (this.types.isSubtype(m, c)) {
                    isMinimal = false;
                    break;
                }
                if (!this.types.isSubtype(c, m)) continue;
                mit.remove();
            }
            if (!isMinimal) continue;
            minimal.add(c);
        }
        candidates.retainAll(minimal);
    }

    public TypeMirror candidateInvocation(Collection invocations) {
        TypeMirror typeMirror;
        if (invocations.size() == 1) {
            typeMirror = (TypeMirror)invocations.iterator().next();
        } else {
            boolean gensym0 = true;
            DeclaredType x = null;
            for (DeclaredType y : invocations) {
                if (gensym0) {
                    gensym0 = false;
                    x = y;
                    continue;
                }
                x = this.candidateInvocation2(x, y);
            }
            typeMirror = x;
        }
        return typeMirror;
    }

    public DeclaredType candidateInvocation2(DeclaredType x, DeclaredType y) {
        if (x.getTypeArguments().size() == 0) {
            return x;
        }
        if (y.getTypeArguments().size() == 0) {
            return y;
        }
        TypeMirror[] args = new TypeMirror[x.getTypeArguments().size()];
        int i = 0;
        Iterator<? extends TypeMirror> gensym0 = x.getTypeArguments().iterator();
        Iterator<? extends TypeMirror> gensym1 = y.getTypeArguments().iterator();
        while (gensym0.hasNext()) {
            TypeMirror a = gensym0.next();
            TypeMirror b = gensym1.hasNext() ? gensym1.next() : null;
            args[i] = this.leastContainingTypeArgument(a, b);
            ++i;
        }
        return this.types.getDeclaredType((TypeElement)this.types.asElement(x), args);
    }

    public TypeMirror leastContainingTypeArgument(TypeMirror a, TypeMirror b) {
        TypeMirror typeMirror;
        TypeMirror b_has_bounds;
        TypeMirror $or$3;
        TypeMirror a_has_bounds;
        TypeMirror $or$2;
        WildcardType aw = this.wildcard(a);
        WildcardType bw = this.wildcard(b);
        TypeMirror typeMirror2 = aw != null ? (($or$2 = aw.getExtendsBound()) != null ? $or$2 : aw.getSuperBound()) : (a_has_bounds = null);
        TypeMirror typeMirror3 = bw != null ? (($or$3 = bw.getExtendsBound()) != null ? $or$3 : bw.getSuperBound()) : (b_has_bounds = null);
        boolean bl = a_has_bounds != null ? b_has_bounds == null : false;
        if (bl) {
            return this.leastContainingTypeArgument(b, a);
        }
        if ((((aw != null ? aw.getSuperBound() : null) != null ? bw : null) != null ? bw.getExtendsBound() : null) != null) {
            return this.leastContainingTypeArgument(b, a);
        }
        if (a_has_bounds == null) {
            if (b_has_bounds == null) {
                if (this.types.isSameType(a, b)) {
                    typeMirror = a;
                } else {
                    ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(2);
                    arrayList.add(a);
                    arrayList.add(b);
                    typeMirror = this.types.getWildcardType(this.leastUpperBound(arrayList), null);
                }
            } else if (bw.getExtendsBound() != null) {
                ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(2);
                arrayList.add(a);
                arrayList.add(bw.getExtendsBound());
                typeMirror = this.types.getWildcardType(this.leastUpperBound(arrayList), null);
            } else {
                ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(2);
                arrayList.add(a);
                arrayList.add(bw.getSuperBound());
                typeMirror = this.types.getWildcardType(null, new IntersectionType(this.context, arrayList));
            }
        } else if ((aw.getExtendsBound() != null ? bw.getExtendsBound() : null) != null) {
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(2);
            arrayList.add(aw.getExtendsBound());
            arrayList.add(bw.getExtendsBound());
            typeMirror = this.types.getWildcardType(this.leastUpperBound(arrayList), null);
        } else if ((aw.getExtendsBound() != null ? bw.getSuperBound() : null) != null) {
            typeMirror = this.types.isSameType(aw.getExtendsBound(), bw.getSuperBound()) ? aw.getExtendsBound() : this.types.getWildcardType(null, null);
        } else if ((aw.getSuperBound() != null ? bw.getSuperBound() : null) != null) {
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(2);
            arrayList.add(aw.getSuperBound());
            arrayList.add(bw.getSuperBound());
            typeMirror = this.types.getWildcardType(null, this.leastUpperBound(arrayList));
        } else {
            throw new IllegalArgumentException("lcta(" + a + ", " + b + ")");
        }
        return typeMirror;
    }

    public WildcardType wildcard(TypeMirror type) {
        return type.getKind() == TypeKind.WILDCARD ? (WildcardType)type : null;
    }
}

