/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.generics.AsyncTypeBuilder;
import org.mirah.jvm.mirrors.generics.BaseSignatureReader;
import org.mirah.jvm.mirrors.generics.TypeVariable;
import org.mirah.jvm.types.JVMType;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.util.Context;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodSignatureReader
extends BaseSignatureReader {
    private ArrayList forced_params;
    private LinkedList typeParams = new LinkedList();
    private JVMType forced_return;
    private ArrayList params = new ArrayList();
    private AsyncTypeBuilder returnType;

    public MethodSignatureReader(Context context, Map typeVariables) {
        super(context, typeVariables);
    }

    @Override
    public void saveTypeParam(TypeVariable var) {
        Map map = this.typeVariables();
        String string = var.toString();
        BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
        baseTypeFuture.resolved(var);
        map.put(string, baseTypeFuture);
        this.typeParams.add(var);
    }

    @Override
    public SignatureVisitor visitParameterType() {
        this.finishTypeParam();
        AsyncTypeBuilder builder = this.newBuilder();
        this.params.add(builder);
        return builder;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        this.finishTypeParam();
        this.returnType = this.newBuilder();
        return this.returnType;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        return this.newBuilder();
    }

    public List getFormalTypeParameters() {
        return this.typeParams;
    }

    public List getFormalParameterTypes() {
        if (this.forced_params != null) {
            return this.forced_params;
        }
        ArrayList gensym0 = this.params;
        ArrayList<ResolvedType> gensym1 = new ArrayList<ResolvedType>(gensym0.size());
        for (AsyncTypeBuilder p : gensym0) {
            gensym1.add(p.future().resolve());
        }
        return gensym1;
    }

    public MirrorType genericReturnType() {
        JVMType $or$1 = this.forced_return;
        return (MirrorType)($or$1 != null ? $or$1 : this.returnType.future().resolve());
    }

    public Object readMember(Member member) {
        Object object;
        if (member.signature() != null) {
            MethodSignatureReader methodSignatureReader = this;
            object = methodSignatureReader;
            methodSignatureReader.read(member.signature());
        } else {
            this.forced_params = new ArrayList(member.argumentTypes());
            this.forced_return = member.returnType();
            object = this.forced_return;
        }
        return object;
    }

    public MethodSignatureReader(Context context) {
        this(context, new HashMap(16));
    }
}

