/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor6;
import org.mirah.jvm.mirrors.ArrayType;
import org.mirah.jvm.mirrors.DeclaredMirrorType;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.generics.CapturedWildcard;
import org.mirah.jvm.mirrors.generics.LubFinder;
import org.mirah.jvm.mirrors.generics.TypeVariable;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;

public class Substitutor
extends SimpleTypeVisitor6 {
    private LinkedList type_parameters;
    private MirrorTypeSystem types;
    private int substitutions;
    private static Logger log = Logger.getLogger(Substitutor.class.getName());
    private Map typeVars;
    private Context context;

    public Substitutor(Context context, Map typeVars) {
        this.context = context;
        this.types = (MirrorTypeSystem)context.get(MirrorTypeSystem.class);
        this.typeVars = typeVars;
        this.substitutions = 0;
        this.type_parameters = new LinkedList();
    }

    public Object defaultAction(TypeMirror e, Object p) {
        this.popTypeParam();
        return this.future(e);
    }

    public ResolvedType popTypeParam() {
        return this.type_parameters.isEmpty() ? null : ((TypeFuture)this.type_parameters.removeFirst()).resolve();
    }

    @Override
    public Object visitArray(javax.lang.model.type.ArrayType t, Object p) {
        this.popTypeParam();
        TypeMirror c = t.getComponentType();
        int saved = this.substitutions;
        TypeFuture c2 = (TypeFuture)this.visit(c, p);
        javax.lang.model.type.ArrayType array = saved == this.substitutions ? t : new ArrayType(this.context, (MirrorType)c2.resolve());
        return this.future(array);
    }

    @Override
    public Object visitTypeVariable(javax.lang.model.type.TypeVariable t, Object p) {
        BaseTypeFuture baseTypeFuture;
        this.popTypeParam();
        Object t2 = this.typeVars.get(t.toString());
        if (t2 != null) {
            ++this.substitutions;
            baseTypeFuture = t2;
        } else {
            baseTypeFuture = this.future(t);
        }
        return baseTypeFuture;
    }

    @Override
    public Object visitDeclared(DeclaredType t, Object p) {
        BaseTypeFuture baseTypeFuture;
        this.popTypeParam();
        int saved_substitutions = this.substitutions;
        LinkedList saved_parameters = this.type_parameters;
        try {
            this.type_parameters = new LinkedList();
            if (t instanceof MirrorType) {
                DeclaredMirrorType erasure = (DeclaredMirrorType)((MirrorType)((Object)t)).erasure();
                this.type_parameters.addAll(erasure.getTypeVariableMap().values());
            }
            log.fine("Type parameters for " + t + " = " + this.type_parameters);
            List<? extends TypeMirror> gensym0 = t.getTypeArguments();
            ArrayList gensym1 = new ArrayList(gensym0.size());
            for (TypeMirror typeMirror : gensym0) {
                gensym1.add(this.visit(typeMirror, p));
            }
            ArrayList newArgs = gensym1;
            baseTypeFuture = saved_substitutions == this.substitutions ? this.future(t) : this.types.parameterize(this.future(((MirrorType)((Object)t)).erasure()), newArgs);
            this.type_parameters = saved_parameters;
        }
        catch (Throwable throwable) {
            this.type_parameters = saved_parameters;
            throw throwable;
        }
        return baseTypeFuture;
    }

    @Override
    public Object visitWildcard(WildcardType t, Object p) {
        TypeVariable param = (TypeVariable)this.popTypeParam();
        MirrorType upper = (MirrorType)param.getUpperBound();
        TypeMirror lower = param.getLowerBound();
        if (t.getSuperBound() != null) {
            lower = t.getSuperBound();
        }
        boolean bl = t.getExtendsBound() != null ? !upper.isSameType((MirrorType)t.getExtendsBound()) : false;
        if (bl) {
            LubFinder lub = new LubFinder(this.context);
            ArrayList<TypeMirror> arrayList = new ArrayList<TypeMirror>(2);
            arrayList.add(upper);
            arrayList.add(t.getExtendsBound());
            upper = (MirrorType)((Object)lub.leastUpperBound(arrayList));
        }
        ++this.substitutions;
        return this.future(new CapturedWildcard(this.context, upper, (MirrorType)lower));
    }

    public BaseTypeFuture future(Object t) {
        BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
        baseTypeFuture.resolved((ResolvedType)t);
        return baseTypeFuture;
    }
}

