/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mirah.jvm.mirrors.DeclaredMirrorType;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.generics.AsyncTypeBuilder;
import org.mirah.jvm.mirrors.generics.BaseSignatureReader;
import org.mirah.jvm.mirrors.generics.IgnoredTypeBuilder;
import org.mirah.jvm.mirrors.generics.TypeInvocation;
import org.mirah.jvm.mirrors.generics.TypeVariable;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.signature.SignatureVisitor;

public class TypeInvoker
extends BaseSignatureReader {
    private LinkedList args;
    private List interfaces;
    private AsyncTypeBuilder superclass;
    private LinkedList typeParams = new LinkedList();

    public TypeInvoker(Context context, Map typeVars, List args) {
        super(context, typeVars);
        this.args = new LinkedList(args);
        this.interfaces = new ArrayList(0);
    }

    public Map getTypeVariableMap() {
        return this.typeVariables();
    }

    @Override
    public void saveTypeParam(TypeVariable var) {
        if (!this.args.isEmpty()) {
            this.typeVariables().put(var.toString(), this.args.removeFirst());
        }
        this.typeParams.add(var);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        return new IgnoredTypeBuilder();
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        return this.visitClassBound();
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        this.finishTypeParam();
        this.superclass = this.newBuilder();
        return this.superclass;
    }

    @Override
    public SignatureVisitor visitInterface() {
        AsyncTypeBuilder builder = this.newBuilder();
        this.interfaces.add(builder);
        return builder;
    }

    public TypeFuture superclass() {
        return this.superclass != null ? this.superclass.future() : null;
    }

    public TypeFuture[] interfaces() {
        TypeFuture[] array = new TypeFuture[this.interfaces.size()];
        Iterator it = this.interfaces.iterator();
        int i = 0;
        int gensym0 = this.interfaces.size();
        if (i < gensym0) {
            do {
                array[i] = ((AsyncTypeBuilder)it.next()).future();
            } while (++i < gensym0);
        }
        return array;
    }

    public List getFormalTypeParameters() {
        return this.typeParams;
    }

    public static MirrorType invoke(Context context, MirrorType type, List args, Map outerTypeArgs) {
        MirrorType mirrorType;
        boolean bl;
        boolean $or$1;
        DeclaredMirrorType dtype = (DeclaredMirrorType)type;
        boolean bl2 = $or$1 = dtype.signature() == null;
        if ($or$1) {
            bl = $or$1;
        } else {
            boolean gensym0 = false;
            for (Object a : args) {
                if (a != null) continue;
                gensym0 = true;
                break;
            }
            bl = gensym0;
        }
        if (bl) {
            mirrorType = type;
        } else {
            TypeInvoker invoker = new TypeInvoker(context, outerTypeArgs, args);
            invoker.read(dtype.signature());
            mirrorType = new TypeInvocation(context, type, invoker.superclass(), invoker.interfaces(), args, invoker.getTypeVariableMap());
        }
        return mirrorType;
    }
}

