/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.model;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.generics.Wildcard;
import org.mirah.jvm.model.TypeElement;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Type;

public class Types
implements javax.lang.model.util.Types {
    private MirrorTypeSystem types;
    private EnumMap primitives;
    private Wildcard emptyWildcard;
    private Context context;
    private MirrorType object;

    public Types(Context context) {
        this.emptyWildcard = new Wildcard(this.context, this.object, null, null);
        this.context = context;
        this.types = (MirrorTypeSystem)context.get(MirrorTypeSystem.class);
        context.add(javax.lang.model.util.Types.class, this);
        this.object = (MirrorType)this.types.loadNamedType("java.lang.Object").resolve();
        HashMap<TypeKind, ResolvedType> hashMap = new HashMap<TypeKind, ResolvedType>(16);
        hashMap.put(TypeKind.BOOLEAN, this.types.loadNamedType("boolean").resolve());
        hashMap.put(TypeKind.BYTE, this.types.loadNamedType("byte").resolve());
        hashMap.put(TypeKind.CHAR, this.types.loadNamedType("char").resolve());
        hashMap.put(TypeKind.DOUBLE, this.types.loadNamedType("double").resolve());
        hashMap.put(TypeKind.FLOAT, this.types.loadNamedType("float").resolve());
        hashMap.put(TypeKind.INT, this.types.loadNamedType("int").resolve());
        hashMap.put(TypeKind.LONG, this.types.loadNamedType("long").resolve());
        hashMap.put(TypeKind.SHORT, this.types.loadNamedType("short").resolve());
        this.primitives = new EnumMap(hashMap);
    }

    @Override
    public javax.lang.model.element.TypeElement boxedClass(PrimitiveType p) {
        return new TypeElement((MirrorType)((MirrorType)((Object)p)).box());
    }

    @Override
    public ArrayType getArrayType(TypeMirror component) {
        return (ArrayType)((Object)this.types.getResolvedArrayType((MirrorType)component));
    }

    @Override
    public NoType getNoType(TypeKind kind) {
        if (kind == TypeKind.VOID) {
            return (NoType)((Object)this.types.getVoidType().resolve());
        }
        return null;
    }

    @Override
    public NullType getNullType() {
        return (NullType)((Object)this.types.getNullType().resolve());
    }

    @Override
    public PrimitiveType getPrimitiveType(TypeKind kind) {
        return (PrimitiveType)this.primitives.get((Object)kind);
    }

    public List directSupertypes(TypeMirror t) {
        return ((MirrorType)t).directSupertypes();
    }

    @Override
    public Element asElement(TypeMirror t) {
        return new TypeElement((MirrorType)t);
    }

    @Override
    public TypeMirror erasure(TypeMirror x) {
        return ((MirrorType)x).erasure();
    }

    @Override
    public boolean isSameType(TypeMirror a, TypeMirror b) {
        return ((MirrorType)a).isSameType((MirrorType)b);
    }

    @Override
    public boolean isSubtype(TypeMirror a, TypeMirror b) {
        return ((MirrorType)b).isSupertypeOf((MirrorType)a);
    }

    @Override
    public DeclaredType getDeclaredType(javax.lang.model.element.TypeElement element, TypeMirror[] args) {
        Type t = Type.getType(((TypeElement)element).descriptor());
        TypeFuture type = this.types.wrap(t);
        ArrayList<BaseTypeFuture> arg_futures = new ArrayList<BaseTypeFuture>(args.length);
        int gensym1 = 0;
        TypeMirror[] gensym0 = args;
        if (gensym1 < gensym0.length) {
            do {
                TypeMirror arg = gensym0[gensym1];
                BaseTypeFuture baseTypeFuture = new BaseTypeFuture();
                baseTypeFuture.resolved((MirrorType)arg);
                arg_futures.add(baseTypeFuture);
            } while (++gensym1 < gensym0.length);
        }
        return (DeclaredType)((Object)this.types.parameterize(type, arg_futures).resolve());
    }

    @Override
    public WildcardType getWildcardType(TypeMirror extendsBound, TypeMirror superBound) {
        boolean bl = extendsBound == null ? superBound == null : false;
        if (bl) {
            return this.emptyWildcard;
        }
        return new Wildcard(this.context, this.object, extendsBound, superBound);
    }
}

