/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.macros;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import mirah.impl.MirahParser;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Array;
import mirah.lang.ast.BlockArgument;
import mirah.lang.ast.Boolean;
import mirah.lang.ast.Call;
import mirah.lang.ast.Cast;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Import;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Package;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StreamCodeSource;
import mirah.lang.ast.StringCodeSource;
import mirah.lang.ast.StringConcat;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.Unquote;
import org.mirah.macros.Compiler;
import org.mirah.macros.JvmBackend;
import org.mirah.macros.ValueGetter;
import org.mirah.macros.ValueSetter;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;

public class MacroBuilder
implements Compiler {
    private TypeSystem types;
    private Typer typer;
    private MirahParser parser;
    private static Logger log = Logger.getLogger(MacroBuilder.class.getName());
    private Typer loader;
    private JvmBackend backend;
    private HashMap extension_counters;
    private Scoper scopes;

    public MacroBuilder(Typer typer, JvmBackend backend, MirahParser parser) {
        this.typer = typer;
        this.types = typer.type_system();
        this.scopes = typer.scoper();
        this.backend = backend;
        this.extension_counters = new HashMap();
        MirahParser $or$1 = parser;
        this.parser = $or$1 != null ? $or$1 : new MirahParser();
        this.loader = null;
    }

    public Typer setMacroLoader(Typer loader) {
        this.loader = loader;
        return this.loader;
    }

    public MacroBuilder buildExtension(MacroDefinition macroDef) {
        Script ast = this.constructAst(macroDef);
        this.backend.logExtensionAst(ast);
        this.typer.infer(ast);
        Class klass = this.backend.compileAndLoadExtension(ast);
        this.addToExtensions(macroDef, klass);
        MacroBuilder macroBuilder = this;
        macroBuilder.registerLoadedMacro(macroDef, klass);
        return macroBuilder;
    }

    @Override
    public Typer typer() {
        return this.loader != null ? this.loader : this.typer;
    }

    @Override
    public TypeSystem type_system() {
        return this.loader != null ? this.loader.type_system() : this.types;
    }

    @Override
    public Scoper scoper() {
        return this.loader != null ? this.loader.scoper() : this.scopes;
    }

    @Override
    public Cast cast(Object typename, Object value) {
        Unquote t = new Unquote();
        t.object_set(typename);
        Unquote v = new Unquote();
        v.object_set(value);
        return new Cast(t, v);
    }

    @Override
    public Object serializeAst(Node node) {
        if (node.position() == null) {
            throw new IllegalArgumentException("No position for " + node);
        }
        Object[] result = new Object[5];
        result[0] = new SimpleString(node.position().source().name());
        result[1] = new Fixnum(node.position().startLine());
        result[2] = new Fixnum(node.position().startColumn());
        result[3] = this.splitString(node.position().source().substring(node.position().startChar(), node.position().endChar()));
        ValueGetter collector = new ValueGetter();
        collector.scan(node);
        result[4] = collector.values();
        return Arrays.asList(result);
    }

    public Script deserializeScript(String filename, InputStream code, List values) {
        Script script = (Script)this.parser.parse(new StreamCodeSource(filename, code));
        new ValueSetter(values).scan(script);
        return script;
    }

    @Override
    public Node deserializeAst(String filename, int startLine, int startCol, String code, List values) {
        Script script = (Script)this.parser.parse(new StringCodeSource(filename, code, startLine, startCol));
        new ValueSetter(values).scan(script);
        Node node = script.body_size() == 1 ? script.body(0) : script.body();
        node.setParent(null);
        return node;
    }

    public Node splitString(String string) {
        Node node;
        if (string.length() < 65535) {
            node = new SimpleString(string);
        } else {
            StringConcat result = new StringConcat();
            while (string.length() >= 65535) {
                result.add(new SimpleString(string.substring(0, 65535)));
                string = string.substring(65535);
            }
            result.add(new SimpleString(string));
            node = result;
        }
        return node;
    }

    public Script constructAst(MacroDefinition macroDef) {
        String name = this.extensionName(macroDef);
        this.addMissingTypes(macroDef);
        Annotation argdef = this.makeArgAnnotation(macroDef.arguments());
        List casts = this.makeCasts(macroDef.arguments());
        Scope scope = this.scopes.getScope(macroDef);
        boolean $or$2 = macroDef.isStatic();
        Boolean isStatic = new Boolean(macroDef.name().position(), $or$2 ? $or$2 : scope.selfType().resolve().isMeta());
        Script script = new Script(macroDef.position());
        ArrayList<Object> arrayList = new ArrayList<Object>(7);
        arrayList.add(name);
        arrayList.add(macroDef.arguments().clone());
        arrayList.add(macroDef.body());
        arrayList.add(casts);
        arrayList.add(macroDef.name());
        arrayList.add(argdef);
        arrayList.add(isStatic);
        script.body_set((NodeList)this.deserializeAst("src/org/mirah/macros/builder.mirah", 206, 7, "import org.mirah.macros.anno.*\n      import org.mirah.macros.Macro\n      import org.mirah.macros.Compiler\n      import mirah.lang.ast.CallSite\n      import mirah.lang.ast.Node\n      import mirah.lang.ast.*\n\n      $MacroDef[name: `macroDef.name`, arguments:`argdef`, isStatic:`isStatic`]\n      class `name` implements Macro\n        def initialize(mirah:Compiler, call:CallSite)\n          @mirah = mirah\n          @call = call\n        end\n\n        def _expand(`macroDef.arguments.clone`):Node\n          `macroDef.body`\n        end\n\n        def expand:Node\n          _expand(`casts`)\n        end\n\n        def gensym:String\n          @mirah.scoper.getScope(@call).temp('gensym')\n        end\n      end\n", arrayList));
        NodeList preamble = new NodeList();
        if (scope.package() != null) {
            preamble.add(new Package(new SimpleString(scope.package()), null));
        }
        for (Object pkg : scope.search_packages()) {
            preamble.add(new Import(new SimpleString((String)pkg), new SimpleString("*")));
        }
        Map imports = scope.imports();
        for (Object key : imports.keySet()) {
            preamble.add(new Import(new SimpleString((String)imports.get(key)), new SimpleString((String)key)));
        }
        script.body().insert(0, preamble);
        return script;
    }

    public String extensionName(MacroDefinition macroDef) {
        ResolvedType enclosing_type = this.scopes.getScope(macroDef).selfType().resolve();
        Integer counter = (Integer)this.extension_counters.get(enclosing_type);
        int id = counter == null ? 1 : counter + 1;
        this.extension_counters.put(enclosing_type, new Integer(id));
        return enclosing_type.name() + "$Extension" + id;
    }

    public void addMissingTypes(MacroDefinition macroDef) {
        block4: {
            MacroDefinition $ptemp$3 = macroDef;
            Arguments $or$4 = $ptemp$3.arguments();
            if ($or$4 == null) {
                $ptemp$3.arguments_set(new Arguments(Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null));
            }
            MacroDefinition $ptemp$5 = macroDef;
            NodeList $or$6 = $ptemp$5.body();
            if ($or$6 == null) {
                $ptemp$5.body_set(new NodeList());
            }
            for (Object _arg : macroDef.arguments().required()) {
                RequiredArgument arg = (RequiredArgument)_arg;
                if (arg.type() == null) {
                    arg.type_set(new SimpleString("mirah.lang.ast.Node"));
                    continue;
                }
                if (arg.type().typeref().name().indexOf(".") != -1) continue;
                arg.type_set(new SimpleString("mirah.lang.ast." + arg.type().typeref().name()));
            }
            BlockArgument block = macroDef.arguments().block();
            if (block == null) break block4;
            TypeName $or$7 = block.type();
            TypeName type = $or$7 != null ? $or$7 : new SimpleString("mirah.lang.ast.Block");
            macroDef.arguments().block_set(null);
            macroDef.arguments().required().add(new RequiredArgument(block.position(), block.name(), type));
        }
    }

    public List makeCasts(Arguments args) {
        LinkedList<Node> casts = new LinkedList<Node>();
        int i = 0;
        for (Object _arg : args.required()) {
            RequiredArgument arg = (RequiredArgument)_arg;
            if (i == args.required_size() - 1 ? arg.type().typeref().name().endsWith("Block") : false) {
                casts.add(this.fetchMacroBlock());
            } else {
                casts.add(new Cast((TypeName)arg.type().clone(), this.fetchMacroArg(i)));
            }
            ++i;
        }
        return casts;
    }

    public Annotation makeArgAnnotation(Arguments args) {
        LinkedList<SimpleString> required = new LinkedList<SimpleString>();
        int i = 0;
        int gensym0 = args.required_size();
        if (i < gensym0) {
            do {
                RequiredArgument arg;
                String name;
                if (!(name = (arg = args.required(i)).type().typeref().name()).startsWith("mirah.lang.ast.")) {
                    name = "mirah.lang.ast." + name;
                }
                required.add(new SimpleString(arg.position(), name));
            } while (++i < gensym0);
        }
        ArrayList<HashEntry> arrayList = new ArrayList<HashEntry>(1);
        arrayList.add(new HashEntry(new SimpleString("required"), new Array(required)));
        ArrayList<HashEntry> entries = arrayList;
        return new Annotation(new SimpleString("org.mirah.macros.anno.MacroArgs"), entries);
    }

    public Node fetchMacroArg(int i) {
        Call call = new Call(new FieldAccess(new SimpleString("call")), new SimpleString("parameters"), Collections.emptyList(), null);
        SimpleString simpleString = new SimpleString("get");
        ArrayList<Fixnum> arrayList = new ArrayList<Fixnum>(1);
        arrayList.add(new Fixnum(i));
        return new Call(call, simpleString, arrayList, null);
    }

    public Node fetchMacroBlock() {
        return new Call(new FieldAccess(new SimpleString("call")), new SimpleString("block"), Collections.emptyList(), null);
    }

    public void addToExtensions(MacroDefinition macrodef, Class klass) {
        block5: {
            ClassDefinition classdef = (ClassDefinition)macrodef.findAncestor(ClassDefinition.class);
            if (classdef == null) {
                return;
            }
            Annotation extensions = null;
            int i = 0;
            int gensym0 = classdef.annotations_size();
            if (i < gensym0) {
                do {
                    Annotation anno;
                    if (!(anno = classdef.annotations(i)).type().typeref().name().equals("org.mirah.macros.anno.Extensions")) continue;
                    extensions = anno;
                    break;
                } while (++i < gensym0);
            }
            if (extensions == null) {
                ArrayList<HashEntry> arrayList = new ArrayList<HashEntry>(1);
                arrayList.add(new HashEntry(new SimpleString("macros"), new Array(Collections.emptyList())));
                ArrayList<HashEntry> entries = arrayList;
                extensions = new Annotation(new SimpleString("org.mirah.macros.anno.Extensions"), entries);
                TypeFuture extensions_type = this.typer.infer(extensions);
                classdef.annotations().add(extensions);
                if (this.loader != null) {
                    this.loader.learnType(extensions, extensions_type);
                }
            }
            Array array = (Array)extensions.values(0).value();
            SimpleString new_entry = new SimpleString(klass.getName());
            TypeFuture entry_type = this.typer.infer(new_entry);
            array.values().add(new_entry);
            if (this.loader == null) break block5;
            this.loader.learnType(new_entry, entry_type);
        }
    }

    public void registerLoadedMacro(MacroDefinition macroDef, Class klass) {
        Typer typer = this.loader != null ? this.loader : this.typer;
        Scoper scopes = this.loader != null ? this.loader.scoper() : this.scopes;
        ResolvedType extended_class = typer.scoper().getScope(macroDef).selfType().resolve();
        typer.type_system().addMacro(extended_class, klass);
    }

    public MacroBuilder(Typer typer, JvmBackend backend) {
        this(typer, backend, null);
    }
}

