/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.tool;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.Block;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Position;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.typer.ErrorType;
import org.mirah.typer.FuturePrinter;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.MirahDiagnostic;

public class ErrorCollector
extends NodeScanner {
    private Typer typer;
    private static Logger log = Logger.getLogger(ErrorCollector.class.getName());
    private DebuggerInterface debugger;
    private Context context;
    private DiagnosticListener reporter;
    private HashSet errors = new HashSet();

    public ErrorCollector(Context context) {
        this.typer = (Typer)context.get(Typer.class);
        this.reporter = (DiagnosticListener)context.get(DiagnosticListener.class);
        this.debugger = (DebuggerInterface)context.get(DebuggerInterface.class);
        this.context = context;
    }

    @Override
    public Object exitDefault(Node node, Object arg) {
        block1: {
            TypeFuture future = this.typer.getInferredType(node);
            ResolvedType type = future == null ? null : future.resolve();
            if (!(type != null ? type.isError() : false) || !this.errors.add(type)) break block1;
            List messages = ((ErrorType)type).message();
            MirahDiagnostic diagnostic = this.build_diagnostic(messages, node);
            this.reporter.report(diagnostic);
            FuturePrinter debug = new FuturePrinter();
            debug.printFuture(future);
            log.fine("future:\n" + debug);
            if (this.debugger != null) {
                this.debugger.inferenceError(this.context, node, future);
            }
        }
        return null;
    }

    @Override
    public boolean enterBlock(Block node, Object arg) {
        return false;
    }

    public MirahDiagnostic build_diagnostic(List messages, Node node) {
        MirahDiagnostic mirahDiagnostic;
        if (messages.size() >= 1) {
            List items = (List)messages.get(0);
            String text = items.get(0).toString();
            Position position = node.position();
            if ((items.size() == 1 ? items.get(1) : null) != null) {
                position = (Position)items.get(1);
            }
            mirahDiagnostic = MirahDiagnostic.error(position, text);
        } else {
            boolean bl = messages.size() == 0;
            mirahDiagnostic = MirahDiagnostic.error(node.position(), "Error");
        }
        return mirahDiagnostic;
    }
}

