/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.tool;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.tools.DiagnosticListener;
import mirah.impl.MirahParser;
import mirah.lang.ast.CodeSource;
import mirah.lang.ast.Node;
import mirah.lang.ast.Script;
import org.mirah.IsolatedResourceLoader;
import org.mirah.MirahClassLoader;
import org.mirah.jvm.compiler.Backend;
import org.mirah.jvm.compiler.BytecodeConsumer;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.jvm.mirrors.ClassLoaderResourceLoader;
import org.mirah.jvm.mirrors.ClassResourceLoader;
import org.mirah.jvm.mirrors.FilteredResources;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.NegativeFilteredResources;
import org.mirah.jvm.mirrors.ResourceLoader;
import org.mirah.jvm.mirrors.SafeTyper;
import org.mirah.jvm.mirrors.debug.DebugTyper;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.macros.JvmBackend;
import org.mirah.mmeta.BaseParser;
import org.mirah.tool.CompilationFailure;
import org.mirah.tool.ErrorCollector;
import org.mirah.tool.MirahCompiler$1;
import org.mirah.tool.MirahCompiler$2;
import org.mirah.tool.MirahCompiler$3;
import org.mirah.tool.MirahCompiler$4;
import org.mirah.tool.Mirahc;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.SimpleScoper;
import org.mirah.util.AstFormatter;
import org.mirah.util.Context;
import org.mirah.util.LazyTypePrinter;
import org.mirah.util.ParserDiagnostics;
import org.mirah.util.SimpleDiagnostics;

public class MirahCompiler
implements JvmBackend {
    private JvmVersion jvm;
    private MirrorTypeSystem types;
    private SafeTyper typer;
    private static Logger log = Logger.getLogger(Mirahc.class.getName());
    private DebuggerInterface debugger;
    private String destination;
    private Backend macro_backend;
    private MirahClassLoader extension_loader;
    private Context macro_context;
    private Map extension_classes;
    private SimpleDiagnostics diagnostics;
    private MirahParser parser;
    private Context context;
    private SafeTyper macro_typer;
    private SimpleScoper scoper;
    private MirrorTypeSystem macro_types;
    private Backend backend;
    private List asts;

    public MirahCompiler(SimpleDiagnostics diagnostics, JvmVersion jvm, URL[] classpath, URL[] bootclasspath, URL[] macroclasspath, String macro_destination, DebuggerInterface debugger) {
        Context context;
        MirahCompiler$1 mirahCompiler$1 = new MirahCompiler$1();
        this.diagnostics = diagnostics;
        this.jvm = jvm;
        this.destination = macro_destination;
        this.debugger = debugger;
        this.context = context = new Context();
        context.add(JvmBackend.class, this);
        context.add(DiagnosticListener.class, this.diagnostics);
        context.add(SimpleDiagnostics.class, this.diagnostics);
        context.add(JvmVersion.class, this.jvm);
        context.add(DebuggerInterface.class, debugger);
        this.macro_context = new Context();
        this.macro_context.add(JvmBackend.class, this);
        this.macro_context.add(DiagnosticListener.class, this.diagnostics);
        this.macro_context.add(SimpleDiagnostics.class, this.diagnostics);
        this.macro_context.add(JvmVersion.class, this.jvm);
        this.macro_context.add(DebuggerInterface.class, debugger);
        this.context.add(Context.class, this.macro_context);
        this.createTypeSystems(classpath, bootclasspath, macroclasspath);
        this.scoper = new SimpleScoper(new MirahCompiler$2(mirahCompiler$1));
        context.add(Scoper.class, this.scoper);
        this.parser = new MirahParser();
        context.add(MirahParser.class, this.parser);
        ((BaseParser)this.parser).diagnostics = new ParserDiagnostics(this.diagnostics);
        this.macro_context.add(Scoper.class, this.scoper);
        this.macro_context.add(MirahParser.class, this.parser);
        this.macro_typer = this.createTyper(debugger, this.macro_context, this.macro_types, this.scoper, this, this.parser);
        this.macro_context.add(Typer.class, this.macro_typer);
        this.typer = this.createTyper(debugger, context, this.types, this.scoper, this, this.parser);
        context.add(Typer.class, this.typer);
        this.typer.macro_compiler_set(this.macro_typer.macro_compiler());
        this.typer.macro_compiler().setMacroLoader(this.typer);
        this.backend = new Backend(context);
        this.macro_backend = new Backend(this.macro_context);
        this.asts = new ArrayList(0);
    }

    public List getParsedNodes() {
        return this.asts;
    }

    public SafeTyper createTyper(DebuggerInterface debugger, Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend, MirahParser parser) {
        return debugger == null ? new SafeTyper(context, types, scopes, jvm_backend, parser) : new DebugTyper(debugger, context, types, scopes, jvm_backend, parser);
    }

    public Node parse(CodeSource code) {
        Node node = (Node)this.parser.parse(code);
        if (node == null) {
            System.out.println(code.name() + " parsed to nil");
        } else {
            this.asts.add(node);
            if (this.debugger != null) {
                this.debugger.parsedNode(node);
            }
        }
        if (this.diagnostics.errorCount() > 0) {
            throw new CompilationFailure();
        }
        return node;
    }

    public void infer() {
        for (Node node : this.asts) {
            try {
                this.typer.infer(node, false);
                this.logAst(node, this.typer);
            }
            catch (Throwable throwable) {
                this.logAst(node, this.typer);
                throw throwable;
            }
        }
        for (Node node : this.asts) {
            this.processInferenceErrors(node, this.context);
        }
        if (this.diagnostics.errorCount() > 0) {
            throw new CompilationFailure();
        }
    }

    public void processInferenceErrors(Node node, Context context) {
        ErrorCollector errors = new ErrorCollector(context);
        errors.scan(node, null);
    }

    public void logAst(Node node, Typer typer) {
        log.log(Level.FINE, "Inferred types:\n{0}", new LazyTypePrinter(typer, node));
    }

    @Override
    public void logExtensionAst(Node ast) {
        log.log(Level.FINE, "Inferred types:\n{0}", new AstFormatter(ast));
    }

    @Override
    public Class compileAndLoadExtension(Script ast) {
        MirahCompiler$3 mirahCompiler$3 = new MirahCompiler$3();
        this.logAst(ast, this.macro_typer);
        this.processInferenceErrors(ast, this.macro_context);
        if (this.diagnostics.errorCount() > 0) {
            throw new CompilationFailure();
        }
        this.macro_backend.clean(ast, null);
        this.processInferenceErrors(ast, this.macro_context);
        if (this.diagnostics.errorCount() > 0) {
            throw new CompilationFailure();
        }
        this.macro_backend.compile(ast, null);
        mirahCompiler$3.first_class_name = null;
        mirahCompiler$3.destination = this.destination;
        mirahCompiler$3.class_map = this.extension_classes;
        this.macro_backend.generate(new MirahCompiler$4(mirahCompiler$3));
        return this.extension_loader.loadClass(mirahCompiler$3.first_class_name);
    }

    public Object compile(BytecodeConsumer generator) {
        for (Object n : this.asts) {
            Script node = (Script)n;
            this.backend.clean(node, null);
            this.processInferenceErrors(node, this.context);
            if (this.diagnostics.errorCount() > 0) {
                throw new CompilationFailure();
            }
            this.backend.compile(node, null);
        }
        return this.backend.generate(generator);
    }

    public void createTypeSystems(URL[] classpath, URL[] bootcp, URL[] macrocp) {
        ResourceLoader bootloader = bootcp != null ? new ClassLoaderResourceLoader(new IsolatedResourceLoader(bootcp)) : new NegativeFilteredResources(new ClassResourceLoader(System.class), Pattern.compile("^/?(mirah/|org/mirah|org/jruby)"));
        bootloader = new FilteredResources(new ClassResourceLoader(Mirahc.class), Pattern.compile("^/?org/mirah/jvm/(types/(Flags|Member|Modifiers))|compiler/Cleaned"), bootloader);
        ClassLoaderResourceLoader classloader = new ClassLoaderResourceLoader(new IsolatedResourceLoader(classpath), bootloader);
        if (macrocp == null) {
            macrocp = classpath;
        }
        bootloader = new ClassResourceLoader(System.class);
        ClassLoaderResourceLoader macroloader = new ClassLoaderResourceLoader(new IsolatedResourceLoader(macrocp), new FilteredResources(new ClassResourceLoader(Mirahc.class), Pattern.compile("^/?(mirah/|org/mirah)"), bootloader));
        URLClassLoader macro_class_loader = new URLClassLoader(macrocp, MirahCompiler.class.getClassLoader());
        this.context.add(ClassLoader.class, macro_class_loader);
        this.macro_context.add(ClassLoader.class, macro_class_loader);
        this.extension_classes = new HashMap(16);
        URLClassLoader extension_parent = new URLClassLoader(macrocp, Mirahc.class.getClassLoader());
        this.extension_loader = new MirahClassLoader(extension_parent, this.extension_classes);
        this.macro_types = new MirrorTypeSystem(this.macro_context, macroloader);
        this.macro_context.add(TypeSystem.class, this.macro_types);
        this.types = new MirrorTypeSystem(this.context, classloader);
        this.context.add(TypeSystem.class, this.types);
    }

    public MirahCompiler(SimpleDiagnostics diagnostics, JvmVersion jvm, URL[] classpath, URL[] bootclasspath, URL[] macroclasspath, String macro_destination) {
        this(diagnostics, jvm, classpath, bootclasspath, macroclasspath, macro_destination, null);
    }
}

