/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.Position;
import org.mirah.typer.ErrorType;
import org.mirah.typer.FuturePrinter;
import org.mirah.typer.ResolutionWatcher;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeListener;

public class BaseTypeFuture
implements TypeFuture {
    private ResolutionWatcher watcher;
    private String error_message;
    private int notify_depth;
    private ArrayList listeners;
    private static Logger log = Logger.getLogger(BaseTypeFuture.class.getName());
    private ReentrantLock lock;
    private Position position;
    private ArrayList new_listeners;
    private ResolvedType resolved;

    public BaseTypeFuture(Position position) {
        this.position = position;
        this.listeners = new ArrayList();
        this.new_listeners = null;
        this.notify_depth = 0;
        this.lock = new ReentrantLock();
    }

    public BaseTypeFuture() {
        this.listeners = new ArrayList();
        this.lock = new ReentrantLock();
    }

    public void watchResolves(ResolutionWatcher watcher) {
        this.watcher = watcher;
    }

    @Override
    public boolean isResolved() {
        return this.resolved != null;
    }

    public ResolvedType inferredType() {
        return this.resolved;
    }

    @Override
    public ResolvedType resolve() {
        if (this.resolved == null) {
            log.finest(this + ": error: " + this.error_message());
            ArrayList arrayList = new ArrayList(1);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add(this.error_message());
            arrayList2.add(this.position);
            arrayList.add(arrayList2);
            this.resolved = new ErrorType(arrayList);
            this.notifyListeners();
        }
        return this.resolved;
    }

    public String error_message() {
        String $or$1 = this.error_message;
        return $or$1 != null ? $or$1 : "InferenceError";
    }

    public String error_message_set(String message) {
        this.error_message = message;
        return this.error_message;
    }

    public Position position() {
        return this.position;
    }

    public Position position_set(Position pos) {
        this.position = pos;
        return this.position;
    }

    @Override
    public TypeListener onUpdate(TypeListener listener) {
        block6: {
            try {
                this.lock.lock();
                if (this.notify_depth > 0) {
                    if (this.new_listeners != null) {
                    } else {
                        this.new_listeners = new ArrayList(this.listeners);
                    }
                    this.new_listeners.add(listener);
                } else {
                    this.listeners.add(listener);
                }
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
            if (!this.isResolved()) break block6;
            listener.updated(this, this.inferredType());
        }
        return listener;
    }

    @Override
    public void removeListener(TypeListener listener) {
        try {
            this.lock.lock();
            if (this.notify_depth > 0) {
                if (this.new_listeners != null) {
                } else {
                    this.new_listeners = new ArrayList(this.listeners);
                }
                this.new_listeners.remove(listener);
            } else {
                this.listeners.remove(listener);
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolved(ResolvedType type) {
        try {
            log.fine("resolving as " + type + " from " + this.resolved);
            this.lock.lock();
            if (this.watcher != null) {
                this.watcher.resolved(this, this.resolved, type);
            }
            if (type == null) {
                if (type == this.resolved) {
                    this.lock.unlock();
                    return;
                }
                type = new ErrorType(Collections.emptyList());
            }
            if (!type.equals(this.resolved)) {
                this.resolved = type;
                this.notifyListeners();
            }
            this.lock.unlock();
            return;
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public Object forgetType() {
        log.finest("forgetting previous type " + this.resolved);
        this.resolved = null;
        return null;
    }

    public void notifyListeners() {
        block7: {
            this.lock.lock();
            ++this.notify_depth;
            if (this.notify_depth <= 100) break block7;
            throw new IllegalStateException("Type inference loop");
        }
        try {
            if (this.notify_depth == 90) {
                log.severe("Type cycle detected, enabling debug logging.");
                Logger.getLogger("org.mirah").setLevel(Level.ALL);
            }
            for (Object l : this.listeners) {
                ((TypeListener)l).updated(this, this.resolved);
            }
            if (0 == --this.notify_depth && this.new_listeners != null) {
                this.listeners = this.new_listeners;
                this.new_listeners = null;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            if (0 == --this.notify_depth && this.new_listeners != null) {
                this.listeners = this.new_listeners;
                this.new_listeners = null;
            }
            this.lock.unlock();
            throw throwable;
        }
    }

    public String toString() {
        return "<" + this.getClass().getSimpleName() + ": resolved=" + this.resolved + ", listenerCt=" + this.listeners.size() + ">";
    }

    @Override
    public void dump(FuturePrinter out) {
        out.writeLine(String.valueOf(this.resolved));
    }

    @Override
    public Map getComponents() {
        return Collections.emptyMap();
    }
}

