/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import mirah.impl.MirahParser;
import mirah.lang.ast.Annotated;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Array;
import mirah.lang.ast.AttrAssign;
import mirah.lang.ast.BindingReference;
import mirah.lang.ast.Block;
import mirah.lang.ast.BlockArgument;
import mirah.lang.ast.Boolean;
import mirah.lang.ast.Break;
import mirah.lang.ast.Call;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.Cast;
import mirah.lang.ast.CharLiteral;
import mirah.lang.ast.ClassAppendSelf;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Colon2;
import mirah.lang.ast.Constant;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.ElemAssign;
import mirah.lang.ast.EmptyArray;
import mirah.lang.ast.Ensure;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.FieldDeclaration;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.Float;
import mirah.lang.ast.FormalArgument;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.Hash;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.If;
import mirah.lang.ast.ImplicitNil;
import mirah.lang.ast.ImplicitSelf;
import mirah.lang.ast.Import;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.LocalAssignment;
import mirah.lang.ast.LocalDeclaration;
import mirah.lang.ast.Loop;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Named;
import mirah.lang.ast.Next;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Noop;
import mirah.lang.ast.Not;
import mirah.lang.ast.Null;
import mirah.lang.ast.OptionalArgument;
import mirah.lang.ast.Package;
import mirah.lang.ast.Position;
import mirah.lang.ast.Raise;
import mirah.lang.ast.Redo;
import mirah.lang.ast.Regex;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Rescue;
import mirah.lang.ast.RescueClause;
import mirah.lang.ast.RestArgument;
import mirah.lang.ast.Return;
import mirah.lang.ast.Script;
import mirah.lang.ast.Self;
import mirah.lang.ast.SimpleNodeVisitor;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StaticMethodDefinition;
import mirah.lang.ast.StringConcat;
import mirah.lang.ast.StringEval;
import mirah.lang.ast.Super;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.TypeNameList;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.TypeRefImpl;
import mirah.lang.ast.Unquote;
import mirah.lang.ast.UnquoteAssign;
import mirah.lang.ast.VCall;
import mirah.lang.ast.ZSuper;
import org.mirah.macros.JvmBackend;
import org.mirah.macros.MacroBuilder;
import org.mirah.typer.AssignableTypeFuture;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.BlockFuture;
import org.mirah.typer.CallFuture;
import org.mirah.typer.ClosureBuilder;
import org.mirah.typer.DelegateFuture;
import org.mirah.typer.DerivedFuture;
import org.mirah.typer.ErrorType;
import org.mirah.typer.InlineCode;
import org.mirah.typer.MethodFuture;
import org.mirah.typer.NarrowingTypeFuture;
import org.mirah.typer.PickFirst;
import org.mirah.typer.ProxyNode;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer$1;
import org.mirah.typer.Typer$10;
import org.mirah.typer.Typer$11;
import org.mirah.typer.Typer$12;
import org.mirah.typer.Typer$13;
import org.mirah.typer.Typer$14;
import org.mirah.typer.Typer$15;
import org.mirah.typer.Typer$16;
import org.mirah.typer.Typer$17;
import org.mirah.typer.Typer$2;
import org.mirah.typer.Typer$3;
import org.mirah.typer.Typer$4;
import org.mirah.typer.Typer$5;
import org.mirah.typer.Typer$6;
import org.mirah.typer.Typer$7;
import org.mirah.typer.Typer$8;
import org.mirah.typer.Typer$9;
import org.mirah.typer.UnreachableType;

public class Typer
extends SimpleNodeVisitor {
    private java.lang.Boolean trueobj = true;
    private TypeSystem types;
    private ClosureBuilder closures;
    private MacroBuilder macros;
    private static Logger log = Logger.getLogger(Typer.class.getName());
    private Scoper scopes;
    private HashMap futures = new HashMap();

    public Typer(TypeSystem types, Scoper scopes, JvmBackend jvm_backend, MirahParser parser) {
        this.types = types;
        this.scopes = scopes;
        this.closures = new ClosureBuilder(this);
        this.macros = new MacroBuilder(this, jvm_backend, parser);
    }

    public MacroBuilder macro_compiler() {
        return this.macros;
    }

    public MacroBuilder macro_compiler_set(MacroBuilder compiler) {
        this.macros = compiler;
        return this.macros;
    }

    public TypeSystem type_system() {
        return this.types;
    }

    public Scoper scoper() {
        return this.scopes;
    }

    public TypeFuture getInferredType(Node node) {
        return (TypeFuture)this.futures.get(node);
    }

    public TypeFuture inferTypeName(TypeName node) {
        HashMap $ptemp$1 = this.futures;
        TypeName $ptemp$2 = node;
        Object $or$3 = $ptemp$1.get($ptemp$2);
        if ($or$3 == null) {
            $ptemp$1.put($ptemp$2, this.getTypeOf(node, node.typeref()));
        }
        return (TypeFuture)this.futures.get(node);
    }

    public void learnType(Node node, TypeFuture type) {
        Object existing = this.futures.get(node);
        if (existing != null) {
            throw new IllegalArgumentException();
        }
        this.futures.put(node, type);
    }

    public TypeFuture infer(Node node, boolean expression) {
        Object type;
        block2: {
            log.entering("Typer", "infer", "infer(" + node + ")");
            log.fine("source:\n    " + this.sourceContent(node));
            if (node == null) {
                return null;
            }
            type = this.futures.get(node);
            if (type != null) break block2;
            type = node.accept(this, expression ? this.trueobj : null);
            HashMap $ptemp$4 = this.futures;
            Node $ptemp$5 = node;
            Object $or$6 = $ptemp$4.get($ptemp$5);
            if ($or$6 == null) {
                $ptemp$4.put($ptemp$5, type);
            }
        }
        return (TypeFuture)type;
    }

    public TypeFuture infer(Object node, boolean expression) {
        return this.infer((Node)node, expression);
    }

    public ArrayList inferAll(NodeList nodes) {
        ArrayList<TypeFuture> types = new ArrayList<TypeFuture>();
        if (nodes != null) {
            for (Object n : nodes) {
                types.add(this.infer(n));
            }
        }
        return types;
    }

    public ArrayList inferAll(AnnotationList nodes) {
        ArrayList<TypeFuture> types = new ArrayList<TypeFuture>();
        if (nodes != null) {
            for (Object n : nodes) {
                types.add(this.infer(n));
            }
        }
        return types;
    }

    public ArrayList inferAll(Arguments arguments) {
        ArrayList<TypeFuture> types;
        block7: {
            types = new ArrayList<TypeFuture>();
            if (arguments.required() != null) {
                for (Object a : arguments.required()) {
                    types.add(this.infer(a));
                }
            }
            if (arguments.optional() != null) {
                for (Object a : arguments.optional()) {
                    types.add(this.infer(a));
                }
            }
            if (arguments.rest() != null) {
                types.add(this.infer(arguments.rest()));
            }
            if (arguments.required2() != null) {
                for (Object a : arguments.required2()) {
                    types.add(this.infer(a));
                }
            }
            if (arguments.block() == null) break block7;
            types.add(this.infer(arguments.block()));
        }
        return types;
    }

    public ArrayList inferAll(Scope scope, TypeNameList typeNames) {
        ArrayList<TypeFuture> types = new ArrayList<TypeFuture>();
        for (Object n : typeNames) {
            types.add(this.inferTypeName((TypeName)n));
        }
        return types;
    }

    @Override
    public Object defaultNode(Node node, Object expression) {
        ArrayList arrayList = new ArrayList(1);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add("Inference error: unsupported node " + node);
        arrayList2.add(node.position());
        arrayList.add(arrayList2);
        return new ErrorType(arrayList);
    }

    public Logger logger() {
        return log;
    }

    @Override
    public Object visitVCall(VCall call, Object expression) {
        this.workaroundASTBug(call);
        CallFuture methodType = this.callMethodType(call, Collections.emptyList());
        TypeFuture targetType = this.infer(call.target());
        FunctionalCall fcall = new FunctionalCall(call.position(), (Identifier)call.name().clone(), null, null);
        fcall.setParent(call.parent());
        methodType = this.callMethodType(call, Collections.emptyList());
        targetType = this.infer(call.target());
        this.futures.put(fcall, methodType);
        this.futures.put(fcall.target(), targetType);
        ProxyNode proxy = new ProxyNode(this, call);
        ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>(3);
        arrayList.add(new LocalAccess(call.position(), call.name()));
        arrayList.add(fcall);
        arrayList.add(new Constant(call.position(), call.name()));
        proxy.setChildren(arrayList, 0);
        TypeFuture val0 = proxy.inferChildren(expression != null);
        this.futures.put(proxy, val0);
        return val0;
    }

    @Override
    public Object visitFunctionalCall(FunctionalCall call, Object expression) {
        this.workaroundASTBug(call);
        ArrayList parameters = this.inferParameterTypes(call);
        CallFuture methodType = this.callMethodType(call, parameters);
        this.futures.put(call, methodType);
        ProxyNode proxy = new ProxyNode(this, call);
        ArrayList<NodeImpl> children = new ArrayList<NodeImpl>(2);
        if (call.parameters().size() == 1) {
            children.add(new Cast(call.position(), call.typeref(), (Node)call.parameters().get(0).clone()));
        }
        children.add(call);
        proxy.setChildren(children);
        TypeFuture val0 = proxy.inferChildren(expression != null);
        this.futures.put(proxy, val0);
        return val0;
    }

    @Override
    public Object visitElemAssign(ElemAssign assignment, Object expression) {
        Node newNode;
        TypeFuture value_type = this.infer(assignment.value());
        Node value = assignment.value();
        assignment.removeChild(value);
        if (value_type instanceof NarrowingTypeFuture) {
            this.narrowingCall(this.scopeOf(assignment), this.infer(assignment.target()), "[]=", this.inferAll(assignment.args()), (NarrowingTypeFuture)value_type, assignment.position());
        }
        Call call = new Call(assignment.position(), assignment.target(), new SimpleString("[]="), null, null);
        call.parameters_set(assignment.args());
        if (expression != null) {
            String temp = this.scopeOf(assignment).temp("val");
            call.parameters().add(new LocalAccess(new SimpleString(temp)));
            ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>(3);
            arrayList.add(new LocalAssignment(new SimpleString(temp), value));
            arrayList.add(call);
            arrayList.add(new LocalAccess(new SimpleString(temp)));
            newNode = new NodeList(arrayList);
        } else {
            call.parameters().add(value);
            newNode = call;
        }
        newNode = this.replaceSelf(assignment, newNode);
        return this.infer(newNode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitCall(Call call, Object object) {
        void expression;
        void call2;
        Object var9_3 = null;
        TypeFuture target = this.infer(call2.target());
        ArrayList parameters = this.inferParameterTypes((CallSite)call2);
        CallFuture methodType = new CallFuture(this.types, this.scopeOf((Node)call2), target, true, parameters, (CallSite)call2);
        this.futures.put(call2, methodType);
        ProxyNode proxy = new ProxyNode(this, (Node)call2);
        ArrayList<Object> children = new ArrayList<Object>(2);
        if (call2.parameters().size() == 1) {
            TypeRef typeref;
            boolean is_array = "[]".equals(call2.name().identifier());
            if (is_array) {
                if (call2.target() instanceof TypeName) {
                    typeref = ((TypeName)call2.target()).typeref();
                }
            } else {
                typeref = call2.typeref(true);
            }
            if (typeref != null) {
                children.add(is_array ? new EmptyArray(call2.position(), typeref, call2.parameters(0)) : new Cast(call2.position(), typeref, (Node)call2.parameters(0).clone()));
            }
        }
        children.add(call2);
        proxy.setChildren(children);
        TypeFuture val0 = proxy.inferChildren(expression != null);
        this.futures.put(proxy, val0);
        return val0;
    }

    @Override
    public Object visitAttrAssign(AttrAssign call, Object expression) {
        TypeFuture target = this.infer(call.target());
        TypeFuture value = this.infer(call.value());
        String name = call.name().identifier();
        String setter = name + "_set";
        Scope scope = this.scopeOf(call);
        if (value instanceof NarrowingTypeFuture) {
            this.narrowingCall(scope, target, setter, Collections.emptyList(), (NarrowingTypeFuture)value, call.position());
        }
        ArrayList<TypeFuture> arrayList = new ArrayList<TypeFuture>(1);
        arrayList.add(value);
        return new CallFuture(this.types, scope, target, true, setter, arrayList, null, call.position());
    }

    public void narrowingCall(Scope scope, TypeFuture target, String name, List param_types, NarrowingTypeFuture value, Position position) {
        new Typer$1().value = value;
        Typer$1 typer$1 = new Typer$1();
        LinkedList<BaseTypeFuture> wide_params = new LinkedList<BaseTypeFuture>(param_types);
        wide_params.add(typer$1.value.wide_future());
        CallFuture wide_call = new CallFuture(this.types, scope, target, true, name, wide_params, null, position);
        LinkedList<BaseTypeFuture> narrow_params = new LinkedList<BaseTypeFuture>(param_types);
        narrow_params.add(typer$1.value.narrow_future());
        CallFuture narrow_call = new CallFuture(this.types, scope, target, true, name, narrow_params, null, position);
        typer$1.wide_is_error = true;
        typer$1.narrow_is_error = true;
        wide_call.onUpdate(new Typer$2(typer$1));
        narrow_call.onUpdate(new Typer$3(typer$1));
    }

    @Override
    public Object visitCast(Cast cast, Object expression) {
        this.infer(cast.value());
        return this.getTypeOf(cast, cast.type().typeref());
    }

    @Override
    public Object visitColon2(Colon2 colon2, Object expression) {
        return this.types.getMetaType(this.getTypeOf(colon2, colon2.typeref()));
    }

    @Override
    public Object visitSuper(Super node, Object expression) {
        MethodDefinition method = (MethodDefinition)node.findAncestor(MethodDefinition.class);
        Scope scope = this.scopeOf(node);
        TypeFuture target = this.types.getSuperClass(scope.selfType());
        ArrayList parameters = this.inferParameterTypes(node);
        return new CallFuture(this.types, scope, target, true, method.name().identifier(), parameters, null, node.position());
    }

    @Override
    public Object visitZSuper(ZSuper node, Object expression) {
        MethodDefinition method = (MethodDefinition)node.findAncestor(MethodDefinition.class);
        LinkedList<LocalAccess> locals = new LinkedList<LocalAccess>();
        ArrayList<NodeImpl> arrayList = new ArrayList<NodeImpl>(3);
        arrayList.add(method.arguments().required());
        arrayList.add(method.arguments().optional());
        arrayList.add(method.arguments().required2());
        for (NodeImpl args : arrayList) {
            for (Object arg : (Iterable)((Object)args)) {
                FormalArgument farg = (FormalArgument)arg;
                LocalAccess local = new LocalAccess(farg.position(), farg.name());
                this.scopes.copyScopeFrom(farg, local);
                this.infer(local, true);
                locals.add(local);
            }
        }
        Super replacement = new Super(node.position(), locals, null);
        return this.infer(this.replaceSelf(node, replacement), expression != null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitClassDefinition(ClassDefinition classDefinition, Object object) {
        TypeFuture type;
        block2: {
            TypeFuture superclass;
            void classdef;
            Object var7_3 = null;
            for (Object a : classdef.annotations()) {
                this.infer(a);
            }
            Scope scope = this.scopeOf((Node)classdef);
            ArrayList interfaces = this.inferAll(scope, classdef.interfaces());
            if (classdef.superclass() != null) {
                superclass = this.types.get(scope, classdef.superclass().typeref());
            }
            String name = classdef.name() != null ? classdef.name().identifier() : null;
            type = this.types.defineType(scope, (Node)classdef, name, superclass, interfaces);
            this.addScopeWithSelfType((Node)classdef, type);
            if (classdef.body() == null) break block2;
            this.infer(classdef.body(), false);
        }
        return type;
    }

    @Override
    public Object visitClosureDefinition(ClosureDefinition classdef, Object expression) {
        return this.visitClassDefinition(classdef, expression);
    }

    @Override
    public Object visitInterfaceDeclaration(InterfaceDeclaration idef, Object expression) {
        return this.visitClassDefinition(idef, expression);
    }

    @Override
    public Object visitFieldDeclaration(FieldDeclaration decl, Object expression) {
        this.inferAnnotations(decl);
        return this.getFieldType((Named)decl, decl.isStatic()).declare(this.getTypeOf(decl, decl.type().typeref()), decl.position());
    }

    @Override
    public Object visitFieldAssign(FieldAssign field, Object expression) {
        this.inferAnnotations(field);
        TypeFuture value = this.infer(field.value(), true);
        return this.getFieldType((Named)field, field.isStatic()).assign(value, field.position());
    }

    @Override
    public Object visitFieldAccess(FieldAccess field, Object expression) {
        TypeFuture typeFuture;
        TypeFuture targetType = this.fieldTargetType(field, field.isStatic());
        if (targetType == null) {
            ArrayList arrayList = new ArrayList(1);
            ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
            arrayList2.add("Cannot find declaring class for field.");
            arrayList2.add(field.position());
            arrayList.add(arrayList2);
            typeFuture = new ErrorType(arrayList);
        } else {
            typeFuture = this.getFieldType((Named)field, targetType);
        }
        return typeFuture;
    }

    @Override
    public Object visitConstant(Constant constant, Object expression) {
        return this.types.getMetaType(this.getTypeOf(constant, constant.typeref()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitIf(If if_, Object object) {
        TypeFuture typeFuture;
        TypeFuture b;
        TypeFuture a;
        void expression;
        void stmt;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var6_5 = null;
        this.infer(stmt.condition(), true);
        if (stmt.body() != null) {
            a = this.infer(stmt.body(), expression != null);
        }
        if (stmt.elseBody() != null) {
            b = this.infer(stmt.elseBody(), expression != null);
        }
        if (((expression != null ? a : null) != null ? b : null) != null) {
            AssignableTypeFuture type = new AssignableTypeFuture(stmt.position());
            type.assign(a, stmt.body().position());
            type.assign(b, stmt.elseBody().position());
            typeFuture = type;
        } else {
            TypeFuture $or$7 = a;
            typeFuture = $or$7 != null ? $or$7 : b;
        }
        return typeFuture;
    }

    @Override
    public Object visitLoop(Loop node, Object expression) {
        this.enhanceLoop(node);
        this.infer(node.condition(), true);
        this.infer(node.body(), false);
        this.infer(node.init(), false);
        this.infer(node.pre(), false);
        this.infer(node.post(), false);
        return this.types.getNullType();
    }

    @Override
    public Object visitReturn(Return node, Object expression) {
        TypeFuture typeFuture;
        Typer$4 typer$4 = new Typer$4();
        TypeFuture type = node.value() != null ? this.infer(node.value()) : this.types.getVoidType();
        Node enclosing_node = node.findAncestor(new Typer$5(typer$4));
        if (enclosing_node instanceof MethodDefinition) {
            TypeFuture methodType = this.infer(enclosing_node);
            typer$4.returnType = ((MethodFuture)methodType).returnType();
            typer$4.assignment = typer$4.returnType.assign(type, node.position());
            typer$4.future = new DelegateFuture();
            typer$4.future.type_set(typer$4.returnType);
            typer$4.assignment.onUpdate(new Typer$6(typer$4));
            typeFuture = typer$4.future;
        } else {
            typeFuture = enclosing_node instanceof Script ? this.types.getVoidType() : null;
        }
        return typeFuture;
    }

    @Override
    public Object visitBreak(Break node, Object expression) {
        return this.types.getNullType();
    }

    @Override
    public Object visitNext(Next node, Object expression) {
        return this.types.getNullType();
    }

    @Override
    public Object visitRedo(Redo node, Object expression) {
        return this.types.getNullType();
    }

    @Override
    public Object visitRaise(Raise node, Object expression) {
        new Typer$7().node = node;
        Typer$7 typer$7 = new Typer$7();
        NodeList old_args = typer$7.node.args();
        typer$7.node.args_set(new NodeList(typer$7.node.args().position()));
        ArrayList<String> possibilities = new ArrayList<String>();
        ArrayList exceptions = new ArrayList();
        if (old_args.size() == 1) {
            exceptions.addAll(this.buildNodeAndTypeForRaiseTypeOne(old_args, typer$7.node));
            possibilities.add("1");
        }
        if (old_args.size() > 0) {
            exceptions.addAll(this.buildNodeAndTypeForRaiseTypeTwo(old_args, typer$7.node));
            possibilities.add("2");
        }
        exceptions.addAll(this.buildNodeAndTypeForRaiseTypeThree(old_args, typer$7.node));
        possibilities.add("3");
        typer$7.log = this.logger();
        typer$7.log.finest("possibilities " + possibilities);
        for (Object e : exceptions) {
            typer$7.log.finest("type possible " + e + " for raise");
        }
        PickFirst exceptionPicker = new PickFirst(exceptions, new Typer$8(typer$7));
        AssignableTypeFuture exceptionType = new AssignableTypeFuture(typer$7.node.position());
        exceptionType.declare(this.types.getBaseExceptionType(), typer$7.node.position());
        TypeFuture assignment = exceptionType.assign(exceptionPicker, typer$7.node.position());
        typer$7.myType = new BaseTypeFuture(typer$7.node.position());
        typer$7.unreachable = new UnreachableType();
        assignment.onUpdate(new Typer$9(typer$7));
        return typer$7.myType;
    }

    @Override
    public Object visitRescueClause(RescueClause clause, Object expression) {
        if (clause.types_size() == 0) {
            clause.types().add(new TypeRefImpl(this.defaultExceptionTypeName(), false, false, clause.position()));
        }
        Scope scope = this.addNestedScope(clause);
        Identifier name = clause.name();
        if (name != null) {
            scope.shadow(name.identifier());
            AssignableTypeFuture exceptionType = this.types.getLocalType(scope, name.identifier(), name.position());
            for (Object _t : clause.types()) {
                TypeName t = (TypeName)_t;
                exceptionType.assign(this.inferTypeName(t), t.position());
            }
        } else {
            this.inferAll(scope.parent(), clause.types());
        }
        return this.infer(clause.body(), expression != null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitRescue(Rescue rescue, Object object) {
        AssignableTypeFuture myType;
        TypeFuture elseType;
        TypeFuture bodyType;
        void expression;
        boolean hasElse;
        void node;
        boolean $or$9;
        Object var6_3 = null;
        Object var5_4 = null;
        Object var7_5 = null;
        boolean bl = $or$9 = node.elseClause() == null;
        boolean bl2 = hasElse = !($or$9 ? $or$9 : node.elseClause().size() == 0);
        if (node.body() != null) {
            bodyType = this.infer(node.body(), expression != null ? !hasElse : false);
        }
        if (hasElse) {
            elseType = this.infer(node.elseClause(), expression != null);
        }
        if (expression != null) {
            myType = new AssignableTypeFuture(node.position());
            if (hasElse) {
                myType.assign(elseType, node.elseClause().position());
            } else {
                myType.assign(bodyType, node.body().position());
            }
        }
        for (Object clause : node.clauses()) {
            TypeFuture clauseType = this.infer(clause, expression != null);
            if (expression == null) continue;
            myType.assign(clauseType, ((Node)clause).position());
        }
        TypeFuture $or$10 = myType;
        return $or$10 != null ? $or$10 : this.types.getNullType();
    }

    @Override
    public Object visitEnsure(Ensure node, Object expression) {
        this.infer(node.ensureClause(), false);
        return this.infer(node.body(), expression != null);
    }

    @Override
    public Object visitArray(Array array, Object expression) {
        this.mergeUnquotes(array.values());
        AssignableTypeFuture component = new AssignableTypeFuture(array.position());
        for (Object v : array.values()) {
            Node node = (Node)v;
            component.assign(this.infer(node, true), node.position());
        }
        return this.types.getArrayLiteralType(component, array.position());
    }

    @Override
    public Object visitFixnum(Fixnum fixnum, Object expression) {
        return this.types.getFixnumType(fixnum.value());
    }

    @Override
    public Object visitFloat(Float number, Object expression) {
        return this.types.getFloatType(number.value());
    }

    @Override
    public Object visitNot(Not node, Object expression) {
        new Typer$10().node = node;
        Typer$10 typer$10 = new Typer$10();
        typer$10.type = new BaseTypeFuture(typer$10.node.position());
        typer$10.null_type = this.types.getNullType().resolve();
        typer$10.boolean_type = this.types.getBooleanType().resolve();
        this.infer(typer$10.node.value()).onUpdate(new Typer$11(typer$10));
        return typer$10.type;
    }

    @Override
    public Object visitHash(Hash hash, Object expression) {
        AssignableTypeFuture keyType = new AssignableTypeFuture(hash.position());
        AssignableTypeFuture valueType = new AssignableTypeFuture(hash.position());
        for (Object e : hash) {
            HashEntry entry = (HashEntry)e;
            keyType.assign(this.infer(entry.key(), true), entry.key().position());
            valueType.assign(this.infer(entry.value(), true), entry.value().position());
            this.infer(entry, false);
        }
        return this.types.getHashLiteralType(keyType, valueType, hash.position());
    }

    @Override
    public Object visitHashEntry(HashEntry entry, Object expression) {
        return this.types.getVoidType();
    }

    @Override
    public Object visitRegex(Regex regex, Object expression) {
        for (Object r : regex.strings()) {
            this.infer(r);
        }
        return this.types.getRegexType();
    }

    @Override
    public Object visitSimpleString(SimpleString string, Object expression) {
        return this.types.getStringType();
    }

    @Override
    public Object visitStringConcat(StringConcat string, Object expression) {
        for (Object s : string.strings()) {
            this.infer(s);
        }
        return this.types.getStringType();
    }

    @Override
    public Object visitStringEval(StringEval string, Object expression) {
        this.infer(string.value());
        return this.types.getStringType();
    }

    @Override
    public Object visitBoolean(Boolean bool, Object expression) {
        return this.types.getBooleanType();
    }

    @Override
    public Object visitNull(Null node, Object expression) {
        return this.types.getNullType();
    }

    @Override
    public Object visitCharLiteral(CharLiteral node, Object expression) {
        return this.types.getCharType(node.value());
    }

    @Override
    public Object visitSelf(Self node, Object expression) {
        return this.scopeOf(node).selfType();
    }

    @Override
    public Object visitTypeRefImpl(TypeRefImpl typeref, Object expression) {
        return this.getTypeOf(typeref, typeref);
    }

    @Override
    public Object visitLocalDeclaration(LocalDeclaration decl, Object expression) {
        TypeFuture type = this.getTypeOf(decl, decl.type().typeref());
        return this.getLocalType(decl).declare(type, decl.position());
    }

    @Override
    public Object visitLocalAssignment(LocalAssignment local, Object expression) {
        TypeFuture value = this.infer(local.value(), true);
        return this.getLocalType(local).assign(value, local.position());
    }

    @Override
    public Object visitLocalAccess(LocalAccess local, Object expression) {
        return this.getLocalType(local);
    }

    @Override
    public Object visitNodeList(NodeList body, Object expression) {
        for (int i = 0; i < body.size() - 1; ++i) {
            this.infer(body.get(i), false);
        }
        return body.size() > 0 ? this.infer(body.get(body.size() - 1), expression != null) : this.types.getImplicitNilType();
    }

    @Override
    public Object visitClassAppendSelf(ClassAppendSelf node, Object expression) {
        this.addScopeWithSelfType(node, this.types.getMetaType(this.scopeOf(node).selfType()));
        this.infer(node.body(), false);
        return this.types.getNullType();
    }

    @Override
    public Object visitNoop(Noop noop, Object expression) {
        return this.types.getVoidType();
    }

    @Override
    public Object visitScript(Script script, Object expression) {
        Scope scope = this.addScopeUnder(script);
        this.types.addDefaultImports(scope);
        scope.selfType_set(this.types.getMainType(scope, script));
        this.infer(script.body(), false);
        return this.types.getVoidType();
    }

    @Override
    public Object visitAnnotation(Annotation anno, Object expression) {
        int i = 0;
        int gensym0 = anno.values_size();
        if (i < gensym0) {
            do {
                this.infer(anno.values(i).value());
            } while (++i < gensym0);
        }
        return this.getTypeOf(anno, anno.type().typeref());
    }

    @Override
    public Object visitImport(Import node, Object expression) {
        TypeFuture typeFuture;
        Typer$12 typer$12 = new Typer$12();
        Scope scope = this.scopeOf(node);
        String fullName = node.fullName().identifier();
        String simpleName = node.simpleName().identifier();
        if (".*".equals(simpleName)) {
            TypeFuture type = this.types.getMetaType(this.types.get(scope, ((TypeName)((Object)node.fullName())).typeref()));
            scope.staticImport(type);
            typeFuture = type;
        } else {
            scope.import(fullName, simpleName);
            typeFuture = "*".equals(simpleName) ? null : this.types.get(scope, ((TypeName)((Object)node.fullName())).typeref());
        }
        TypeFuture imported_type = typeFuture;
        typer$12.void_type = this.types.getVoidType();
        return imported_type != null ? new DerivedFuture(imported_type, new Typer$13(typer$12)) : typer$12.void_type;
    }

    @Override
    public Object visitPackage(Package node, Object expression) {
        if (node.body() != null) {
            Scope scope = this.addScopeUnder(node);
            scope.package_set(node.name().identifier());
            this.infer(node.body(), false);
        } else {
            Scope scope = this.scopeOf(node);
            scope.package_set(node.name().identifier());
        }
        return this.types.getVoidType();
    }

    @Override
    public Object visitEmptyArray(EmptyArray node, Object expression) {
        this.infer(node.size());
        return this.types.getArrayType(this.getTypeOf(node, node.type().typeref()));
    }

    @Override
    public Object visitUnquote(Unquote node, Object expression) {
        List nodes = node.nodes();
        Node replacement = nodes.size() == 1 ? (Node)nodes.get(0) : new NodeList(node.position(), nodes);
        replacement = this.replaceSelf(node, replacement);
        return this.infer(replacement, expression != null);
    }

    @Override
    public Object visitUnquoteAssign(UnquoteAssign node, Object expression) {
        Node replacement = null;
        Object object = node.unquote().object();
        if (object instanceof FieldAccess) {
            FieldAccess fa = (FieldAccess)((Object)node.name());
            replacement = new FieldAssign(fa.position(), fa.name(), node.value(), null);
        } else {
            replacement = new LocalAssignment(node.position(), node.name(), node.value());
        }
        replacement = this.replaceSelf(node, replacement);
        return this.infer(replacement, expression != null);
    }

    @Override
    public Object visitArguments(Arguments args, Object expression) {
        this.mergeUnquotedArgs(args);
        this.inferAll(args);
        return this.types.getVoidType();
    }

    public void mergeUnquotedArgs(Arguments args) {
        ListIterator it = args.required().listIterator();
        this.mergeArgs(args, it, it, args.optional().listIterator(args.optional_size()), args.required2().listIterator(args.required2_size()));
        it = args.optional().listIterator();
        this.mergeArgs(args, it, args.required().listIterator(args.required_size()), it, args.required2().listIterator(args.required2_size()));
        it = args.required().listIterator();
        this.mergeArgs(args, it, args.required().listIterator(args.required_size()), args.optional().listIterator(args.optional_size()), it);
    }

    public void mergeArgs(Arguments args, ListIterator it, ListIterator req, ListIterator opt, ListIterator req2) {
        while (it.hasNext()) {
            Unquote unquote;
            Arguments new_args;
            FormalArgument arg = (FormalArgument)it.next();
            Identifier name = arg.name();
            if (!(name instanceof Unquote) || arg.type() != null || (new_args = (unquote = (Unquote)name).arguments()) == null) continue;
            it.remove();
            boolean bl = ((it == req2 ? new_args.optional().size() == 0 : false) ? new_args.rest() == null : false) ? new_args.required2().size() == 0 : false;
            if (bl) {
                this.mergeIterators(new_args.required().listIterator(), req2);
            } else {
                this.mergeIterators(new_args.required().listIterator(), req);
                this.mergeIterators(new_args.optional().listIterator(), opt);
                this.mergeIterators(new_args.required2().listIterator(), req2);
            }
            if (new_args.rest() != null) {
                if (args.rest() != null) {
                    throw new IllegalArgumentException("Only one rest argument allowed.");
                }
                RestArgument rest = new_args.rest();
                new_args.rest_set(null);
                args.rest_set(rest);
            }
            if (new_args.block() == null) continue;
            if (args.block() != null) {
                throw new IllegalArgumentException("Only one block argument allowed");
            }
            BlockArgument block = new_args.block();
            new_args.block_set(null);
            args.block_set(block);
        }
    }

    public void mergeIterators(ListIterator source, ListIterator dest) {
        while (source.hasNext()) {
            Object a = source.next();
            source.remove();
            dest.add(a);
        }
    }

    public void mergeUnquotes(NodeList list) {
        ListIterator it = list.listIterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof Unquote)) continue;
            it.remove();
            for (Object node : ((Unquote)item).nodes()) {
                it.add(node);
            }
        }
    }

    @Override
    public Object visitRequiredArgument(RequiredArgument arg, Object expression) {
        return this.getArgumentType(arg);
    }

    @Override
    public Object visitOptionalArgument(OptionalArgument arg, Object expression) {
        AssignableTypeFuture type = this.getArgumentType(arg);
        type.assign(this.infer(arg.value()), arg.value().position());
        return type;
    }

    @Override
    public Object visitRestArgument(RestArgument arg, Object expression) {
        return arg.type() != null ? this.getLocalType(arg).declare(this.types.getArrayType(this.getTypeOf(arg, arg.type().typeref())), arg.type().position()) : this.getLocalType(arg);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitMethodDefinition(MethodDefinition methodDefinition, Object object) {
        TypeFuture returnType;
        void mdef;
        Object var4_3 = null;
        log.entering("Typer", "visitMethodDefinition", mdef);
        this.addScopeForMethod((MethodDefinition)mdef);
        this.inferAll(mdef.annotations());
        this.infer(mdef.arguments());
        ArrayList parameters = this.inferAll(mdef.arguments());
        if (mdef.type() != null) {
            returnType = this.getTypeOf((Node)mdef, mdef.type().typeref());
        }
        TypeFuture selfType = this.selfTypeOf((MethodDefinition)mdef);
        MethodFuture type = this.types.getMethodDefType(selfType, mdef.name().identifier(), parameters, returnType, mdef.name().position());
        this.futures.put(mdef, type);
        this.declareOptionalMethods(selfType, (MethodDefinition)mdef, parameters, type.returnType());
        if (this.isVoid(type)) {
            this.infer(mdef.body(), false);
            type.returnType().assign(this.types.getVoidType(), mdef.position());
        } else {
            type.returnType().assign(this.infer(mdef.body()), mdef.body().position());
        }
        return type;
    }

    public void declareOptionalMethods(TypeFuture target, MethodDefinition mdef, List argTypes, TypeFuture type) {
        block2: {
            int gensym0;
            if (mdef.arguments().optional_size() <= 0) break block2;
            ArrayList args = new ArrayList(argTypes);
            int first_optional_arg = mdef.arguments().required_size();
            int last_optional_arg = first_optional_arg + mdef.arguments().optional_size() - 1;
            int i = last_optional_arg;
            if (i >= (gensym0 = first_optional_arg)) {
                do {
                    args.remove(i);
                    this.types.getMethodDefType(target, mdef.name().identifier(), args, type, mdef.name().position());
                } while (--i >= gensym0);
            }
        }
    }

    @Override
    public Object visitStaticMethodDefinition(StaticMethodDefinition mdef, Object expression) {
        return this.visitMethodDefinition(mdef, expression);
    }

    @Override
    public Object visitConstructorDefinition(ConstructorDefinition mdef, Object expression) {
        return this.visitMethodDefinition(mdef, expression);
    }

    @Override
    public Object visitImplicitNil(ImplicitNil node, Object expression) {
        return this.types.getImplicitNilType();
    }

    @Override
    public Object visitImplicitSelf(ImplicitSelf node, Object expression) {
        return this.scopeOf(node).selfType();
    }

    @Override
    public Object visitBlock(Block block, Object expression) {
        new Typer$14().block = block;
        Typer$14 typer$14 = new Typer$14();
        this.expandUnquotedBlockArgs(typer$14.block);
        if (typer$14.block.arguments() != null) {
            this.mergeUnquotedArgs(typer$14.block.arguments());
        }
        typer$14.closures = this.closures;
        typer$14.typer = this;
        return new BlockFuture(typer$14.block, new Typer$15(typer$14));
    }

    public void expandUnquotedBlockArgs(Block block) {
        this.expandPipedUnquotedBlockArgs(block);
        this.expandUnpipedUnquotedBlockArgs(block);
    }

    public void expandPipedUnquotedBlockArgs(Block block) {
        if (block.arguments() == null) {
            return;
        }
        if (block.arguments().required_size() == 0) {
            return;
        }
        if (!(block.arguments().required(0).name() instanceof Unquote)) {
            return;
        }
        Unquote unquote_arg = (Unquote)block.arguments().required(0).name();
        if (!(unquote_arg.object() instanceof Arguments)) {
            return;
        }
        log.finest("Block: expanding unquoted arguments with pipes");
        Arguments unquoted_args = (Arguments)unquote_arg.object();
        block.arguments_set(unquoted_args);
        unquoted_args.setParent(block);
    }

    public void expandUnpipedUnquotedBlockArgs(Block block) {
        boolean $or$13;
        if (block.arguments() != null) {
            return;
        }
        boolean bl = $or$13 = block.body() == null;
        if ($or$13 ? $or$13 : block.body().size() == 0) {
            return;
        }
        if (!(block.body().get(0) instanceof Unquote)) {
            return;
        }
        Unquote unquoted_first_element = (Unquote)block.body().get(0);
        if (!(unquoted_first_element.object() instanceof Arguments)) {
            return;
        }
        log.finest("Block: expanding unquoted arguments with no pipes");
        Arguments unquoted_args = (Arguments)unquoted_first_element.object();
        block.arguments_set(unquoted_args);
        unquoted_args.setParent(block);
        block.body().removeChild(block.body().get(0));
    }

    public boolean contains_methods(Block block) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                return true;
            } while (++i < gensym0);
        }
        return false;
    }

    @Override
    public Object visitBindingReference(BindingReference ref, Object expression) {
        ResolvedType binding = this.scopeOf(ref).binding_type();
        BaseTypeFuture future = new BaseTypeFuture();
        future.resolved(binding);
        return future;
    }

    @Override
    public Object visitMacroDefinition(MacroDefinition defn, Object expression) {
        this.macros.buildExtension(defn);
        return this.types.getVoidType();
    }

    public void enhanceLoop(Loop node) {
        ListIterator it = node.body().listIterator();
        while (it.hasNext()) {
            Object child = it.next();
            if (child instanceof FunctionalCall) {
                NodeList target_list;
                boolean $or$15;
                boolean $or$14;
                String string;
                FunctionalCall call = (FunctionalCall)child;
                try {
                    string = call.name().identifier();
                }
                catch (Exception exception) {
                    string = null;
                }
                String name = string;
                boolean bl = $or$14 = name == null;
                boolean bl2 = $or$14 ? $or$14 : ($or$15 = call.parameters_size() != 0);
                if ($or$15 ? $or$15 : call.block() == null) {
                    return;
                }
                NodeList nodeList = name.equals("init") ? node.init() : (name.equals("pre") ? node.pre() : (target_list = name.equals("post") ? node.post() : (NodeList)null));
                if (target_list != null) {
                    it.remove();
                    target_list.add(call.block().body());
                    continue;
                }
                return;
            }
            return;
        }
    }

    public List buildNodeAndTypeForRaiseTypeOne(NodeList old_args, Node node) {
        Typer$16 typer$16 = new Typer$16();
        Node exception_node = (Node)old_args.clone();
        exception_node.setParent(node);
        typer$16.new_type = new BaseTypeFuture(exception_node.position());
        ArrayList arrayList = new ArrayList(1);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add("Not an expression");
        arrayList2.add(exception_node.position());
        arrayList.add(arrayList2);
        typer$16.error = new ErrorType(arrayList);
        this.infer(exception_node).onUpdate(new Typer$17(typer$16));
        exception_node.setParent(null);
        AssignableTypeFuture exceptionType = new AssignableTypeFuture(exception_node.position());
        exceptionType.declare(this.types.getBaseExceptionType(), node.position());
        TypeFuture assignment = exceptionType.assign(typer$16.new_type, node.position());
        ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
        arrayList3.add(assignment);
        arrayList3.add(exception_node);
        return arrayList3;
    }

    public List buildNodeAndTypeForRaiseTypeTwo(NodeList old_args, Node node) {
        Node targetNode = (Node)old_args.get(0).clone();
        ArrayList<Object> params = new ArrayList<Object>();
        int i = 1;
        int gensym0 = old_args.size() - 1;
        if (i <= gensym0) {
            do {
                params.add(old_args.get(i).clone());
            } while (++i <= gensym0);
        }
        Call call = new Call(node.position(), targetNode, new SimpleString(node.position(), "new"), params, null);
        ArrayList<Call> arrayList = new ArrayList<Call>(1);
        arrayList.add(call);
        NodeList wrapper = new NodeList(arrayList);
        this.scopes.copyScopeFrom(node, wrapper);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add(this.infer(wrapper));
        arrayList2.add(wrapper);
        return arrayList2;
    }

    public List buildNodeAndTypeForRaiseTypeThree(NodeList old_args, Node node) {
        Constant targetNode = new Constant(node.position(), new SimpleString(node.position(), this.defaultExceptionTypeName()));
        ArrayList<Object> params = new ArrayList<Object>();
        for (Object a : old_args) {
            params.add(((Node)a).clone());
        }
        Call call = new Call(node.position(), targetNode, new SimpleString(node.position(), "new"), params, null);
        ArrayList<Call> arrayList = new ArrayList<Call>(1);
        arrayList.add(call);
        NodeList wrapper = new NodeList(arrayList);
        this.scopes.copyScopeFrom(node, wrapper);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add(this.infer(wrapper));
        arrayList2.add(wrapper);
        return arrayList2;
    }

    public String defaultExceptionTypeName() {
        return this.types.getDefaultExceptionType().resolve().name();
    }

    public TypeFuture selfTypeOf(MethodDefinition mdef) {
        TypeFuture selfType;
        block0: {
            selfType = this.scopeOf(mdef).selfType();
            if (!(mdef instanceof StaticMethodDefinition)) break block0;
            selfType = this.types.getMetaType(selfType);
        }
        return selfType;
    }

    public void addScopeForMethod(MethodDefinition mdef) {
        Scope scope = this.addScopeWithSelfType(mdef, this.selfTypeOf(mdef));
        scope.resetDefaultSelfNode();
    }

    public Scope addScopeWithSelfType(Node node, TypeFuture selfType) {
        Scope scope = this.addScopeUnder(node);
        scope.selfType_set(selfType);
        return scope;
    }

    public boolean isVoid(MethodFuture type) {
        return type.returnType().isResolved() ? this.types.getVoidType().resolve().equals(type.returnType().resolve()) : false;
    }

    public AssignableTypeFuture getLocalType(Named local) {
        return this.getLocalType(local, local.name().identifier());
    }

    public AssignableTypeFuture getLocalType(Node arg, String identifier) {
        return this.types.getLocalType(this.scopeOf(arg), identifier, arg.position());
    }

    public Scope scopeOf(Node node) {
        return this.scopes.getScope(node);
    }

    public Scope addScopeUnder(Node node) {
        return this.scopes.addScope(node);
    }

    public AssignableTypeFuture getArgumentType(FormalArgument arg) {
        AssignableTypeFuture type;
        block0: {
            type = this.getLocalType(arg);
            if (arg.type() == null) break block0;
            type.declare(this.getTypeOf(arg, arg.type().typeref()), arg.type().position());
        }
        return type;
    }

    public TypeFuture getTypeOf(Node node, TypeRef typeref) {
        return this.types.get(this.scopeOf(node), typeref);
    }

    public TypeFuture inferCallTarget(Node target, Scope scope) {
        TypeFuture targetType;
        block0: {
            targetType = this.infer(target);
            if (!(scope.context() instanceof ClassDefinition)) break block0;
            targetType = this.types.getMetaType(targetType);
        }
        return targetType;
    }

    public Scope addNestedScope(Node node) {
        Scope scope = this.addScopeUnder(node);
        scope.parent_set(this.scopeOf(node));
        return scope;
    }

    public CallFuture callMethodType(CallSite call, List parameters) {
        Scope scope = this.scopeOf(call);
        TypeFuture targetType = this.inferCallTarget(call.target(), scope);
        CallFuture methodType = new CallFuture(this.types, scope, targetType, false, parameters, call);
        return methodType;
    }

    public Object inferAnnotations(Annotated annotated) {
        for (Object a : annotated.annotations()) {
            this.infer(a);
        }
        return null;
    }

    public ArrayList inferParameterTypes(CallSite call) {
        ArrayList parameters;
        block0: {
            this.mergeUnquotes(call.parameters());
            parameters = this.inferAll(call.parameters());
            if (call.block() == null) break block0;
            parameters.add(this.infer(call.block(), true));
        }
        return parameters;
    }

    public ArrayList inferParameterTypes(Super call) {
        ArrayList parameters;
        block0: {
            this.mergeUnquotes(call.parameters());
            parameters = this.inferAll(call.parameters());
            if (call.block() == null) break block0;
            parameters.add(this.infer(call.block(), true));
        }
        return parameters;
    }

    public TypeFuture fieldTargetType(Named field, boolean isStatic) {
        TypeFuture targetType = this.scopeOf(field).selfType();
        if (targetType == null) {
            return null;
        }
        return isStatic ? this.types.getMetaType(targetType) : targetType;
    }

    public AssignableTypeFuture getFieldType(Named field, boolean isStatic) {
        return this.getFieldType(field, this.fieldTargetType(field, isStatic));
    }

    public AssignableTypeFuture getFieldType(Named field, TypeFuture targetType) {
        return this.types.getFieldType(targetType, field.name().identifier(), field.position());
    }

    public Node expandMacro(Node node, ResolvedType inline_type) {
        this.logger().fine("Expanding macro " + node);
        return ((InlineCode)inline_type).expand(node, this);
    }

    public Node replaceAndInfer(DelegateFuture future, Node current_node, Node replacement, boolean expression) {
        Node node = this.replaceSelf(current_node, replacement);
        future.type_set(this.infer(node, expression));
        return node;
    }

    public Node replaceSelf(Node me, Node replacement) {
        return me.parent().replaceChild(me, replacement);
    }

    public boolean isMacro(ResolvedType resolvedType) {
        return resolvedType instanceof InlineCode;
    }

    public Node expandAndReplaceMacro(DelegateFuture future, Node current_node, Node fcall, ResolvedType picked_type, boolean expression) {
        return current_node.parent() != null ? this.replaceAndInfer(future, current_node, this.expandMacro(fcall, picked_type), expression) : null;
    }

    public Node workaroundASTBug(CallSite call) {
        Node node = call.target();
        node.setParent(call);
        return node;
    }

    public String sourceContent(Node node) {
        return this.sourceContent(node.position());
    }

    public String sourceContent(Position pos) {
        String string;
        boolean $or$17;
        boolean $or$16;
        boolean bl = $or$16 = pos == null;
        if ($or$16 ? $or$16 : pos.source() == null) {
            return "<source non-existent>";
        }
        boolean bl2 = $or$17 = pos.startChar() < 0;
        if ($or$17 ? $or$17 : pos.endChar() < 0) {
            return "<source start/end negative start:" + pos.startChar() + " end:" + pos.endChar() + ">";
        }
        if (pos.startChar() > pos.endChar()) {
            return "<source start after end start:" + pos.startChar() + " end:" + pos.endChar() + ">";
        }
        try {
            string = pos.source().substring(pos.startChar(), pos.endChar());
        }
        catch (Exception e$662497287) {
            string = "<error getting source: " + e$662497287 + "  start:" + pos.startChar() + " end:" + pos.endChar() + ">";
        }
        return string;
    }

    public Typer(TypeSystem types, Scoper scopes, JvmBackend jvm_backend) {
        this(types, scopes, jvm_backend, null);
    }
}

