/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.util;

import java.util.LinkedList;
import java.util.List;
import mirah.lang.ast.BlockArgument;
import mirah.lang.ast.Boolean;
import mirah.lang.ast.CharLiteral;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.Float;
import mirah.lang.ast.Loop;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.TypeRefImpl;
import mirah.lang.ast.Unquote;

public class AstFormatter
extends NodeScanner {
    private Node node;
    private boolean newline = true;
    private String string;
    private int indent = 0;
    private LinkedList childCounts;
    private StringBuilder out = new StringBuilder();

    public AstFormatter(Node node) {
        this.childCounts = new LinkedList();
        this.childCounts.addLast(0);
        this.node = node;
    }

    public void appendIndent() {
        int gensym0 = 0;
        int gensym1 = this.indent;
        if (gensym0 < gensym1) {
            do {
                this.out.append(" ");
            } while (++gensym0 < gensym1);
        }
    }

    public void appendLine(String arg) {
        this.append(arg);
        this.newline = true;
        this.out.append("\n");
    }

    public void append(String arg) {
        if (this.newline) {
            this.appendIndent();
        }
        this.out.append(arg);
        this.newline = false;
    }

    public int indent() {
        return this.indent += 2;
    }

    public int dedent() {
        return this.indent -= 2;
    }

    @Override
    public Object enterNullChild(Object obj) {
        AstFormatter astFormatter = this;
        astFormatter.appendLine("nil");
        return astFormatter;
    }

    public int startNode(Node node) {
        Integer count = (Integer)this.childCounts.removeLast();
        this.childCounts.addLast(count + 1);
        this.childCounts.addLast(0);
        this.append("[" + node.getClass().getSimpleName());
        return this.indent();
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.startNode(node);
        this.appendLine("");
        return true;
    }

    @Override
    public Object exitDefault(Node node, Object arg) {
        boolean bl;
        this.dedent();
        int childCount = (Integer)this.childCounts.removeLast();
        int lastIndex = this.out.length() - 1;
        boolean bl2 = lastIndex > 0 ? this.out.charAt(lastIndex) == '\n' : false;
        if (bl2) {
            boolean $or$1;
            boolean bl3 = $or$1 = this.out.charAt(lastIndex - 1) == '[';
            bl = $or$1 ? $or$1 : this.out.charAt(lastIndex - 1) == ']';
        } else {
            bl = false;
        }
        if (bl) {
            this.out.insert(lastIndex, "]");
        } else if (childCount == 0) {
            this.out.insert(lastIndex, "]");
        } else {
            this.appendLine("]");
        }
        return this.out;
    }

    @Override
    public boolean enterBoolean(Boolean node, Object arg) {
        this.startNode(node);
        this.append(" ");
        this.out.append(node.value());
        return true;
    }

    @Override
    public boolean enterFixnum(Fixnum node, Object arg) {
        this.startNode(node);
        this.append(" ");
        this.out.append(node.value());
        return true;
    }

    @Override
    public boolean enterFloat(Float node, Object arg) {
        this.startNode(node);
        this.append(" ");
        this.out.append(node.value());
        return true;
    }

    @Override
    public boolean enterCharLiteral(CharLiteral node, Object arg) {
        this.startNode(node);
        this.append(" ");
        this.out.append(node.value());
        return true;
    }

    @Override
    public boolean enterSimpleString(SimpleString node, Object arg) {
        int count = (Integer)this.childCounts.peekLast();
        if (count == 0) {
            this.newline = false;
            this.out.setCharAt(this.out.length() - 1, " ".charAt(0));
        }
        this.append("\"");
        this.out.append(node.value());
        return true;
    }

    @Override
    public Object exitSimpleString(SimpleString node, Object arg) {
        AstFormatter astFormatter = this;
        astFormatter.appendLine("\"");
        return astFormatter;
    }

    @Override
    public boolean enterTypeRefImpl(TypeRefImpl node, Object arg) {
        this.startNode(node);
        this.append(" " + node.name());
        if (node.isArray()) {
            this.append(" array");
        }
        if (node.isStatic()) {
            this.append(" static");
        }
        this.appendLine("");
        return true;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        Integer count = (Integer)this.childCounts.removeLast();
        this.childCounts.addLast(count + 1);
        this.childCounts.addLast(0);
        this.appendLine("[");
        this.indent();
        return true;
    }

    @Override
    public boolean enterBlockArgument(BlockArgument node, Object arg) {
        block0: {
            this.enterDefault(node, arg);
            if (!node.optional()) break block0;
            this.appendLine("optional");
        }
        return true;
    }

    @Override
    public boolean enterLoop(Loop node, Object arg) {
        block1: {
            this.enterDefault(node, arg);
            if (node.skipFirstCheck()) {
                this.appendLine("skipFirstCheck");
            }
            if (!node.negative()) break block1;
            this.appendLine("negative");
        }
        return true;
    }

    @Override
    public Object exitFieldAccess(FieldAccess node, Object arg) {
        block0: {
            if (!node.isStatic()) break block0;
            this.appendLine("static");
        }
        return this.exitDefault(node, arg);
    }

    @Override
    public Object exitFieldAssign(FieldAssign node, Object arg) {
        block0: {
            if (!node.isStatic()) break block0;
            this.appendLine("static");
        }
        return this.exitDefault(node, arg);
    }

    @Override
    public boolean enterUnquote(Unquote node, Object arg) {
        this.enterDefault(node, arg);
        Object object = node.object();
        if (object != null) {
            if (object instanceof Node) {
                this.scan((Node)object, arg);
            } else {
                boolean bl;
                if (object instanceof List) {
                    boolean gensym0 = true;
                    for (Object i : (List)object) {
                        if (i instanceof Node) continue;
                        gensym0 = false;
                        break;
                    }
                    bl = gensym0;
                } else {
                    bl = false;
                }
                if (bl) {
                    for (Object o : (List)object) {
                        this.scan((Node)o, arg);
                    }
                } else {
                    this.append("<");
                    this.append(node.object().toString());
                    this.appendLine(">");
                }
            }
        }
        return object == null;
    }

    public String toString() {
        String string;
        if (this.string != null) {
            string = this.string;
        } else {
            this.scan(this.node, null);
            StringBuilder out = this.out;
            this.out = null;
            this.node = null;
            string = this.string = out.toString();
        }
        return string;
    }
}

