/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.util;

import java.util.Locale;
import javax.tools.Diagnostic;
import mirah.lang.ast.Position;

public class MirahDiagnostic
implements Diagnostic {
    private Diagnostic.Kind kind;
    private Position position;
    private String message;

    public MirahDiagnostic(Diagnostic.Kind kind, Position position, String message) {
        this.kind = kind;
        this.position = position;
        this.message = message;
    }

    public static MirahDiagnostic error(Position position, String message) {
        return new MirahDiagnostic(Diagnostic.Kind.ERROR, position, message);
    }

    public static MirahDiagnostic warning(Position position, String message) {
        return new MirahDiagnostic(Diagnostic.Kind.WARNING, position, message);
    }

    public static MirahDiagnostic note(Position position, String message) {
        return new MirahDiagnostic(Diagnostic.Kind.NOTE, position, message);
    }

    @Override
    public Diagnostic.Kind getKind() {
        return this.kind;
    }

    @Override
    public String getMessage(Locale locale) {
        return this.message;
    }

    public Object getSource() {
        return this.position != null ? this.position.source() : null;
    }

    @Override
    public String getCode() {
        return null;
    }

    @Override
    public long getColumnNumber() {
        return this.position != null ? (long)this.position.startColumn() : Diagnostic.NOPOS;
    }

    @Override
    public long getEndPosition() {
        return this.position != null ? (long)this.position.endChar() : Diagnostic.NOPOS;
    }

    @Override
    public long getLineNumber() {
        return this.position != null ? (long)this.position.startLine() : Diagnostic.NOPOS;
    }

    @Override
    public long getPosition() {
        return this.position != null ? (long)this.position.startChar() : Diagnostic.NOPOS;
    }

    @Override
    public long getStartPosition() {
        return this.getPosition();
    }
}

