/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.List;
import mirah.lang.ast.Block;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.ImplicitSelf;
import mirah.lang.ast.Named;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.Position;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.TypeRefImpl;

public class FunctionalCall
extends NodeImpl
implements Named,
TypeName,
CallSite {
    private Identifier name;
    private ImplicitSelf target;
    private Block block;
    private NodeList parameters;

    public FunctionalCall() {
    }

    public FunctionalCall(Position position) {
        this.position_set(position);
    }

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitFunctionalCall(this, arg);
    }

    @Override
    public Identifier name() {
        return this.name;
    }

    public void name_set(Identifier value) {
        if (value == this.name) {
            return;
        }
        this.childRemoved(this.name);
        Node clone = this.childAdded(value);
        this.name = value = (Identifier)clone;
    }

    @Override
    public NodeList parameters() {
        return this.parameters;
    }

    public void parameters_set(NodeList value) {
        if (value == this.parameters) {
            return;
        }
        this.childRemoved(this.parameters);
        Node clone = this.childAdded(value);
        this.parameters = value = (NodeList)clone;
    }

    public Node parameters(int i) {
        Node node = this.parameters.get(i);
        return node;
    }

    public int parameters_size() {
        if (this.parameters != null) {
            return this.parameters.size();
        }
        return 0;
    }

    @Override
    public Block block() {
        return this.block;
    }

    @Override
    public void block_set(Block value) {
        if (value == this.block) {
            return;
        }
        this.childRemoved(this.block);
        Node clone = this.childAdded(value);
        this.block = value = (Block)clone;
    }

    public FunctionalCall(Position position, Identifier name, List parameters, Block block) {
        this.position_set(position);
        this.name_set(name);
        this.parameters_set(new NodeList(position, parameters));
        this.block_set(block);
    }

    public FunctionalCall(Identifier name, List parameters, Block block) {
        this.name_set(name);
        this.parameters_set(new NodeList(this.position(), parameters));
        this.block_set(block);
    }

    @Override
    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        Node clone = this.childAdded(newChild);
        if (this.name() == oldChild) {
            this.name_set((Identifier)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.block() == oldChild) {
            this.block_set((Block)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        throw new IllegalArgumentException("No child " + oldChild);
    }

    @Override
    public void removeChild(Node child) {
        if (this.name() == child) {
            this.name_set(null);
            return;
        }
        if (this.block() == child) {
            this.block_set(null);
            return;
        }
        throw new IllegalArgumentException("No child " + child);
    }

    @Override
    public void initCopy() {
        block2: {
            super.initCopy();
            if (this.name() != null) {
                this.name = (Identifier)this.childAdded((Node)this.name().clone());
            }
            if (this.parameters() != null) {
                this.parameters = (NodeList)this.childAdded((Node)this.parameters().clone());
            }
            if (this.block() == null) break block2;
            this.block = (Block)this.childAdded((Node)this.block().clone());
        }
    }

    @Override
    public Node target() {
        return this.target != null ? this.target : (this.target = new ImplicitSelf(this.position()));
    }

    @Override
    public TypeRef typeref() {
        return new TypeRefImpl(this.name().identifier(), false, false, this.name().position());
    }
}

