/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.HashMap;
import java.util.Map;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Position;
import mirah.lang.ast.Rescue;
import org.mirah.util.Context;
import org.mirah.util.MirahDiagnostic;

public class AnnotationCollector
extends NodeScanner {
    private Map field_annotations;
    private Context context;

    public AnnotationCollector(Context context) {
        this.context = context;
        this.field_annotations = new HashMap(16);
    }

    public DiagnosticListener error(String message, Position position) {
        DiagnosticListener diagnosticListener = (DiagnosticListener)this.context.get(DiagnosticListener.class);
        diagnosticListener.report(MirahDiagnostic.error(position, message));
        return diagnosticListener;
    }

    public void collect(Node node) {
        this.scan(node, null);
    }

    public AnnotationList getAnnotations(String field) {
        return (AnnotationList)this.field_annotations.get(field);
    }

    @Override
    public boolean enterFieldAssign(FieldAssign node, Object arg) {
        block2: {
            String name = node.name().identifier();
            boolean bl = node.annotations() != null ? node.annotations_size() > 0 : false;
            if (!bl) break block2;
            if (this.field_annotations.get(name) != null) {
                this.error("Multiple declarations for field " + name, node.position());
            } else {
                this.field_annotations.put(name, node.annotations());
                node.annotations_set(new AnnotationList());
            }
        }
        return false;
    }

    @Override
    public boolean enterNodeList(NodeList node, Object arg) {
        return true;
    }

    @Override
    public boolean enterRescue(Rescue node, Object arg) {
        return true;
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        return false;
    }
}

