/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.logging.Logger;
import mirah.lang.ast.Array;
import mirah.lang.ast.Node;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.Bytecode;
import org.mirah.jvm.types.JVMType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class ArrayCompiler
extends BaseCompiler {
    private Bytecode bytecode;
    private JVMType arraylist;
    private JVMType list;
    private BaseCompiler method;
    private JVMType object;
    private Method add;
    private static Logger log = Logger.getLogger(ArrayCompiler.class.getName());
    private Method constructor;

    public ArrayCompiler(BaseCompiler method, Bytecode bytecode) {
        super(method.context());
        this.method = method;
        this.bytecode = bytecode;
        this.object = this.findType("java.lang.Object");
        this.list = this.findType("java.util.List");
        this.arraylist = this.findType("java.util.ArrayList");
        Type[] arg = new Type[]{Type.getType("I")};
        this.constructor = new Method("<init>", Type.getType("V"), arg);
        arg[0] = this.object.getAsmType();
        this.add = new Method("add", Type.getType("Z"), arg);
    }

    public void compile(Array array) {
        this.bytecode.recordPosition(array.position());
        this.bytecode.newInstance(this.arraylist.getAsmType());
        this.bytecode.dup();
        this.bytecode.push(array.values_size());
        this.bytecode.invokeConstructor(this.arraylist.getAsmType(), this.constructor);
        int i = 0;
        int gensym0 = array.values_size();
        if (i < gensym0) {
            do {
                this.bytecode.dup();
                Node value = array.values(i);
                this.method.visit(value, Boolean.TRUE);
                this.bytecode.convertValue(this.getInferredType(value), this.object);
                this.bytecode.invokeInterface(this.list.getAsmType(), this.add);
                this.bytecode.pop();
            } while (++i < gensym0);
        }
    }
}

