/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import mirah.lang.ast.Call;
import mirah.lang.ast.Node;
import mirah.lang.ast.Not;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.Bytecode;
import org.mirah.jvm.compiler.CallCompiler;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.jvm.types.MemberKind;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ConditionCompiler
extends BaseCompiler {
    private Bytecode bytecode;
    private String op;
    private BaseCompiler method;
    private JVMType type;
    private static Logger log = Logger.getLogger(ConditionCompiler.class.getName());
    private boolean negated;
    private static Map NEGATED_OPS;

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        hashMap.put("==", "!=");
        hashMap.put("!=", "==");
        hashMap.put("<", ">=");
        hashMap.put(">", "<=");
        hashMap.put("<=", ">");
        hashMap.put(">=", "<");
        NEGATED_OPS = hashMap;
    }

    public ConditionCompiler(BaseCompiler method, Bytecode bytecode) {
        super(method.context());
        this.method = method;
        this.bytecode = bytecode;
        this.negated = false;
    }

    public boolean negate() {
        this.negated = !this.negated;
        return this.negated;
    }

    public Bytecode compile(Node node, Label label) {
        this.visit(node, Boolean.TRUE);
        return this.op != null ? this.doComparison(label) : this.doJump(label);
    }

    public Bytecode doJump(Label label) {
        Bytecode bytecode;
        if (JVMTypeUtils.isPrimitive(this.type)) {
            if ("float".equals(this.type.name())) {
                this.bytecode.push(0.0f);
                this.op = "==";
                bytecode = this.doComparison(label);
            } else if ("double".equals(this.type.name())) {
                this.bytecode.push(0.0);
                this.op = "==";
                bytecode = this.doComparison(label);
            } else if ("long".equals(this.type.name())) {
                this.bytecode.push((long)0);
                this.op = "==";
                bytecode = this.doComparison(label);
            } else {
                int mode = this.negated ? GeneratorAdapter.EQ : GeneratorAdapter.NE;
                Bytecode bytecode2 = this.bytecode;
                bytecode = bytecode2;
                bytecode2.ifZCmp(mode, label);
            }
        } else if (this.negated) {
            Bytecode bytecode3 = this.bytecode;
            bytecode = bytecode3;
            bytecode3.ifNull(label);
        } else {
            Bytecode bytecode4 = this.bytecode;
            bytecode = bytecode4;
            bytecode4.ifNonNull(label);
        }
        return bytecode;
    }

    public Bytecode doComparison(Label label) {
        String op = this.negated ? NEGATED_OPS.get(this.op) : this.op;
        Bytecode bytecode = this.bytecode;
        bytecode.ifCmp(this.type.getAsmType(), CallCompiler.computeComparisonOp(op), this.negated, label);
        return bytecode;
    }

    @Override
    public Object visitNot(Not node, Object expression) {
        this.negate();
        ConditionCompiler conditionCompiler = this;
        conditionCompiler.visit(node.value(), expression);
        return conditionCompiler;
    }

    @Override
    public Object visitCall(Call node, Object expression) {
        JVMType jVMType;
        if (node.block() != null) {
            throw new Exception("call to " + node.name().identifier() + "'s block has not been converted to a closure at " + node.position());
        }
        CallCompiler call = new CallCompiler(this.method, this.bytecode, node.position(), node.target(), node.name().identifier(), node.parameters(), this.getInferredType(node));
        JVMMethod member = call.getMethod();
        MemberKind kind = member.kind();
        if (MemberKind.COMPARISON_OP == kind) {
            call.compileComparisonValues(member);
            this.op = member.name();
            jVMType = this.type = member.declaringClass();
        } else if (MemberKind.IS_NULL == kind) {
            this.negate();
            this.method.visit(node.target(), Boolean.TRUE);
            jVMType = this.type = this.getInferredType(node.target());
        } else {
            call.compile(true);
            jVMType = this.type = this.getInferredType(node);
        }
        return jVMType;
    }

    @Override
    public Object defaultNode(Node node, Object expression) {
        this.method.visit(node, expression);
        this.type = this.getInferredType(node);
        return this.type;
    }
}

