/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class FlexibleFrame
extends Frame {
    private List locals = new ArrayList(0);
    private List stack = new ArrayList(0);
    private int top = 0;

    public FlexibleFrame() {
        super(0, 0);
    }

    public FlexibleFrame(Frame other) {
        this();
        this.init(other);
    }

    @Override
    public Frame init(Frame other) {
        int gensym1;
        this.locals = new ArrayList(0);
        this.stack = new ArrayList(0);
        this.top = other.getStackSize();
        int i = 0;
        int gensym0 = other.getLocals();
        if (i < gensym0) {
            do {
                this.setLocal(i, other.getLocal(i));
            } while (++i < gensym0);
        }
        if ((i = 0) < (gensym1 = this.top)) {
            do {
                this.setStack(i, other.getStack(i));
            } while (++i < gensym1);
        }
        return this;
    }

    public void resize(List list, int size) {
        while (list.size() < size) {
            list.add(BasicValue.UNINITIALIZED_VALUE);
        }
    }

    @Override
    public int getLocals() {
        return this.locals.size();
    }

    @Override
    public Value getLocal(int i) {
        return i >= this.locals.size() ? BasicValue.UNINITIALIZED_VALUE : (Value)this.locals.get(i);
    }

    @Override
    public void setLocal(int i, Value v) {
        this.resize(this.locals, i + 1);
        this.locals.set(i, v);
    }

    @Override
    public int getStackSize() {
        return this.top;
    }

    @Override
    public Value getStack(int i) {
        return i >= this.stack.size() ? BasicValue.UNINITIALIZED_VALUE : (Value)this.stack.get(i);
    }

    public void setStack(int i, Value v) {
        this.resize(this.stack, i + 1);
        this.stack.set(i, v);
    }

    @Override
    public void clearStack() {
        this.top = 0;
    }

    @Override
    public Value pop() {
        --this.top;
        return this.getStack(this.top);
    }

    @Override
    public void push(Value v) {
        this.setStack(this.top, v);
        ++this.top;
    }

    @Override
    public boolean merge(Frame frame, Interpreter interpreter) {
        int gensym1;
        Value v;
        boolean changes = false;
        int i = 0;
        int gensym0 = this.locals.size();
        if (i < gensym0) {
            do {
                if ((v = interpreter.merge(this.getLocal(i), frame.getLocal(i))).equals(this.getLocal(i))) continue;
                this.setLocal(i, v);
                changes = true;
            } while (++i < gensym0);
        }
        if ((i = 0) < (gensym1 = this.stack.size())) {
            do {
                if ((v = interpreter.merge(this.getStack(i), frame.getStack(i))).equals(this.getStack(i))) continue;
                this.setStack(i, v);
                changes = true;
            } while (++i < gensym1);
        }
        return changes;
    }
}

