/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.logging.Logger;
import mirah.lang.ast.Hash;
import mirah.lang.ast.HashEntry;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.Bytecode;
import org.mirah.jvm.types.JVMType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class HashCompiler
extends BaseCompiler {
    private Bytecode bytecode;
    private Method put;
    private JVMType map;
    private BaseCompiler method;
    private JVMType hashmap;
    private JVMType object;
    private static Logger log = Logger.getLogger(HashCompiler.class.getName());
    private Method constructor;

    public HashCompiler(BaseCompiler method, Bytecode bytecode) {
        super(method.context());
        Type val0;
        this.method = method;
        this.bytecode = bytecode;
        this.object = this.findType("java.lang.Object");
        this.map = this.findType("java.util.Map");
        this.hashmap = this.findType("java.util.HashMap");
        Type[] arg = new Type[]{Type.getType("I")};
        this.constructor = new Method("<init>", Type.getType("V"), arg);
        Type[] args = new Type[2];
        args[1] = val0 = this.object.getAsmType();
        args[0] = val0;
        this.put = new Method("put", this.object.getAsmType(), args);
    }

    public void compile(Hash hash) {
        this.bytecode.recordPosition(hash.position());
        this.bytecode.newInstance(this.hashmap.getAsmType());
        this.bytecode.dup();
        this.bytecode.push(Math.max((int)((double)hash.size() / 0.75), 16));
        this.bytecode.invokeConstructor(this.hashmap.getAsmType(), this.constructor);
        int i = 0;
        int gensym0 = hash.size();
        if (i < gensym0) {
            do {
                this.bytecode.dup();
                HashEntry entry = hash.get(i);
                this.method.visit(entry.key(), Boolean.TRUE);
                this.method.visit(entry.value(), Boolean.TRUE);
                this.bytecode.convertValue(this.getInferredType(entry.value()), this.object);
                this.bytecode.invokeInterface(this.map.getAsmType(), this.put);
                this.bytecode.pop();
            } while (++i < gensym0);
        }
    }
}

