/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Array;
import mirah.lang.ast.AttrAssign;
import mirah.lang.ast.BindingReference;
import mirah.lang.ast.Boolean;
import mirah.lang.ast.Break;
import mirah.lang.ast.Call;
import mirah.lang.ast.Cast;
import mirah.lang.ast.CharLiteral;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.EmptyArray;
import mirah.lang.ast.Ensure;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.Float;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.Hash;
import mirah.lang.ast.If;
import mirah.lang.ast.ImplicitNil;
import mirah.lang.ast.ImplicitSelf;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.LocalAssignment;
import mirah.lang.ast.Loop;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Named;
import mirah.lang.ast.Next;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Noop;
import mirah.lang.ast.Not;
import mirah.lang.ast.Null;
import mirah.lang.ast.OptionalArgument;
import mirah.lang.ast.Position;
import mirah.lang.ast.Raise;
import mirah.lang.ast.Redo;
import mirah.lang.ast.Regex;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Rescue;
import mirah.lang.ast.RescueClause;
import mirah.lang.ast.Return;
import mirah.lang.ast.Script;
import mirah.lang.ast.Self;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.StringConcat;
import mirah.lang.ast.StringPieceList;
import mirah.lang.ast.Super;
import mirah.lang.ast.TypeRefImpl;
import org.mirah.jvm.compiler.AnnotationCompiler;
import org.mirah.jvm.compiler.ArrayCompiler;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.Bytecode;
import org.mirah.jvm.compiler.CallCompiler;
import org.mirah.jvm.compiler.ConditionCompiler;
import org.mirah.jvm.compiler.HashCompiler;
import org.mirah.jvm.compiler.InnerClassCompiler;
import org.mirah.jvm.compiler.LocalInfo;
import org.mirah.jvm.compiler.LoopCompiler;
import org.mirah.jvm.compiler.StringCompiler;
import org.mirah.jvm.types.CallType;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.typer.AssignableTypeFuture;
import org.mirah.typer.ErrorType;
import org.mirah.typer.MethodType;
import org.mirah.typer.Scope;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class MethodCompiler
extends BaseCompiler {
    private InnerClassCompiler classCompiler;
    private HashCompiler hashes;
    private int flags;
    private Method descriptor;
    private JVMType bindingType;
    private Map args;
    private JVMType klass;
    private Bytecode builder;
    private static Logger log = Logger.getLogger(MethodCompiler.class.getName());
    private JVMType returnType;
    private JVMType selfType;
    private JVMType superclass;
    private Map locals;
    private String name;
    private LoopCompiler loop;
    private int binding;
    private boolean lookingForDelegate;
    private ArrayCompiler arrays;

    public MethodCompiler(InnerClassCompiler compiler, JVMType klass, int flags, String name) {
        super(compiler.context());
        this.flags = flags;
        this.name = name;
        this.locals = new HashMap(16);
        this.args = new HashMap(16);
        this.klass = klass;
        this.classCompiler = compiler;
    }

    public boolean isVoid() {
        return this.descriptor.getDescriptor().endsWith(")V");
    }

    public boolean isStatic() {
        return (this.flags & Opcodes.ACC_STATIC) != 0;
    }

    public Bytecode bytecode() {
        return this.builder;
    }

    public void compile(ClassVisitor cv, MethodDefinition mdef) {
        java.lang.Boolean isExpression;
        log.fine("Compiling method " + mdef.name().identifier());
        this.builder = this.createBuilder(cv, mdef);
        ((AnnotationCompiler)this.context().get(AnnotationCompiler.class)).compile(mdef.annotations(), this.builder);
        java.lang.Boolean bl = isExpression = this.isVoid() ? null : java.lang.Boolean.TRUE;
        if ((this.flags & Opcodes.ACC_ABSTRACT) == 0) {
            this.prepareBinding(mdef);
            this.lookingForDelegate = mdef instanceof ConstructorDefinition;
            this.compileBody(mdef.body(), isExpression, this.returnType);
            Position body_position = mdef.body_size() > 0 ? mdef.body(mdef.body_size() - 1).position() : mdef.body().position();
            this.returnValue(mdef);
        }
        this.builder.endMethod();
        log.fine("Finished method " + mdef.name().identifier());
    }

    public MethodCompiler compile(Node node) {
        MethodCompiler methodCompiler = this;
        methodCompiler.visit(node, java.lang.Boolean.TRUE);
        return methodCompiler;
    }

    public void collectArgNames(MethodDefinition mdef, Bytecode bytecode) {
        int gensym2;
        int gensym1;
        JVMType type;
        RequiredArgument arg;
        int gensym0;
        int a;
        Arguments args = mdef.arguments();
        if (!this.isStatic()) {
            bytecode.declareArg("this", this.selfType);
        }
        if ((a = 0) < (gensym0 = args.required_size())) {
            do {
                arg = args.required(a);
                type = this.getInferredType(arg);
                bytecode.declareArg(arg.name().identifier(), type);
            } while (++a < gensym0);
        }
        if ((a = 0) < (gensym1 = args.optional_size())) {
            do {
                OptionalArgument optarg = args.optional(a);
                type = this.getInferredType(optarg);
                bytecode.declareArg(optarg.name().identifier(), type);
            } while (++a < gensym1);
        }
        if (args.rest() != null) {
            type = this.getInferredType(args.rest());
            bytecode.declareArg(args.rest().name().identifier(), type);
        }
        if ((a = 0) < (gensym2 = args.required2_size())) {
            do {
                arg = args.required2(a);
                type = this.getInferredType(arg);
                bytecode.declareArg(arg.name().identifier(), type);
            } while (++a < gensym2);
        }
    }

    public Bytecode createBuilder(ClassVisitor cv, MethodDefinition mdef) {
        JVMType superclass;
        MethodType type = this.getInferredType(mdef);
        boolean $or$1 = this.name.endsWith("init>");
        this.returnType = ($or$1 ? $or$1 : ":unreachable".equals(type.returnType().name())) ? (JVMType)this.typer().type_system().getVoidType().resolve() : (JVMType)type.returnType();
        this.descriptor = this.methodDescriptor(this.name, this.returnType, type.parameterTypes());
        this.selfType = (JVMType)this.getScope(mdef).selfType().resolve();
        JVMType $or$2 = superclass = this.selfType.superclass();
        this.superclass = $or$2 != null ? $or$2 : (JVMType)this.typer().type_system().get(null, new TypeRefImpl("java.lang.Object", false, false, null)).resolve();
        Bytecode builder = new Bytecode(this.flags, this.descriptor, cv, mdef.findAncestor(Script.class).position().source());
        this.collectArgNames(mdef, builder);
        return builder;
    }

    public void prepareBinding(MethodDefinition mdef) {
        block3: {
            boolean shouldCreateBinding;
            Scope scope = this.getIntroducedScope(mdef);
            JVMType type = (JVMType)scope.binding_type();
            if (type == null) break block3;
            boolean bl = shouldCreateBinding = mdef.findAncestor(ClosureDefinition.class) == null;
            if (shouldCreateBinding) {
                this.builder.newInstance(type.getAsmType());
                this.builder.dup();
                Type[] args = new Type[]{};
                this.builder.invokeConstructor(type.getAsmType(), new Method("<init>", Type.getType("V"), args));
                for (LocalInfo arg : this.builder.arguments()) {
                    if (!scope.isCaptured(arg.name())) continue;
                    this.builder.dup();
                    this.builder.loadLocal(arg.name());
                    this.builder.putField(type.getAsmType(), arg.name(), arg.type());
                }
            } else {
                this.builder.loadThis();
                this.builder.getField(this.selfType.getAsmType(), "binding", type.getAsmType());
            }
            this.bindingType = type;
            this.binding = this.builder.newLocal(type.getAsmType());
            this.builder.storeLocal(this.binding, type.getAsmType());
        }
    }

    public int recordPosition(Position position, boolean atEnd) {
        return this.builder.recordPosition(position, atEnd);
    }

    public Bytecode defaultValue(JVMType type) {
        Bytecode bytecode;
        if (JVMTypeUtils.isPrimitive(type)) {
            if ("long".equals(type.name())) {
                Bytecode bytecode2 = this.builder;
                bytecode = bytecode2;
                bytecode2.push((long)0);
            } else if ("double".equals(type.name())) {
                Bytecode bytecode3 = this.builder;
                bytecode = bytecode3;
                bytecode3.push(0.0);
            } else if ("float".equals(type.name())) {
                Bytecode bytecode4 = this.builder;
                bytecode = bytecode4;
                bytecode4.push(0.0f);
            } else {
                Bytecode bytecode5 = this.builder;
                bytecode = bytecode5;
                bytecode5.push(0);
            }
        } else {
            Bytecode bytecode6 = this.builder;
            bytecode = bytecode6;
            bytecode6.push((String)null);
        }
        return bytecode;
    }

    @Override
    public Object visitFixnum(Fixnum node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            boolean isLong = "long".equals(this.getInferredType(node).name());
            this.recordPosition(node.position());
            if (isLong) {
                Bytecode bytecode2 = this.builder;
                bytecode = bytecode2;
                bytecode2.push(node.value());
            } else {
                Bytecode bytecode3 = this.builder;
                bytecode = bytecode3;
                bytecode3.push((int)node.value());
            }
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitFloat(Float node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            boolean isFloat = "float".equals(this.getInferredType(node).name());
            this.recordPosition(node.position());
            if (isFloat) {
                Bytecode bytecode2 = this.builder;
                bytecode = bytecode2;
                bytecode2.push((float)node.value());
            } else {
                Bytecode bytecode3 = this.builder;
                bytecode = bytecode3;
                bytecode3.push(node.value());
            }
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitBoolean(Boolean node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            this.recordPosition(node.position());
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.push(node.value() ? 1 : 0);
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitCharLiteral(CharLiteral node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            this.recordPosition(node.position());
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.push(node.value());
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitSimpleString(SimpleString node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            this.recordPosition(node.position());
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.push(node.value());
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitNull(Null node, Object expression) {
        Bytecode bytecode;
        String value = null;
        if (expression != null) {
            this.recordPosition(node.position());
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.push(value);
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitSuper(Super node, Object expression) {
        Bytecode bytecode;
        this.lookingForDelegate = false;
        this.builder.loadThis();
        LinkedList<JVMType> paramTypes = new LinkedList<JVMType>();
        int i = 0;
        int gensym0 = node.parameters_size();
        if (i < gensym0) {
            do {
                Node param = node.parameters(i);
                this.compile(param);
                paramTypes.add(this.getInferredType(param));
            } while (++i < gensym0);
        }
        this.recordPosition(node.position());
        JVMType result = this.getInferredType(node);
        JVMMethod method = result instanceof CallType ? ((CallType)result).member() : this.superclass.getMethod(this.name, paramTypes);
        this.builder.invokeSpecial(this.superclass.getAsmType(), this.methodDescriptor(method));
        if (expression != null ? this.isVoid() : false) {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.loadThis();
        } else {
            bytecode = (expression == null ? !this.isVoid() : false) ? this.builder.pop(this.returnType) : null;
        }
        return bytecode;
    }

    @Override
    public Object visitLocalAccess(LocalAccess local, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            this.recordPosition(local.position());
            String name = local.name().identifier();
            String proper_name = this.scoped_name(this.containing_scope(local), name);
            if (this.bindingType != null ? this.getScope(local).isCaptured(name) : false) {
                this.builder.loadLocal(this.binding);
                Bytecode bytecode2 = this.builder;
                bytecode = bytecode2;
                bytecode2.getField(this.bindingType.getAsmType(), proper_name, this.getInferredType(local).getAsmType());
            } else {
                Bytecode bytecode3 = this.builder;
                bytecode = bytecode3;
                bytecode3.loadLocal(proper_name);
            }
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitLocalAssignment(LocalAssignment local, Object expression) {
        Bytecode bytecode;
        AssignableTypeFuture future;
        boolean isCaptured;
        String name = local.name().identifier();
        boolean bl = isCaptured = this.bindingType != null ? this.getScope(local).isCaptured(name) : false;
        if (isCaptured) {
            this.builder.loadLocal(this.binding);
        }
        if ((future = this.typer().type_system().getLocalType(this.getScope(local), name, local.position())).resolve() instanceof ErrorType) {
            throw new Exception("error type found by compiler " + future.resolve());
        }
        JVMType type = (JVMType)future.resolve();
        JVMType valueType = this.getInferredType(local.value());
        if (local.value() instanceof NodeList) {
            this.compileBody((NodeList)local.value(), java.lang.Boolean.TRUE, type);
            valueType = type;
        } else {
            this.visit(local.value(), java.lang.Boolean.TRUE);
        }
        if (expression != null) {
            if (isCaptured) {
                this.builder.dupX1();
            } else {
                this.builder.dup();
            }
        }
        this.recordPosition(local.position());
        this.builder.convertValue(valueType, type);
        String proper_name = this.scoped_name(this.containing_scope(local), name);
        if (isCaptured) {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.putField(this.bindingType.getAsmType(), proper_name, type.getAsmType());
        } else {
            Bytecode bytecode3 = this.builder;
            bytecode = bytecode3;
            bytecode3.storeLocal(proper_name, type);
        }
        return bytecode;
    }

    public Scope containing_scope(Named node) {
        Scope scope = this.getScope(node);
        String name = node.name().identifier();
        return this.containing_scope(scope, name);
    }

    public Scope containing_scope(RescueClause node) {
        Scope scope = this.getScope(node.body());
        String name = node.name().identifier();
        return this.containing_scope(scope, name);
    }

    public Scope containing_scope(Scope scope, String name) {
        while (this._has_scope_something(scope, name)) {
            scope = scope.parent();
        }
        return scope;
    }

    public boolean _has_scope_something(Scope scope, String name) {
        boolean not_shadowed;
        boolean bl = not_shadowed = !scope.shadowed?(name);
        return (not_shadowed ? !(scope.parent() == null) : false) ? scope.parent().hasLocal(name) : false;
    }

    public String scoped_name(Scope scope, String name) {
        return scope.shadowed?(name) ? name + "$" + System.identityHashCode(scope) : name;
    }

    @Override
    public Object visitFunctionalCall(FunctionalCall call, Object expression) {
        CallCompiler compiler;
        if (call.block() != null) {
            throw new Exception("call to " + call.name().identifier() + "'s block has not been converted to a closure at " + call.position());
        }
        String name = call.name().identifier();
        if (this.lookingForDelegate ? name.equals("initialize") : false) {
            name = "<init>";
        }
        this.lookingForDelegate = false;
        CallCompiler callCompiler = compiler = new CallCompiler((BaseCompiler)this, this.builder, call.position(), call.target(), name, call.parameters(), this.getInferredType(call));
        callCompiler.compile(expression != null);
        return callCompiler;
    }

    @Override
    public Object visitCall(Call call, Object expression) {
        CallCompiler compiler;
        if (call.block() != null) {
            throw new Exception("call to " + call.name().identifier() + "'s block has not been converted to a closure at " + call.position());
        }
        CallCompiler callCompiler = compiler = new CallCompiler((BaseCompiler)this, this.builder, call.position(), call.target(), call.name().identifier(), call.parameters(), this.getInferredType(call));
        callCompiler.compile(expression != null);
        return callCompiler;
    }

    public Object compileBody(NodeList node, Object expression, JVMType type) {
        Object object;
        if (node.size() == 0) {
            if (expression != null) {
                object = this.defaultValue(type);
            } else {
                Bytecode bytecode = this.builder;
                object = bytecode;
                bytecode.visitInsn(Opcodes.NOP);
            }
        } else {
            object = this.visitNodeList(node, expression);
        }
        return object;
    }

    @Override
    public Object visitIf(If node, Object expression) {
        boolean need_else;
        boolean $or$4;
        boolean $or$3;
        Label elseLabel = this.builder.newLabel();
        Label endifLabel = this.builder.newLabel();
        ConditionCompiler compiler = new ConditionCompiler(this, this.builder);
        JVMType type = this.getInferredType(node);
        boolean bl = $or$3 = !(expression == null);
        boolean need_then = $or$3 ? $or$3 : node.body_size() > 0;
        boolean bl2 = $or$4 = !(expression == null);
        boolean bl3 = $or$4 ? $or$4 : (need_else = node.elseBody_size() > 0);
        if (need_then) {
            compiler.negate();
            compiler.compile(node.condition(), elseLabel);
            this.compileBody(node.body(), expression, type);
            this.builder.goTo(endifLabel);
        } else {
            compiler.compile(node.condition(), endifLabel);
        }
        this.builder.mark(elseLabel);
        if (need_else) {
            this.compileBody(node.elseBody(), expression, type);
        }
        this.recordPosition(node.position(), true);
        Bytecode bytecode = this.builder;
        bytecode.mark(endifLabel);
        return bytecode;
    }

    @Override
    public Object visitImplicitNil(ImplicitNil node, Object expression) {
        return expression != null ? this.defaultValue(this.getInferredType(node)) : null;
    }

    @Override
    public Object visitReturn(Return node, Object expression) {
        if (!this.isVoid()) {
            this.compile(node.value());
        }
        this.handleEnsures(node, MethodDefinition.class);
        Bytecode bytecode = this.builder;
        bytecode.returnValue();
        return bytecode;
    }

    @Override
    public Object visitCast(Cast node, Object expression) {
        this.compile(node.value());
        JVMType from = this.getInferredType(node.value());
        JVMType to = this.getInferredType(node);
        if (JVMTypeUtils.isPrimitive(from)) {
            this.builder.cast(from.getAsmType(), to.getAsmType());
        } else {
            this.builder.checkCast(to.getAsmType());
        }
        return expression != null ? null : this.builder.pop(to);
    }

    @Override
    public Object visitFieldAccess(FieldAccess node, Object expression) {
        boolean isStatic;
        Type klass = this.selfType.getAsmType();
        String name = node.name().identifier();
        JVMType type = this.getInferredType(node);
        boolean $or$5 = node.isStatic();
        boolean bl = isStatic = $or$5 ? $or$5 : this.isStatic();
        if (isStatic) {
            this.recordPosition(node.position());
            this.builder.getStatic(klass, name, type.getAsmType());
        } else {
            this.builder.loadThis();
            this.recordPosition(node.position());
            this.builder.getField(klass, name, type.getAsmType());
        }
        return expression != null ? null : this.builder.pop(type);
    }

    @Override
    public Object visitFieldAssign(FieldAssign node, Object expression) {
        Bytecode bytecode;
        Type klass = this.selfType.getAsmType();
        String name = node.name().identifier();
        if (name.endsWith("=")) {
            throw new IllegalArgumentException();
        }
        boolean $or$6 = node.isStatic();
        boolean isStatic = $or$6 ? $or$6 : this.isStatic();
        JVMType type = this.klass.getDeclaredField(node.name().identifier()).returnType();
        if (!isStatic) {
            this.builder.loadThis();
        }
        this.compile(node.value());
        JVMType valueType = this.getInferredType(node.value());
        if (expression != null) {
            if (isStatic) {
                this.builder.dup(valueType);
            } else {
                this.builder.dupX1(valueType);
            }
        }
        this.builder.convertValue(valueType, type);
        this.recordPosition(node.position());
        if (isStatic) {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.putStatic(klass, name, type.getAsmType());
        } else {
            Bytecode bytecode3 = this.builder;
            bytecode = bytecode3;
            bytecode3.putField(klass, name, type.getAsmType());
        }
        return bytecode;
    }

    @Override
    public Object visitEmptyArray(EmptyArray node, Object expression) {
        Bytecode bytecode;
        this.compile(node.size());
        this.recordPosition(node.position());
        JVMType type = this.getInferredType(node).getComponentType();
        this.builder.newArray(type.getAsmType());
        if (expression != null) {
            bytecode = null;
        } else {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.pop();
        }
        return bytecode;
    }

    @Override
    public Object visitAttrAssign(AttrAssign node, Object expression) {
        CallCompiler compiler;
        Position position = node.position();
        Node node2 = node.target();
        String string = node.name().identifier() + "_set";
        ArrayList<Node> arrayList = new ArrayList<Node>(1);
        arrayList.add(node.value());
        CallCompiler callCompiler = compiler = new CallCompiler((BaseCompiler)this, this.builder, position, node2, string, arrayList, this.getInferredType(node));
        callCompiler.compile(expression != null);
        return callCompiler;
    }

    @Override
    public Object visitStringConcat(StringConcat node, Object expression) {
        MethodCompiler methodCompiler = this;
        methodCompiler.visit(node.strings(), expression);
        return methodCompiler;
    }

    @Override
    public Object visitStringPieceList(StringPieceList node, Object expression) {
        Object object;
        if (node.size() == 0) {
            if (expression != null) {
                this.recordPosition(node.position());
                Bytecode bytecode = this.builder;
                object = bytecode;
                bytecode.push("");
            } else {
                object = null;
            }
        } else if (node.size() == 1 ? node.get(0) instanceof SimpleString : false) {
            MethodCompiler methodCompiler = this;
            object = methodCompiler;
            methodCompiler.visit(node.get(0), expression);
        } else {
            StringCompiler compiler;
            StringCompiler stringCompiler = compiler = new StringCompiler(this);
            object = stringCompiler;
            stringCompiler.compile(node, expression != null);
        }
        return object;
    }

    @Override
    public Object visitRegex(Regex node, Object expression) {
        Bytecode bytecode;
        this.compile(node.strings());
        this.recordPosition(node.position());
        JVMType pattern = this.findType("java.util.regex.Pattern");
        Type type = pattern.getAsmType();
        ArrayList<JVMType> arrayList = new ArrayList<JVMType>(1);
        arrayList.add(this.findType("java.lang.String"));
        this.builder.invokeStatic(type, this.methodDescriptor("compile", pattern, arrayList));
        if (expression != null) {
            bytecode = null;
        } else {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.pop();
        }
        return bytecode;
    }

    @Override
    public Object visitNot(Not node, Object expression) {
        Bytecode bytecode;
        this.visit(node.value(), expression);
        if (expression != null) {
            this.recordPosition(node.position());
            Label done = this.builder.newLabel();
            Label elseLabel = this.builder.newLabel();
            JVMType type = this.getInferredType(node.value());
            if (JVMTypeUtils.isPrimitive(type)) {
                this.builder.ifZCmp(GeneratorAdapter.EQ, elseLabel);
            } else {
                this.builder.ifNull(elseLabel);
            }
            this.builder.push(0);
            this.builder.goTo(done);
            this.builder.mark(elseLabel);
            this.builder.push(1);
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.mark(done);
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    public Bytecode returnValue(MethodDefinition mdef) {
        boolean $or$9;
        boolean $or$8;
        NodeList body = mdef.body();
        JVMType type = this.getInferredType(body);
        boolean $or$7 = this.isVoid();
        boolean bl = $or$8 = $or$7 ? $or$7 : type == null;
        if (!($or$8 ? $or$8 : this.returnType.assignableFrom(type))) {
            Position body_position = body.size() > 0 ? body.get(body.size() - 1).position() : body.position();
            this.reportError("Invalid return type " + type.name() + ", expected " + this.returnType.name(), body_position);
        }
        if (!(($or$9 = this.isVoid()) ? $or$9 : type == null)) {
            this.builder.convertValue(type, this.returnType);
        }
        Bytecode bytecode = this.builder;
        bytecode.returnValue();
        return bytecode;
    }

    @Override
    public Object visitSelf(Self node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            this.recordPosition(node.position());
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.loadThis();
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    @Override
    public Object visitImplicitSelf(ImplicitSelf node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            this.recordPosition(node.position());
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.loadThis();
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Object visitLoop(Loop loop, Object object) {
        Bytecode bytecode;
        LoopCompiler old_loop;
        Object var3_3 = null;
        try {
            void expression;
            boolean $or$10;
            void node;
            old_loop = this.loop;
            this.loop = new LoopCompiler(this.builder);
            this.visit(node.init(), null);
            ConditionCompiler predicate = new ConditionCompiler(this, this.builder);
            Label preLabel = this.builder.newLabel();
            if (!node.skipFirstCheck()) {
                if (node.post_size() <= 0) {
                    this.builder.mark(this.loop.getNext());
                }
                if (!node.negative()) {
                    predicate.negate();
                }
                predicate.compile(node.condition(), this.loop.getBreak());
                predicate.negate();
            }
            this.builder.mark(preLabel);
            this.visit(node.pre(), null);
            this.builder.mark(this.loop.getRedo());
            if (node.body() != null) {
                this.visit(node.body(), null);
            }
            if (($or$10 = node.skipFirstCheck()) ? $or$10 : node.post_size() > 0) {
                this.builder.mark(this.loop.getNext());
                this.visit(node.post(), null);
                if (node.negative()) {
                    predicate.negate();
                }
                predicate.compile(node.condition(), preLabel);
            } else {
                this.builder.goTo(this.loop.getNext());
            }
            this.builder.mark(this.loop.getBreak());
            this.recordPosition(node.position(), true);
            if (expression != null) {
                Bytecode bytecode2 = this.builder;
                bytecode = bytecode2;
                bytecode2.pushNil();
            } else {
                bytecode = null;
            }
            this.loop = old_loop;
        }
        catch (Throwable throwable) {
            this.loop = old_loop;
            throw throwable;
        }
        return bytecode;
    }

    @Override
    public Object visitBreak(Break node, Object expression) {
        Object object;
        if (this.loop != null) {
            this.handleEnsures(node, Loop.class);
            Bytecode bytecode = this.builder;
            object = bytecode;
            bytecode.goTo(this.loop.getBreak());
        } else {
            object = this.reportError("Break outside of loop", node.position());
        }
        return object;
    }

    @Override
    public Object visitRedo(Redo node, Object expression) {
        Object object;
        if (this.loop != null) {
            this.handleEnsures(node, Loop.class);
            Bytecode bytecode = this.builder;
            object = bytecode;
            bytecode.goTo(this.loop.getRedo());
        } else {
            object = this.reportError("Redo outside of loop", node.position());
        }
        return object;
    }

    @Override
    public Object visitNext(Next node, Object expression) {
        Object object;
        if (this.loop != null) {
            this.handleEnsures(node, Loop.class);
            Bytecode bytecode = this.builder;
            object = bytecode;
            bytecode.goTo(this.loop.getNext());
        } else {
            object = this.reportError("Next outside of loop", node.position());
        }
        return object;
    }

    @Override
    public Object visitArray(Array node, Object expression) {
        Bytecode bytecode;
        if (this.arrays != null) {
        } else {
            this.arrays = new ArrayCompiler(this, this.builder);
        }
        this.arrays.compile(node);
        if (expression != null) {
            bytecode = null;
        } else {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.pop();
        }
        return bytecode;
    }

    @Override
    public Object visitHash(Hash node, Object expression) {
        Bytecode bytecode;
        if (this.hashes != null) {
        } else {
            this.hashes = new HashCompiler(this, this.builder);
        }
        this.hashes.compile(node);
        if (expression != null) {
            bytecode = null;
        } else {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.pop();
        }
        return bytecode;
    }

    @Override
    public Object visitRaise(Raise node, Object expression) {
        this.compile(node.args(0));
        this.recordPosition(node.position());
        Bytecode bytecode = this.builder;
        bytecode.throwException();
        return bytecode;
    }

    @Override
    public Object visitRescue(Rescue node, Object expression) {
        Bytecode bytecode;
        boolean $or$11;
        Label start = this.builder.mark();
        int start_offset = this.builder.instruction_count();
        Label bodyEnd = this.builder.newLabel();
        boolean bl = $or$11 = expression == null;
        java.lang.Boolean bodyIsExpression = ($or$11 ? $or$11 : node.elseClause().size() > 0) ? null : java.lang.Boolean.TRUE;
        this.visit(node.body(), bodyIsExpression);
        int end_offset = this.builder.instruction_count();
        this.builder.mark(bodyEnd);
        if (node.elseClause().size() > 0) {
            this.visit(node.elseClause(), expression);
        }
        if (start_offset == end_offset) {
            bytecode = null;
        } else {
            Label done = this.builder.newLabel();
            this.builder.goTo(done);
            int clauseIndex = 0;
            int gensym0 = node.clauses_size();
            if (clauseIndex < gensym0) {
                do {
                    RescueClause clause;
                    int gensym1;
                    int typeIndex;
                    if ((typeIndex = 0) < (gensym1 = (clause = node.clauses(clauseIndex)).types_size())) {
                        do {
                            JVMType type = this.getInferredType(clause.types(typeIndex));
                            this.builder.catchException(start, bodyEnd, type.getAsmType());
                        } while (++typeIndex < gensym1);
                    }
                    if (clause.name() != null) {
                        this.recordPosition(clause.name().position());
                        String proper_name = this.scoped_name(this.containing_scope(clause), clause.name().identifier());
                        this.builder.storeLocal(proper_name, Type.getType("Ljava/lang/Throwable;"));
                    } else {
                        this.builder.pop();
                    }
                    this.compileBody(clause.body(), expression, this.getInferredType(node));
                    this.builder.goTo(done);
                } while (++clauseIndex < gensym0);
            }
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.mark(done);
        }
        return bytecode;
    }

    public void handleEnsures(Node node, Class klass) {
        while (node.parent() != null) {
            if (node instanceof Ensure) {
                this.visit(((Ensure)node).ensureClause(), null);
            }
            if (klass.isInstance(node)) break;
            node = node.parent();
        }
    }

    @Override
    public Object visitEnsure(Ensure node, Object expression) {
        Bytecode bytecode;
        Label start = this.builder.mark();
        Label bodyEnd = this.builder.newLabel();
        int start_offset = this.builder.instruction_count();
        this.visit(node.body(), expression);
        int end_offset = this.builder.instruction_count();
        this.builder.mark(bodyEnd);
        this.visit(node.ensureClause(), null);
        if (start_offset == end_offset) {
            bytecode = null;
        } else {
            Label done = this.builder.newLabel();
            this.builder.goTo(done);
            this.builder.catchException(start, bodyEnd, null);
            this.visit(node.ensureClause(), null);
            this.builder.throwException();
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.mark(done);
        }
        return bytecode;
    }

    @Override
    public Object visitNoop(Noop node, Object expression) {
        Object v0 = null;
        return null;
    }

    @Override
    public Object visitClassDefinition(ClassDefinition node, Object expression) {
        InnerClassCompiler innerClassCompiler = this.classCompiler;
        innerClassCompiler.compileInnerClass(node, this.descriptor);
        return innerClassCompiler;
    }

    @Override
    public Object visitClosureDefinition(ClosureDefinition node, Object exporession) {
        InnerClassCompiler innerClassCompiler = this.classCompiler;
        innerClassCompiler.compileInnerClass(node, this.descriptor);
        return innerClassCompiler;
    }

    @Override
    public Object visitBindingReference(BindingReference node, Object expression) {
        Bytecode bytecode;
        if (expression != null) {
            Bytecode bytecode2 = this.builder;
            bytecode = bytecode2;
            bytecode2.loadLocal(this.binding);
        } else {
            bytecode = null;
        }
        return bytecode;
    }
}

