/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import javax.tools.Diagnostic;
import mirah.lang.ast.MacroDefinition;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Position;
import org.mirah.jvm.types.JVMType;
import org.mirah.typer.MethodType;

public class MethodState {
    private Position position;
    private String name;
    private String signature;
    private JVMType returnType;
    private int num_args;

    public MethodState(MacroDefinition macrodef) {
        this.num_args = macrodef.arguments().required_size();
        if (macrodef.arguments().block() != null) {
            ++this.num_args;
        }
        this.name = macrodef.name().identifier();
        this.position = macrodef.name().position();
    }

    public MethodState(MethodDefinition method, MethodType type) {
        this.name = method.name().identifier();
        this.position = method.name().position();
        this.num_args = type.parameterTypes().size();
        this.returnType = (JVMType)type.returnType();
        StringBuilder signature = new StringBuilder();
        for (JVMType t : type.parameterTypes()) {
            signature.append(t.getAsmType().getDescriptor());
        }
        this.signature = signature.toString();
    }

    public Diagnostic.Kind conflictsWith(MethodState other) {
        Diagnostic.Kind kind;
        if (!this.name.equals(other.name())) {
            return null;
        }
        if (this.num_args != other.num_args()) {
            return null;
        }
        if ((this.signature == null ? other.signature() : null) != null) {
            kind = other.conflictsWith(this);
        } else {
            boolean $or$1;
            boolean bl = $or$1 = this.signature == null;
            kind = ($or$1 ? $or$1 : other.signature() == null) ? (this.num_args == 0 ? Diagnostic.Kind.ERROR : Diagnostic.Kind.WARNING) : (this.signature.equals(other.signature()) ? Diagnostic.Kind.WARNING : null);
        }
        return kind;
    }

    public int num_args() {
        return this.num_args;
    }

    public String name() {
        return this.name;
    }

    public Position position() {
        return this.position;
    }

    public JVMType returnType() {
        return this.returnType;
    }

    public void num_args_set(int value) {
        this.num_args = value;
    }

    public void name_set(String value) {
        this.name = value;
    }

    public void position_set(Position value) {
        this.position = value;
    }

    public void returnType_set(JVMType value) {
        this.returnType = value;
    }

    public String signature() {
        return this.signature;
    }

    public void signature_set(String value) {
        this.signature = value;
    }

    public String toString() {
        return (this.signature != null ? "method" : "macro") + " " + this.name;
    }
}

