/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.logging.Logger;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.InterfaceDeclaration;
import mirah.lang.ast.Script;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.BytecodeConsumer;
import org.mirah.jvm.compiler.ClassCompiler;
import org.mirah.jvm.compiler.InterfaceCompiler;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.TypePrinter;
import org.mirah.util.Context;

public class ScriptCompiler
extends BaseCompiler {
    private LinkedList classes;
    private Typer typer;
    private static Logger log = Logger.getLogger(ScriptCompiler.class.getName());

    public ScriptCompiler(Context context) {
        super(context);
        this.typer = (Typer)context.get(Typer.class);
        this.classes = new LinkedList();
    }

    @Override
    public Object visitScript(Script script, Object expression) {
        ScriptCompiler scriptCompiler;
        try {
            ScriptCompiler scriptCompiler2 = this;
            scriptCompiler = scriptCompiler2;
            scriptCompiler2.visit(script.body(), expression);
        }
        catch (Exception ex$73876688) {
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(buf);
            TypePrinter printer = new TypePrinter(this.typer, ps);
            printer.scan(script, null);
            ps.close();
            log.fine("Inferred types for expression with errors:\n" + new String(buf.toByteArray()));
            throw ex$73876688;
        }
        return scriptCompiler;
    }

    @Override
    public Object visitClassDefinition(ClassDefinition class_def, Object expression) {
        ClassCompiler compiler = new ClassCompiler(this.context(), class_def);
        this.classes.add(compiler);
        ClassCompiler classCompiler = compiler;
        classCompiler.compile();
        return classCompiler;
    }

    @Override
    public Object visitInterfaceDeclaration(InterfaceDeclaration class_def, Object expression) {
        InterfaceCompiler compiler = new InterfaceCompiler(this.context(), class_def);
        this.classes.add(compiler);
        InterfaceCompiler interfaceCompiler = compiler;
        interfaceCompiler.compile();
        return interfaceCompiler;
    }

    public Object generate(BytecodeConsumer consumer) {
        while (!this.classes.isEmpty()) {
            ClassCompiler compiler = (ClassCompiler)this.classes.removeFirst();
            consumer.consumeClass(compiler.internal_name(), compiler.getBytes());
            this.classes.addAll(compiler.innerClasses());
        }
        return null;
    }
}

