/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mirah.lang.ast.Position;
import org.mirah.jvm.mirrors.DebugError;
import org.mirah.jvm.mirrors.MacroMember;
import org.mirah.jvm.mirrors.Member;
import org.mirah.jvm.mirrors.MethodLookup;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.jvm.mirrors.generics.GenericMethodLookup;
import org.mirah.typer.Scope;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;

public class LookupState {
    private Position position;
    private LinkedList methods;
    private LinkedList macros;
    private List inaccessible;
    private Scope scope;
    private LinkedList saved_macros;
    private List macro_matches;
    private LinkedList saved_inaccessible_macros;
    private LinkedList saved_methods;
    private List params;
    private LinkedList inaccessible_macros;
    private LinkedList inaccessible_methods;
    private List macro_params;
    private List matches;
    private Context context;
    private MirrorType target;
    private LinkedList saved_inaccessible_methods;

    public LookupState(Context context, Scope scope, MirrorType target, List potentials, Position position) {
        this.context = context;
        this.scope = scope;
        this.target = target;
        this.position = position;
        this.setPotentials(potentials);
    }

    public List processGenericMethods() {
        GenericMethodLookup generics = new GenericMethodLookup(this.context);
        this.matches = generics.processGenerics(this.target, this.params, this.matches);
        return this.matches;
    }

    public Object setPotentials(List potentials) {
        this.saved_methods = this.methods;
        this.saved_macros = this.macros;
        this.saved_inaccessible_methods = this.inaccessible_methods;
        this.saved_inaccessible_macros = this.inaccessible_macros;
        this.methods = new LinkedList();
        this.macros = new LinkedList();
        this.inaccessible_methods = new LinkedList();
        this.inaccessible_macros = new LinkedList();
        for (Object p : potentials) {
            Member method = (Member)p;
            boolean accessible = true;
            if (!MethodLookup.isAccessible(method.declaringClass(), method.declaringClass().flags(), this.scope)) {
                accessible = false;
            }
            if (!MethodLookup.isAccessible(method.declaringClass(), method.flags(), this.scope, this.target)) {
                accessible = false;
            }
            boolean is_macro = method instanceof MacroMember;
            LinkedList list = (accessible ? is_macro : false) ? this.macros : (accessible ? this.methods : (is_macro ? this.inaccessible_macros : this.inaccessible_methods));
            list.add(method);
        }
        return null;
    }

    public void search(List params, List macro_params) {
        block2: {
            this.params = params;
            this.macro_params = macro_params;
            MethodLookup lookup = (MethodLookup)this.context.get(MethodLookup.class);
            this.matches = lookup.findMatchingMethod(this.methods, params);
            this.macro_matches = lookup.findMatchingMethod(this.macros, macro_params);
            if (this.matches() > 0) {
                this.processGenericMethods();
            }
            if (this.matches() + this.macro_matches() != 0) break block2;
            this.inaccessible = lookup.findMatchingMethod(this.inaccessible_methods, params);
            boolean $or$13 = this.inaccessible == null;
            if ($or$13 ? $or$13 : this.inaccessible.isEmpty()) {
                this.inaccessible = lookup.findMatchingMethod(this.inaccessible_macros, macro_params);
            }
        }
    }

    public void searchFields(String name) {
        block1: {
            boolean $or$14;
            if (this.matches() + this.macro_matches() + this.inaccessible() != 0) break block1;
            boolean bl = $or$14 = this.params.size() == 0;
            boolean bl2 = $or$14 ? $or$14 : (name.endsWith("_set") ? this.params.size() == 1 : false);
            if (bl2) {
                this.setPotentials(((MethodLookup)this.context.get(MethodLookup.class)).gatherFields(this.target, name));
                this.search(this.params, null);
            }
        }
    }

    public int matches() {
        return this.matches == null ? 0 : this.matches.size();
    }

    public int macro_matches() {
        return this.macro_matches == null ? 0 : this.macro_matches.size();
    }

    public int inaccessible() {
        return this.inaccessible == null ? 0 : this.inaccessible.size();
    }

    public TypeFuture future(boolean isField) {
        TypeFuture typeFuture;
        if (this.matches() + this.macro_matches() == 0) {
            if (this.inaccessible() != 0) {
                typeFuture = ((MethodLookup)this.context.get(MethodLookup.class)).inaccessible(this.scope, (Member)this.inaccessible.get(0), this.position, this);
            } else if ((DebuggerInterface)this.context.get(DebuggerInterface.class) != null) {
                ArrayList arrayList = new ArrayList(1);
                ArrayList<String> arrayList2 = new ArrayList<String>(1);
                arrayList2.add("Can't find method " + this.target + this.params + " II");
                arrayList.add(arrayList2);
                typeFuture = new DebugError(arrayList, this.context, this);
            } else {
                typeFuture = null;
            }
        } else {
            typeFuture = this.matches() > 0 ? this.pickOne(this.matches, this.params, isField) : this.pickOne(this.macro_matches, this.macro_params, isField);
        }
        return typeFuture;
    }

    public TypeFuture pickOne(List methods, List params, boolean isField) {
        TypeFuture typeFuture;
        if (methods.size() == 0) {
            typeFuture = null;
        } else {
            boolean $or$15 = isField;
            if ($or$15 ? $or$15 : methods.size() == 1) {
                typeFuture = ((MethodLookup)this.context.get(MethodLookup.class)).makeFuture(this.target, (Member)methods.get(0), params, this.position, this);
            } else {
                ArrayList arrayList = new ArrayList(1);
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add("Ambiguous methods " + methods);
                arrayList2.add(this.position);
                arrayList.add(arrayList2);
                typeFuture = new DebugError(arrayList, this.context, this);
            }
        }
        return typeFuture;
    }

    public String toString() {
        return this.matches() + this.macro_matches() + this.inaccessible() == 0 ? "{potentials: " + this.methods.size() + " " + this.macros.size() + " inaccessible: " + this.inaccessible_methods.size() + " " + this.inaccessible_macros.size() + "}" : "{" + this.matches() + " methods " + this.macro_matches() + " macros " + this.inaccessible() + " inaccessible}";
    }
}

