/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.DiagnosticListener;
import mirah.impl.MirahParser;
import mirah.lang.ast.Node;
import org.mirah.jvm.compiler.ReportedException;
import org.mirah.macros.JvmBackend;
import org.mirah.typer.ClosureBuilderer;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.MirahDiagnostic;

public class SafeTyper
extends Typer {
    private DiagnosticListener diagnostics;
    private static Logger log = Logger.getLogger(SafeTyper.class.getName());

    public SafeTyper(Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend, MirahParser parser, boolean new_closures) {
        super(types, scopes, jvm_backend, parser, new_closures);
        this.diagnostics = (DiagnosticListener)context.get(DiagnosticListener.class);
    }

    @Override
    public TypeFuture infer(Node node, boolean expression) {
        TypeFuture typeFuture;
        try {
            typeFuture = super.infer(node, expression);
        }
        catch (Exception ex$1731095750) {
            throw this.betterException(ex$1731095750, node);
        }
        return typeFuture;
    }

    @Override
    public ClosureBuilderer finish_closures() {
        ClosureBuilderer closureBuilderer;
        try {
            closureBuilderer = super.finish_closures();
        }
        catch (Exception ex$1403096037) {
            throw this.betterException(ex$1403096037);
        }
        return closureBuilderer;
    }

    public Throwable betterException(Throwable ex, Node node) {
        Throwable throwable;
        if (ex instanceof ReportedException) {
            throwable = new ReportedException(ex.getCause());
        } else if (ex.getCause() instanceof ReportedException) {
            throwable = ex.getCause();
        } else if (ex.getClass().getName().equals("org.jruby.exceptions.RaiseException")) {
            throwable = ex;
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.SEVERE, "Exception in typer for " + node + "\n  " + this.sourceContent(node), ex);
            }
            this.diagnostics.report(MirahDiagnostic.error(node != null ? node.position() : null, "Internal compiler error: " + ex + " " + ex.getMessage() + ". Rerun in verbose mode for stacktrace."));
            throwable = new ReportedException(ex);
        }
        return throwable;
    }

    public SafeTyper(Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend, MirahParser parser) {
        this(context, types, scopes, jvm_backend, parser, false);
    }

    public SafeTyper(Context context, TypeSystem types, Scoper scopes, JvmBackend jvm_backend) {
        this(context, types, scopes, jvm_backend, null, false);
    }
}

