/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.debug;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Console;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import mirah.lang.ast.Node;
import org.mirah.jvm.mirrors.debug.Breakpoint;
import org.mirah.jvm.mirrors.debug.Command;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$1;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$10;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$11;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$12;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$13;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$14;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$15;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$16;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$17;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$18;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$19;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$2;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$20;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$21;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$22;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$23;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$24;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$3;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$4;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$5;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$6;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$7;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$8;
import org.mirah.jvm.mirrors.debug.ConsoleDebugger$9;
import org.mirah.jvm.mirrors.debug.ConsoleDiagnostics;
import org.mirah.jvm.mirrors.debug.DebugController;
import org.mirah.jvm.mirrors.debug.DebugListener;
import org.mirah.jvm.mirrors.debug.StackEntry;
import org.mirah.jvm.mirrors.debug.WatchState;
import org.mirah.macros.anno.Extensions;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.TypeFuture;
import org.mirah.util.MirahDiagnostic;

@Extensions(macros={"org.mirah.jvm.mirrors.debug.ConsoleDebugger$Extension1"})
public class ConsoleDebugger
implements DebugListener,
Runnable {
    private Console console;
    private boolean stopped;
    private Condition condition;
    private Map commands;
    private ReentrantLock lock;
    private boolean shouldExit;
    private DebugController controller;
    private ConsoleDiagnostics out;

    public ConsoleDebugger() {
        ConsoleDebugger$1 consoleDebugger$1 = new ConsoleDebugger$1();
        this.controller = new DebugController(this);
        this.controller.step();
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.stopped = false;
        this.console = System.console();
        this.out = new ConsoleDiagnostics();
        this.shouldExit = false;
        this.commands = new HashMap(16);
        consoleDebugger$1.debugger = this;
        this.commands.put("c", new ConsoleDebugger$2(consoleDebugger$1));
        this.commands.put("cont", new ConsoleDebugger$3(consoleDebugger$1));
        this.commands.put("s", new ConsoleDebugger$4(consoleDebugger$1));
        this.commands.put("step", new ConsoleDebugger$5(consoleDebugger$1));
        this.commands.put("next", new ConsoleDebugger$6(consoleDebugger$1));
        this.commands.put("n", new ConsoleDebugger$7(consoleDebugger$1));
        this.commands.put("help", new ConsoleDebugger$8(consoleDebugger$1));
        this.commands.put("watch", new ConsoleDebugger$9(consoleDebugger$1));
        this.commands.put("watches", new ConsoleDebugger$10(consoleDebugger$1));
        this.commands.put("unwatch", new ConsoleDebugger$11(consoleDebugger$1));
        this.commands.put("quit", new ConsoleDebugger$12(consoleDebugger$1));
        this.commands.put("b", new ConsoleDebugger$13(consoleDebugger$1));
        this.commands.put("stop", new ConsoleDebugger$14(consoleDebugger$1));
        this.commands.put("del", new ConsoleDebugger$15(consoleDebugger$1));
        this.commands.put("clear", new ConsoleDebugger$16(consoleDebugger$1));
        this.commands.put("print", new ConsoleDebugger$17(consoleDebugger$1));
        this.commands.put("p", new ConsoleDebugger$18(consoleDebugger$1));
        this.commands.put("dump", new ConsoleDebugger$19(consoleDebugger$1));
        this.commands.put("x", new ConsoleDebugger$20(consoleDebugger$1));
        this.commands.put("bt", new ConsoleDebugger$21(consoleDebugger$1));
        this.commands.put("where", new ConsoleDebugger$22(consoleDebugger$1));
        this.commands.put("jwhere", new ConsoleDebugger$23(consoleDebugger$1));
        this.commands.put("finish", new ConsoleDebugger$24(consoleDebugger$1));
    }

    public Thread start() {
        Thread thread = new Thread(this);
        thread.start();
        return thread;
    }

    public DebugController debugger() {
        return this.controller;
    }

    public void printContext() {
        block1: {
            StackEntry where;
            block0: {
                where = this.controller.where();
                String node_state = where.result() != null ? "Completed" : (where.watch() != null ? "In" : "Entering");
                Node node = where.node();
                String location = node.position() != null ? " at " + node.position().source().name() + ":" + node.position().startLine() : "";
                this.out.report((Diagnostic)MirahDiagnostic.note(node.position(), node_state + " " + node.getClass().getSimpleName() + location));
                if (where.result() == null) break block0;
                this.printFuture("ret", where.result());
                break block1;
            }
            if (where.watch() == null) break block1;
            this.printWatch(where.watch());
        }
    }

    public void printFuture(String name, TypeFuture future) {
        this.console.printf("  %s = %s%n", name, future);
    }

    public void printWatch(WatchState watch) {
        this.printFuture("future", watch.future());
        this.console.printf("  from = %s%n", watch.currentValue());
        this.console.printf("  to = %s%n", watch.newValue());
        if (watch.currentValue() == watch.newValue()) {
            this.console.printf("  (from == to)%n", new Object[0]);
        } else if (watch.currentValue() != null ? watch.currentValue().equals(watch.newValue()) : false) {
            this.console.printf("  (from.equals(to))%n", new Object[0]);
        } else {
            this.console.printf("  (from != to)%n", new Object[0]);
        }
    }

    @Override
    public void stopped() {
        try {
            this.lock.lock();
            this.stopped = true;
            this.condition.signal();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public void processCommand() {
        block4: {
            try {
                String line = this.console.readLine("> ", new Object[0]);
                if (line == null) {
                    this.stopped = false;
                    this.shouldExit = true;
                    break block4;
                }
                String[] split = line.split("\\s+");
                String command = split[0];
                boolean $or$1 = command == null;
                if ($or$1 ? $or$1 : "".equals(command)) break block4;
                String[] args = Arrays.copyOfRange(split, 1, split.length);
                Command handler = (Command)this.commands.get(command);
                if (handler != null) {
                    handler.run(args);
                    break block4;
                }
                this.console.printf("Unsupported command '%s'.%n", command);
            }
            catch (Exception ex$1611138861) {
                ex$1611138861.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        try {
            this.lock.lock();
            while (!this.shouldExit) {
                while (!this.stopped) {
                    this.condition.await();
                }
                this.printContext();
                while (this.stopped) {
                    this.processCommand();
                }
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public void doQuit(String[] args) {
        this.stopped = false;
        this.shouldExit = true;
        System.exit(1);
    }

    public void doContinue(String[] args) {
        this.stopped = false;
        this.controller.continueExecution();
    }

    public void doStep(String[] args) {
        if (args.length == 1 ? "up".equals(args[0]) : false) {
            this.doFinish(args);
        } else {
            this.stopped = false;
            this.controller.step();
        }
    }

    public void doNext(String[] args) {
        this.stopped = false;
        this.controller.next();
    }

    public void doFinish(String[] args) {
        this.stopped = false;
        this.controller.finishNode();
    }

    public void doHelp(String[] args) {
        Console console = this.console;
        console.printf("Supported commands:%n", new Object[0]);
        for (Object c : this.commands.keySet()) {
            console.printf("\t" + c, new Object[0]);
        }
        console.printf("%n", new Object[0]);
    }

    public void listWatches(String[] args) {
        Map watches = this.controller.watches();
        int i = 0;
        for (TypeFuture f : watches.keySet()) {
            this.printFuture("" + i, f);
            ++i;
        }
    }

    public void clearWatch(String[] args) {
        if (args.length == 0) {
            this.listWatches(args);
            return;
        }
        int index = Integer.parseInt(args[0]);
        Iterator it = this.controller.watches().keySet().iterator();
        int gensym0 = 0;
        int gensym1 = index - 1;
        if (gensym0 < gensym1) {
            do {
                it.next();
            } while (++gensym0 < gensym1);
        }
        this.controller.clearWatch((BaseTypeFuture)it.next());
    }

    public void addWatch(String[] args) {
        BaseTypeFuture future;
        int nameIndex = 0;
        String kind = "notsame";
        if (args.length > 0 && this.controller.isValidWatchKind(args[0])) {
            nameIndex = 1;
            kind = args[0];
        }
        if ((future = (BaseTypeFuture)this.resolveObject(args, nameIndex)) == null) {
            this.console.printf("Nothing to watch%n", new Object[0]);
        } else {
            this.controller.watch(future, kind);
        }
    }

    public void listBreakpoints(String[] args) {
        List breakpoints = this.controller.breakpoints();
        int i = 0;
        for (Object b : breakpoints) {
            this.console.printf(" %d: %s%n", new Integer(i), b);
            ++i;
        }
    }

    public void clearBreakpoint(String[] args) {
        if (args.length == 0) {
            this.listBreakpoints(args);
            return;
        }
        int index = Integer.parseInt(args[0]);
        for (Object b : this.controller.breakpoints()) {
            if (--index >= 0) continue;
            this.controller.clearBreakpoint((Breakpoint)b);
            break;
        }
    }

    public void addBreakpoint(String[] args) {
        if (args.length == 0) {
            this.listBreakpoints(args);
            return;
        }
        String arg = args[0];
        if (arg.equals("at")) {
            arg = args[1];
        }
        String[] split = arg.split(":", 2);
        Breakpoint bp = new Breakpoint(split[0], Integer.parseInt(split[1]));
        this.controller.addBreakpoint(bp);
    }

    public void printObject(String[] args) {
        Object what = this.resolveObject(args, 0);
        this.console.printf("\t%s: %s%n", what.getClass().getName(), what);
    }

    public void dumpObject(String[] args) {
        Object what = this.resolveObject(args, 0);
        if (what instanceof BaseTypeFuture) {
            this.dumpFuture((BaseTypeFuture)what);
        } else {
            this.printObject(args);
        }
    }

    public void dumpFuture(BaseTypeFuture future) {
        this.console.printf("\t%s {%n", future);
        if (future.isResolved()) {
            this.console.printf("\t\tresolved = %s%n", future.resolve());
        } else {
            this.console.printf("\t\tunresolved%n", new Object[0]);
        }
        for (Map.Entry e : future.getComponents().entrySet()) {
            this.console.printf("\t\t%s = %s%n", e.getKey(), e.getValue());
        }
        this.console.printf("\t}%n", new Object[0]);
    }

    public Object resolveObject(String[] args, int index) {
        Object object;
        StackEntry where = this.controller.where();
        if (args.length <= index) {
            if (where.result() != null) {
                return where.result();
            }
            if (where.watch() != null) {
                return where.watch().future();
            }
            object = where.node();
        } else {
            Object object2;
            String[] components = args[index].split("[.]");
            String name = components[0];
            if ("node".equals(name)) {
                object2 = where.node();
            } else if ("ret".equals(name)) {
                object2 = where.result();
            } else if ("future".equals(name)) {
                object2 = where.watch().future();
            } else if ("from".equals(name)) {
                object2 = where.watch().currentValue();
            } else if ("to".equals(name)) {
                object2 = where.watch().newValue();
            } else {
                throw new IllegalArgumentException("Unrecognized name '" + name + "'");
            }
            Node value = object2;
            object = this.resolveProperties(value, components, 1);
        }
        return object;
    }

    public Object resolveProperties(Object value, String[] components, int index) {
        while (index < components.length) {
            Method method;
            BeanInfo info;
            PropertyDescriptor[] gensym0;
            int gensym1;
            String name = components[index];
            int property_index = -1;
            Matcher m = Pattern.compile("([^\\[]+)\\[(\\d+)\\]").matcher(name);
            if (m.matches()) {
                name = m.group(1);
                property_index = Integer.parseInt(m.group(2));
            }
            ++index;
            Object prop = null;
            if (value instanceof BaseTypeFuture) {
                BaseTypeFuture btf = (BaseTypeFuture)value;
                prop = ("resolved".equals(name) ? btf.isResolved() : false) ? btf.resolve() : btf.getComponents().get(name);
            }
            if (prop == null && (gensym1 = 0) < (gensym0 = (info = Introspector.getBeanInfo(value.getClass())).getPropertyDescriptors()).length) {
                do {
                    PropertyDescriptor p;
                    if (!name.equals((p = gensym0[gensym1]).getName())) continue;
                    if (property_index != -1) {
                        method = ((IndexedPropertyDescriptor)p).getIndexedReadMethod();
                        prop = method.invoke(value, new Integer(property_index));
                        property_index = -1;
                        break;
                    }
                    method = p.getReadMethod();
                    prop = method.invoke(value, new Object[0]);
                    break;
                } while (++gensym1 < gensym0.length);
            }
            if (prop == null && (method = value.getClass().getMethod(name, new Class[0])) != null) {
                prop = method.invoke(value, new Object[0]);
            }
            if (property_index != -1) {
                if (prop instanceof List) {
                    prop = ((List)prop).get(property_index);
                } else if (prop.getClass().isArray()) {
                    prop = ((Object[])prop)[property_index];
                }
            }
            if (prop == null) {
                throw new IllegalArgumentException("Unrecognized property '" + name + "'");
            }
            value = prop;
        }
        return value;
    }

    public void printNodeStack(String[] args) {
        int i = 0;
        for (StackEntry frame = this.controller.where(); frame != null; frame = frame.parent()) {
            Node node = frame.node();
            String position = node.position() != null ? node.position().source().name() + ":" + node.position().startLine() : "";
            this.console.printf("\t%d\t%s %s%n", new Integer(i), node.getClass().getSimpleName(), position);
            ++i;
        }
    }

    public void printJavaStack(String[] args) {
        int gensym3 = 0;
        StackTraceElement[] gensym2 = this.controller.javaStack();
        if (gensym3 < gensym2.length) {
            do {
                StackTraceElement frame = gensym2[gensym3];
                this.console.printf("\t%s%n", frame);
            } while (++gensym3 < gensym2.length);
        }
    }
}

