/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.debug;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import mirah.lang.ast.Node;
import mirah.lang.ast.Position;
import org.mirah.jvm.mirrors.debug.Breakpoint;
import org.mirah.jvm.mirrors.debug.DebugController$1;
import org.mirah.jvm.mirrors.debug.DebugController$2;
import org.mirah.jvm.mirrors.debug.DebugController$3;
import org.mirah.jvm.mirrors.debug.DebugController$4;
import org.mirah.jvm.mirrors.debug.DebugController$5;
import org.mirah.jvm.mirrors.debug.DebugController$6;
import org.mirah.jvm.mirrors.debug.DebugController$7;
import org.mirah.jvm.mirrors.debug.DebugController$8;
import org.mirah.jvm.mirrors.debug.DebugListener;
import org.mirah.jvm.mirrors.debug.DebuggerInterface;
import org.mirah.jvm.mirrors.debug.Finish;
import org.mirah.jvm.mirrors.debug.Next;
import org.mirah.jvm.mirrors.debug.SingleStep;
import org.mirah.jvm.mirrors.debug.StackEntry;
import org.mirah.jvm.mirrors.debug.StepPredicate;
import org.mirah.jvm.mirrors.debug.WatchPredicate;
import org.mirah.jvm.mirrors.debug.WatchState;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ResolutionWatcher;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;

public class DebugController
implements DebuggerInterface,
ResolutionWatcher {
    private Map predicates;
    private boolean stopped;
    private Condition condition;
    private Thread thread;
    private Executor executor;
    private DebugListener listener;
    private ReentrantLock lock;
    private List asts;
    private StackEntry stack;
    private LinkedHashMap watches;
    private StepPredicate step;
    private ArrayList breakpoints;

    public DebugController(DebugListener listener, Executor executor) {
        DebugController$1 debugController$1 = new DebugController$1();
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.stopped = false;
        this.breakpoints = new ArrayList();
        this.watches = new LinkedHashMap();
        this.step = null;
        this.listener = listener;
        this.executor = executor;
        HashMap<String, WatchPredicate> hashMap = new HashMap<String, WatchPredicate>(16);
        hashMap.put("all", new DebugController$2(debugController$1));
        hashMap.put("same", new DebugController$3(debugController$1));
        hashMap.put("notsame", new DebugController$4(debugController$1));
        hashMap.put("eq", new DebugController$5(debugController$1));
        hashMap.put("ne", new DebugController$6(debugController$1));
        this.predicates = hashMap;
        this.asts = new ArrayList(0);
    }

    public StackEntry where() {
        StackEntry stackEntry;
        try {
            this.lock.lock();
            stackEntry = this.stack;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return stackEntry;
    }

    public StackTraceElement[] javaStack() {
        StackTraceElement[] stackTraceElementArray;
        try {
            this.lock.lock();
            stackTraceElementArray = this.thread.getStackTrace();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return stackTraceElementArray;
    }

    public void continueExecution() {
        try {
            this.lock.lock();
            this.step = null;
            this.unblock();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public void step() {
        try {
            this.lock.lock();
            this.step = new SingleStep();
            this.unblock();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public void next() {
        try {
            this.lock.lock();
            this.step = this.stack.result() == null ? new Next(this.stack.node()) : (this.stack.parent() != null ? new Next(this.stack.parent().node()) : null);
            this.unblock();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public void finishNode() {
        try {
            this.lock.lock();
            this.step = this.stack.result() == null ? new Finish(this.stack.node()) : (this.stack.parent() != null ? new Finish(this.stack.parent().node()) : null);
            this.unblock();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public Map watches() {
        Map map;
        try {
            this.lock.lock();
            map = Collections.unmodifiableMap(this.watches);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return map;
    }

    public boolean isValidWatchKind(String kind) {
        return this.predicates.containsKey(kind);
    }

    public boolean watch(BaseTypeFuture future, String kind) {
        Object predicate = this.predicates.get(kind);
        if (predicate == null) {
            return false;
        }
        this.lock.lock();
        try {
            this.watches.put(future, predicate);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        future.watchResolves(this);
        return true;
    }

    public void clearWatch(BaseTypeFuture future) {
        try {
            this.lock.lock();
            this.watches.remove(future);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public List breakpoints() {
        List list;
        try {
            this.lock.lock();
            list = Collections.unmodifiableList(this.breakpoints);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return list;
    }

    public boolean clearBreakpoint(Breakpoint breakpoint) {
        boolean bl;
        try {
            this.lock.lock();
            bl = this.breakpoints.remove(breakpoint);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return bl;
    }

    public boolean addBreakpoint(Breakpoint breakpoint) {
        boolean bl;
        try {
            this.lock.lock();
            bl = this.breakpoints.add(breakpoint);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return bl;
    }

    @Override
    public void parsedNode(Node node) {
        this.asts.add(node);
    }

    public List getAllParsedNodes() {
        return this.asts;
    }

    @Override
    public void inferenceError(Context context, Node node, TypeFuture error) {
        this.lock.lock();
        try {
            this.stack = new StackEntry(context, node, true, this.stack);
            this.stack.result_set(error);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        this.block();
        this.lock.lock();
        try {
            this.stack = this.stack.parent();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void enterNode(Context context, Node node, boolean expression) {
        boolean should_stop;
        block5: {
            should_stop = false;
            this.lock.lock();
            try {
                this.stack = new StackEntry(context, node, expression, this.stack);
                Position position = node.position();
                if (this.step != null ? this.step.stopBefore(this.stack) : false) {
                    should_stop = true;
                    break block5;
                }
                if (position == null) break block5;
                for (Breakpoint b : this.breakpoints) {
                    if (!b.matches(position)) continue;
                    should_stop = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
        }
        this.lock.unlock();
        if (!should_stop) return;
        this.block();
    }

    @Override
    public void exitNode(Context context, Node node, TypeFuture result) {
        this.lock.lock();
        boolean should_stop = false;
        try {
            this.stack.result_set(result);
            if (this.step != null ? this.step.stopAfter(this.stack) : false) {
                should_stop = true;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        if (should_stop) {
            this.block();
        }
        this.lock.lock();
        try {
            this.stack = this.stack.parent();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    @Override
    public void resolved(BaseTypeFuture future, ResolvedType currentValue, ResolvedType newValue) {
        this.lock.lock();
        try {
            WatchPredicate predicate = (WatchPredicate)this.watches.get(future);
            if (!(predicate != null ? predicate.test(currentValue, newValue) : false)) {
                this.lock.unlock();
                return;
            }
            StackEntry entry = this.stack;
            entry.watch_set(new WatchState(future, currentValue, newValue));
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        this.block();
        this.lock.lock();
        try {
            this.stack.watch_set(null);
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
    }

    public Object block() {
        Object v0;
        DebugController$7 debugController$7 = new DebugController$7();
        try {
            this.lock.lock();
            this.stopped = true;
            if (this.thread != null) {
            } else {
                this.thread = Thread.currentThread();
            }
            debugController$7.listener = this.listener;
            this.executor.execute(new DebugController$8(debugController$7));
            while (this.stopped) {
                this.condition.await();
            }
            v0 = null;
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return v0;
    }

    public Condition unblock() {
        Condition condition;
        try {
            this.lock.lock();
            this.stopped = false;
            Condition condition2 = this.condition;
            condition = condition2;
            condition2.signal();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return condition;
    }

    public DebugController(DebugListener listener) {
        this(listener, Executors.newSingleThreadExecutor());
    }
}

