/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.jvm.mirrors.MirrorTypeSystem;
import org.mirah.jvm.mirrors.generics.AsyncTypeBuilder;
import org.mirah.jvm.mirrors.generics.TypeVariable;
import org.mirah.jvm.model.IntersectionType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public abstract class BaseSignatureReader
extends SignatureVisitor {
    private Map typeVariables;
    private AsyncTypeBuilder classbound;
    private List interfaces;
    private Context context;
    private String typeParamName;

    public BaseSignatureReader(Context context, Map typeVariables) {
        super(Opcodes.ASM4);
        this.context = context;
        this.typeVariables = Collections.checkedMap(new HashMap(16), String.class, TypeFuture.class);
        if (typeVariables != null) {
            this.typeVariables.putAll(typeVariables);
        }
        this.classbound = null;
    }

    public Map typeVariables() {
        return this.typeVariables;
    }

    public abstract void saveTypeParam(TypeVariable var1);

    public String finishTypeParam() {
        if (this.typeParamName != null) {
            ArrayList<ResolvedType> types = new ArrayList<ResolvedType>(0);
            if (this.classbound != null) {
                types.add(this.classbound.future().resolve());
            }
            for (AsyncTypeBuilder i : this.interfaces) {
                types.add(i.future().resolve());
            }
            MirrorType bound = types.size() == 0 ? (MirrorType)((MirrorTypeSystem)this.context.get(MirrorTypeSystem.class)).loadNamedType("java.lang.Object").resolve() : (types.size() == 1 ? (MirrorType)((ResolvedType)types.get(0)) : new IntersectionType(this.context, types));
            this.saveTypeParam(new TypeVariable(this.context, this.typeParamName, bound));
        }
        this.typeParamName = null;
        return this.typeParamName;
    }

    @Override
    public void visitFormalTypeParameter(String name) {
        this.finishTypeParam();
        this.typeParamName = name;
        this.classbound = null;
        this.interfaces = new ArrayList(0);
    }

    @Override
    public SignatureVisitor visitClassBound() {
        this.classbound = this.newBuilder();
        return this.classbound;
    }

    @Override
    public SignatureVisitor visitInterfaceBound() {
        AsyncTypeBuilder builder = this.newBuilder();
        this.interfaces.add(builder);
        return builder;
    }

    public AsyncTypeBuilder newBuilder() {
        return new AsyncTypeBuilder(this.context, this.typeVariables);
    }

    public void read(String signature) {
        SignatureReader reader = new SignatureReader(signature);
        reader.accept(this);
    }

    public BaseSignatureReader(Context context) {
        this(context, Collections.emptyMap());
    }
}

