/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.mirrors.generics;

import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.Types;
import org.mirah.jvm.mirrors.BaseType;
import org.mirah.jvm.mirrors.MirrorType;
import org.mirah.util.Context;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class TypeVariable
extends BaseType
implements javax.lang.model.type.TypeVariable {
    private NullType lowerBound;
    private String name;
    private MirrorType extendsBound;

    public TypeVariable(Context context, String name, MirrorType ancestor) {
        super(context, name, null, Opcodes.ACC_PUBLIC, ancestor);
        this.name = name;
        if (ancestor == null) {
            throw new IllegalArgumentException();
        }
        this.extendsBound = ancestor;
        this.lowerBound = ((Types)context.get(Types.class)).getNullType();
    }

    @Override
    public Type getAsmType() {
        return this.extendsBound.getAsmType();
    }

    @Override
    public TypeMirror getLowerBound() {
        return this.lowerBound;
    }

    @Override
    public TypeMirror getUpperBound() {
        return this.extendsBound;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public TypeKind getKind() {
        return TypeKind.TYPEVAR;
    }

    @Override
    public Object accept(TypeVisitor v, Object p) {
        return v.visitTypeVariable(this, p);
    }

    @Override
    public boolean isSameType(MirrorType other) {
        return other == this;
    }

    @Override
    public boolean isSupertypeOf(MirrorType other) {
        return this.extendsBound.isSupertypeOf(other);
    }

    @Override
    public TypeMirror erasure() {
        return this.extendsBound.erasure();
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

