/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.mmeta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import org.mirah.mmeta.Ast;
import org.mirah.mmeta.DefaultErrorHandler;
import org.mirah.mmeta.Grow;
import org.mirah.mmeta.MemoStat;
import org.mirah.mmeta.Memoize;
import org.mirah.mmeta.Position;
import org.mirah.mmeta.RuleFailure;
import org.mirah.mmeta.SparseArrayList;
import org.mirah.mmeta.State;

public class BaseParser {
    public static boolean tracing = false;
    public static boolean debug_parse_tree = Boolean.getBoolean("org.mirah.mmeta.debug_parse_tree");
    private static final Object ERROR = new Object(){

        public String toString() {
            return "ERROR";
        }
    };
    private static final Object LEFT_REC = new Object(){

        public String toString() {
            return "LEFT_REC";
        }
    };
    private static final Grow GROW = new Grow();
    public static final Memoize NOT_MEMOIZED = new Memoize(null, -1){

        @Override
        public String toString() {
            return "not memoized";
        }
    };
    LinkedList<Object> args;
    State _stack = null;
    SparseArrayList<HashMap<String, Memoize>> _positions;
    LinkedList<HashSet<String>> _lefts;
    private TreeMap<Integer, Integer> lines = new TreeMap(new ReverseComparator());
    private long nodeCount;
    private LinkedList<String> parseTree = new LinkedList();
    public String filename = "<unknown>";
    public DiagnosticListener diagnostics = new DefaultErrorHandler();
    public int _pos = 0;
    public String _string;
    public char[] _chars;
    public Object[] _list;
    private Token<?> cached_token = new Token(null, -1, -1, -1);
    private HashMap<String, MemoStat> _stats = new HashMap();

    public BaseParser() {
        this.lines.put(0, 0);
    }

    public static String print_r(Object o) {
        StringBuffer sb = new StringBuffer();
        BaseParser.print_r(o, sb);
        return sb.toString();
    }

    public static void print_r(Object o, StringBuffer sb) {
        if (o instanceof List) {
            sb.append("[");
            for (int i = 0; i < ((List)o).size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                BaseParser.print_r(((List)o).get(i), sb);
            }
            sb.append("]");
        } else if (o instanceof Object[]) {
            sb.append("[");
            for (int i = 0; i < ((Object[])o).length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                BaseParser.print_r(((Object[])o)[i], sb);
            }
            sb.append("]");
        } else {
            sb.append(o);
        }
    }

    public void _enter(String label) {
        if (debug_parse_tree) {
            String parent = this.parseTree.peekLast();
            if ("ws".equals(label) || "<skip>".equals(label) || "skip".equals(parent)) {
                this.parseTree.addLast("skip");
                return;
            }
            String nodeName = "n" + this.nodeCount++;
            label = label.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
            System.out.println("  " + nodeName + "[label=\"" + label + "\"];");
            if (parent != null) {
                System.out.println("  " + parent + " -- " + nodeName + ";");
            }
            this.parseTree.addLast(nodeName);
        }
    }

    public Object _exit(Object result) {
        String nodeName;
        if (debug_parse_tree && !"skip".equals(nodeName = this.parseTree.removeLast()) && (result == ERROR || result instanceof RuleFailure)) {
            System.out.println("  " + nodeName + "[color=red];");
        }
        return result;
    }

    public Object trace(Object ... args) throws RuleFailure {
        Object result;
        if (tracing) {
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(BaseParser.print_r(args[i]));
            }
            System.out.println(" at " + this._pos);
        }
        if ((result = args[args.length - 1]) == ERROR) {
            return this._error("");
        }
        if (result instanceof RuleFailure) {
            throw (RuleFailure)result;
        }
        return result;
    }

    public Object _error(String expected) throws RuleFailure {
        RuleFailure failure = new RuleFailure();
        failure.last = expected;
        throw failure;
    }

    public int _pos() {
        return this._pos;
    }

    public void _pos_set(int pos) {
        this._pos = pos;
    }

    public String _string() {
        return this._string;
    }

    public char[] _chars() {
        return this._chars;
    }

    public Object[] _list() {
        return this._list;
    }

    public void _list_set(Object[] list) {
        this._list = list;
    }

    public Object _memoize(String s, int p, Object o) throws Grow, RuleFailure {
        MemoStat stats;
        HashMap<String, Memoize> map = this._positions.get(p);
        if (map == null) {
            map = new HashMap();
            this._positions.set(p, map);
        }
        if ((stats = this._stats.get(s)) == null) {
            stats = new MemoStat();
            stats.name = s;
            this._stats.put(s, stats);
        }
        ++stats.stores;
        Memoize entry = map.get(s);
        if (entry == null) {
            if (this.args.isEmpty()) {
                entry = new Memoize(o, p);
                map.put(s, entry);
            } else {
                return this.trace("unmemoize:", s, o);
            }
        }
        if (entry.seed != -1) {
            if (o instanceof RuleFailure || this._pos <= entry.pos) {
                this._pos = entry.pos;
                entry.seed = -1;
                this._lefts.pop();
                return this.trace("< END:", s, this._pos, entry.val);
            }
            for (String k : this._lefts.pop()) {
                map.remove(k);
            }
            this._lefts.push(new HashSet());
            entry.val = o;
            entry.pos = this._pos;
            this._pos = entry.seed;
            throw GROW;
        }
        if (!this._lefts.isEmpty()) {
            this._lefts.peek().add(s);
        }
        entry.pos = this._pos;
        entry.val = o;
        if (o instanceof RuleFailure) {
            this._pos = p;
            return this.trace("< err:", s, o);
        }
        return this.trace("<  ok:", s, o);
    }

    public Object _sretrieve(String s) throws RuleFailure {
        Memoize entry;
        if (!this.args.isEmpty()) {
            return this.trace(">ntry:", s, NOT_MEMOIZED);
        }
        int p = this._pos;
        HashMap<String, Memoize> map = this._positions.get(p);
        MemoStat stats = this._stats.get(s);
        if (stats == null) {
            stats = new MemoStat();
            this._stats.put(s, stats);
            stats.name = s;
        }
        Memoize memoize = entry = map == null ? null : map.get(s);
        if (entry == null) {
            ++stats.misses;
        } else {
            ++stats.hits;
            this._pos = entry.pos;
            if (entry.val == LEFT_REC) {
                entry.val = ERROR;
                entry.seed = entry.pos;
                this._lefts.push(new HashSet());
                stats.recursion = true;
                return this.trace(">LEFT:", s, this._pos, ERROR);
            }
            if (entry.val == ERROR) {
                return this.trace("> err:", s, entry.val);
            }
            return this.trace(">  ok:", s, entry.val);
        }
        return this.trace("> try:", s, NOT_MEMOIZED);
    }

    public Object _retrieve(String s) throws RuleFailure {
        Object o = this._sretrieve(s);
        if (o == NOT_MEMOIZED && this.args.isEmpty()) {
            HashMap<String, Memoize> map = this._positions.get(this._pos);
            if (map == null) {
                map = new HashMap();
                this._positions.set(this._pos, map);
            }
            map.put(s, new Memoize(LEFT_REC, this._pos));
        }
        return o;
    }

    public void _init() {
        this._pos = 0;
        this._positions = new SparseArrayList();
        this._lefts = new LinkedList();
        this.lines = new TreeMap(new ReverseComparator());
        this.lines.put(0, 0);
        this.args = new LinkedList();
        this.init();
    }

    public void init() {
    }

    public void init(String s) {
        this._string = s;
        this._chars = s.toCharArray();
        this._list = null;
        this._init();
    }

    public void init(Object[] ls) {
        this._string = null;
        this._list = ls;
        this._init();
    }

    public void init(ArrayList<? extends Object> as) {
        this._string = null;
        this._list = as.toArray();
        this._init();
    }

    public void init(List<? extends Object> as) {
        this.init(new ArrayList<Object>(as).toArray());
    }

    public Object parse(Object o) {
        return this.parse(o, null);
    }

    public Object parse(Object o, String r) {
        if (o instanceof ArrayList) {
            this.init((ArrayList)o);
        } else if (o instanceof Object[]) {
            this.init((Object[])o);
        } else if (o instanceof String) {
            this.init((String)o);
        } else if (o instanceof List) {
            this.init((List)o);
        } else {
            throw new AssertionError((Object)("parse requires a List, Object[] or String; got " + (o == null ? "null" : o.getClass().toString())));
        }
        if (debug_parse_tree) {
            System.out.println("graph parse {");
        }
        Object _t = null;
        try {
            _t = r != null ? this._jump(r.intern()) : this.start();
        }
        catch (RuleFailure ex) {
            this.syntaxError("", ex);
        }
        catch (AbortParse ex) {
            // empty catch block
        }
        if (debug_parse_tree) {
            System.out.println("}");
            System.err.println("Memo Stats:");
            for (MemoStat stat : this._stats.values()) {
                if (stat.hits == 0L) continue;
                System.err.println(stat.name + ": " + stat.stores + " stores, " + stat.hits + " hits, " + (double)stat.hits / (double)(stat.hits + stat.misses));
            }
        }
        return _t;
    }

    public RuntimeException syntaxError(String message, RuleFailure ex) {
        this.diagnostics.report(this.diagnostic(Diagnostic.Kind.ERROR, this.makeSyntaxErrorMessage(message, ex == null ? "" : ex.last), this._pos));
        throw new AbortParse();
    }

    public void warn(String message) {
        this.diagnostics.report(this.diagnostic(Diagnostic.Kind.WARNING, message, this._pos));
    }

    public void warn(String message, String message2, int position2) {
        this.diagnostics.report(this.diagnostic(Diagnostic.Kind.WARNING, message, this._pos));
        this.diagnostics.report(this.diagnostic(Diagnostic.Kind.NOTE, message2, position2));
    }

    public Object start() {
        throw new IllegalStateException("provide a rule called 'start'");
    }

    public void _push(Object ... as) {
        for (int i = as.length - 1; i >= 0; --i) {
            this.args.push(as[i]);
        }
    }

    public void _push(Object a) {
        this.args.push(a);
    }

    public Object _pop() {
        return this.args.pop();
    }

    public Object apply() throws RuleFailure {
        return this.apply(this._pop());
    }

    public Object apply(Object r) throws RuleFailure {
        if (!(r instanceof String)) {
            return this._error("apply() must receive a string");
        }
        try {
            return this._jump((String)r);
        }
        catch (AssertionError e) {
            return this._jump(((String)r).intern());
        }
    }

    public boolean hasRule() {
        Object r = this._pop();
        return this.hasRule(r);
    }

    public boolean hasRule(Object r) {
        if (!(r instanceof String)) {
            return false;
        }
        return this._has(((String)r).intern());
    }

    public Object str() throws RuleFailure {
        return this.str(this._pop());
    }

    public Object str(Object r) throws RuleFailure {
        if (!(r instanceof String)) {
            throw new IllegalArgumentException("'str' must receive a String; not: " + r);
        }
        return this._str((String)r);
    }

    public Object sym() throws RuleFailure {
        return this.sym(this._pop());
    }

    public Object sym(Object r) throws RuleFailure {
        if (!(r instanceof String)) {
            throw new IllegalArgumentException("'sym' must receive a String; not: " + r);
        }
        return this._sym((String)r);
    }

    public void note_newline(int pos) {
        if (!this.lines.containsKey(pos)) {
            this.lines.put(pos, this.lines.size());
        }
    }

    public Object _any() throws RuleFailure {
        if (!this.args.isEmpty()) {
            return this.args.pop();
        }
        if (this._string != null) {
            if (this._pos < this._chars.length) {
                char c;
                if ((c = this._chars[this._pos++]) == '\n' || c == '\r' && this._cpeek() != '\n') {
                    this.note_newline(this._pos);
                }
                return Character.valueOf(c);
            }
            return this._error("");
        }
        if (this._list != null) {
            if (this._pos < this._list.length) {
                return this._exit(this._list[this._pos++]);
            }
            return this._error("");
        }
        throw new IllegalStateException("no _list nor _string??");
    }

    public Object empty() {
        if (this._string != null) {
            return "";
        }
        return null;
    }

    public Position pos() {
        return this.pos(this._pos);
    }

    public Position pos(int pos) {
        if (this._string == null) {
            throw new IllegalStateException("'pos' is only available in string parsing");
        }
        int linepos = this.lines.tailMap(pos).firstKey();
        int line = this.lines.get(linepos);
        return new Position(this.filename, pos, linepos, line);
    }

    protected Object getDiagnosticSource() {
        if (this.filename != null && !"<unknown>".equals(this.filename)) {
            return this.filename;
        }
        if (this._string != null) {
            return this._string;
        }
        return this._list;
    }

    public Diagnostic diagnostic(final Diagnostic.Kind kind, final String message, int pos) {
        final Object source = this.getDiagnosticSource();
        final int position = pos;
        int linepos = this._string == null ? 0 : this.lines.tailMap(pos).firstKey();
        final int line = this._string == null ? 1 : this.lines.get(linepos) + 1;
        final long col = this._string == null ? -1L : (long)(pos - linepos + 1);
        return new Diagnostic(){

            @Override
            public String getCode() {
                return null;
            }

            @Override
            public long getColumnNumber() {
                return col;
            }

            @Override
            public long getStartPosition() {
                return position;
            }

            @Override
            public long getPosition() {
                return position;
            }

            @Override
            public long getEndPosition() {
                return position;
            }

            @Override
            public long getLineNumber() {
                return line;
            }

            @Override
            public Diagnostic.Kind getKind() {
                return kind;
            }

            @Override
            public String getMessage(Locale l) {
                return message;
            }

            public Object getSource() {
                return source;
            }
        };
    }

    private String makeSyntaxErrorMessage(String msg, String expected) {
        StringBuilder sb = new StringBuilder();
        if (this._string != null) {
            int n;
            int linepos = this.lines.tailMap(this._pos).firstKey();
            int line = this.lines.get(linepos) + 1;
            sb.append("expected ");
            if (msg.length() > 0) {
                sb.append(msg);
            } else {
                sb.append(expected);
            }
            String s = this._string.substring(this._pos, Math.min(this._pos + 13, this._string.length()));
            if (this._pos >= this._string.length()) {
                s = "<EOF>";
            }
            if ((n = s.indexOf(10)) > 0) {
                s = s.substring(0, n);
            }
            sb.append(" before '");
            sb.append(s);
            sb.append("'");
            return sb.toString();
        }
        msg = msg.length() > 0 ? "expected " + msg : "expected " + expected;
        msg = msg + " before '" + BaseParser.print_r(this._list[this._pos]) + "'";
        return "" + msg + " (at pos: " + this._pos + ")";
    }

    public Object col() {
        int pos;
        if (this._string == null) {
            throw new IllegalStateException("'col' is only available in string parsing");
        }
        for (pos = this._pos - 1; pos >= 0 && this._chars[pos] != '\n'; --pos) {
        }
        return this._pos - pos - 1;
    }

    public Ast build_node(String name, List<?> children, int start_pos, int end_pos) {
        Ast node = new Ast(name, children);
        node.start_position_set(this.pos(start_pos));
        node.end_position_set(this.pos(end_pos));
        return node;
    }

    public Ast build_node(String name, int start_pos, int end_pos) {
        Ast node = new Ast(name);
        node.start_position_set(this.pos(start_pos));
        node.end_position_set(this.pos(end_pos));
        return node;
    }

    public Ast build_node(String name, Object children, int start_pos, int end_pos) {
        return this.build_node(name, (List)children, start_pos, end_pos);
    }

    public String text(int start, int end) {
        return this._string.substring(start, end);
    }

    public char _cpeek() throws RuleFailure {
        if (this._pos < this._chars.length) {
            return this._chars[this._pos];
        }
        this._error("");
        return '\u0000';
    }

    public String _rpeek() {
        if (this._pos == 0 || this._string == null) {
            return "";
        }
        return this._string.substring(this._pos - 1, this._pos);
    }

    public Object _peek() throws RuleFailure {
        if (!this.args.isEmpty()) {
            return this.args.peek();
        }
        if (this._string != null) {
            if (this._pos < this._chars.length) {
                return Character.valueOf(this._chars[this._pos]);
            }
            return this._error("");
        }
        if (this._list != null) {
            if (this._pos < this._list.length) {
                return this._list[this._pos];
            }
            return this._error("");
        }
        throw new IllegalStateException("no _list nor _string??");
    }

    public Object end() throws RuleFailure {
        try {
            this._peek();
        }
        catch (RuleFailure ex) {
            return null;
        }
        return this._error("end of input");
    }

    public Object __end__() throws RuleFailure {
        return this.end();
    }

    public Object ws() throws RuleFailure {
        if (this._string == null) {
            throw new IllegalStateException("whitespace ('.') is only available in string parsing");
        }
        try {
            char c;
            while ((c = this._cpeek()) == ' ' || c == '\t' || c == '\f' || c == '\n' | c == '\r') {
                this._any();
            }
        }
        catch (RuleFailure ex) {
            return null;
        }
        return null;
    }

    public Object _str(String s) throws RuleFailure {
        this.trace("try _str():", s);
        this._enter("'" + s + "'");
        if (this._string == null) {
            throw new IllegalStateException("string ('\"" + s + "\"') is only available in string parsing");
        }
        int p = this._pos;
        if (p + s.length() > this._chars.length) {
            return this._error("'" + s + "'");
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == this._chars[p++]) continue;
            this._exit(ERROR);
            return this._error("'" + s + "'");
        }
        this._pos = p;
        return this._exit(this.trace(" ok _str():", s));
    }

    public Object _sym(String s) throws RuleFailure {
        this.trace("try _sym():", s);
        if (this._list == null && this.args.isEmpty()) {
            throw new IllegalStateException("symbol ('`" + s + "') is only available in list parsing");
        }
        if (this._peek().equals(s)) {
            this._any();
            return this.trace(" ok _sym():", s);
        }
        return this._error(s);
    }

    public Object _char(String s) throws RuleFailure {
        this._enter("[" + s + "]");
        if (this._string == null) {
            throw new IllegalStateException("charRange is only available in string parsing");
        }
        char c = this._cpeek();
        if (s.indexOf(c) >= 0) {
            this._any();
            return this._exit(Character.valueOf(c));
        }
        this._exit(ERROR);
        return this._error("[" + s + "]");
    }

    public Object nl() throws RuleFailure {
        return this._char("\n\r");
    }

    public Object sp() throws RuleFailure {
        return this._char(" \t\f");
    }

    public Object _charRange(char b, char e) throws RuleFailure {
        if (this._string == null) {
            throw new IllegalStateException("charRange is only available in string parsing");
        }
        char c = this._cpeek();
        if (c >= b && c <= e) {
            this._any();
            return Character.valueOf(c);
        }
        return this._error("[" + b + "-" + e + "]");
    }

    public Object digit() throws RuleFailure {
        return this._charRange('0', '9');
    }

    public Object letter() throws RuleFailure {
        try {
            return this._charRange('a', 'z');
        }
        catch (RuleFailure ex) {
            return this._charRange('A', 'Z');
        }
    }

    public String join(Object ls) {
        return this.join(ls, "");
    }

    public String join(Object ls, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (ls instanceof Object[]) {
            for (Object o : (Object[])ls) {
                if (first) {
                    first = false;
                } else {
                    sb.append(sep);
                }
                sb.append(o.toString());
            }
        } else if (ls instanceof List) {
            for (Object o : (List)ls) {
                if (first) {
                    first = false;
                } else {
                    sb.append(sep);
                }
                sb.append(o.toString());
            }
        } else if (ls != null) {
            throw new IllegalArgumentException("'join' must receive a List or Object[]. Got " + ls.getClass().getName());
        }
        return sb.toString();
    }

    public List concat(Object ls, Object rs) {
        if (ls == null) {
            if (rs == null) {
                return Collections.emptyList();
            }
            ls = rs;
            rs = null;
        }
        if (ls instanceof Object[]) {
            Object[] la = (Object[])ls;
            if (rs instanceof Object[]) {
                Object[] ra = (Object[])rs;
                Object[] na = Arrays.copyOf(la, la.length + ra.length);
                System.arraycopy(rs, 0, na, la.length, ra.length);
                return Arrays.asList(new Object[]{na});
            }
            if (rs instanceof List) {
                List ra = (List)rs;
                Object[] na = Arrays.copyOf(la, la.length + ra.size());
                for (int i = 0; i < ra.size(); ++i) {
                    na[la.length + i] = ra.get(i);
                }
                return Arrays.asList(na);
            }
            if (rs == null) {
                return Arrays.asList(la);
            }
        } else if (ls instanceof List) {
            List la = (List)ls;
            if (rs instanceof Object[]) {
                Object[] ra = (Object[])rs;
                ArrayList<Object> na = new ArrayList<Object>(la);
                na.addAll(Arrays.asList(ra));
                return na;
            }
            if (rs instanceof List) {
                List ra = (List)rs;
                ArrayList na = new ArrayList(la);
                na.addAll(ra);
                return na;
            }
            if (rs == null) {
                return la;
            }
        }
        throw new IllegalArgumentException("'concat' must receive two Lists or Object[]s. Got " + ls.getClass().getName() + " and " + rs.getClass().getName());
    }

    public Object _listBegin() throws RuleFailure {
        if (this._list == null) {
            throw new IllegalStateException("list ('[ ... ]') operations only available in list parsing");
        }
        Object ls = this._peek();
        Object[] list = null;
        if (ls instanceof Object[]) {
            list = (Object[])ls;
        } else if (ls instanceof ArrayList) {
            list = ((ArrayList)ls).toArray();
        } else if (ls instanceof List) {
            list = new ArrayList((List)ls).toArray();
        } else {
            return this._error("");
        }
        this._any();
        this._stack = new State(this._stack, this._pos, this._list, this._positions);
        this._pos = 0;
        this._list = list;
        this._positions = new SparseArrayList();
        return null;
    }

    public void _listEnd() {
        this._pos = this._stack.pos;
        this._list = this._stack.list;
        this._positions = this._stack.positions;
        this._stack = this._stack.prev;
    }

    public Object _jump(String r) throws RuleFailure {
        throw new AssertionError((Object)("_jump: rule '" + r + "' does not exist; or not properly implemented yet"));
    }

    public boolean _has(String r) {
        return false;
    }

    public <T extends Enum<T>> Token<T> build_token(Enum<T> type, int pos, int start) {
        return new Token<T>(type, pos, start, this._pos);
    }

    public <T extends Enum<T>> Token<T> build_token(Enum<T> type, int pos, int start, int endpos) {
        return new Token<T>(type, pos, start, endpos);
    }

    public class Token<T extends Enum<T>> {
        public final Enum<T> type;
        public final int pos;
        public final int startpos;
        public final int endpos;

        public Token(Enum<T> type, int pos, int start, int end) {
            this.type = type;
            this.pos = pos;
            this.startpos = start == -1 ? pos : start;
            this.endpos = end;
        }

        public String text() {
            return BaseParser.this._string.substring(this.startpos, this.endpos);
        }

        public boolean space_seen() {
            return this.pos != this.startpos;
        }

        public String toString() {
            return "<Token " + this.type + ": '" + this.text() + "'>";
        }
    }

    private static class ReverseComparator
    implements Comparator<Comparable> {
        private ReverseComparator() {
        }

        @Override
        public int compare(Comparable a, Comparable b) {
            return -a.compareTo(b);
        }
    }

    private static class AbortParse
    extends RuntimeException {
        private AbortParse() {
        }
    }
}

