/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import mirah.lang.ast.Position;
import org.mirah.typer.AssignableTypeFuture$1;
import org.mirah.typer.AssignableTypeFuture$2;
import org.mirah.typer.AssignableTypeFuture$3;
import org.mirah.typer.AssignableTypeFuture$4;
import org.mirah.typer.AssignmentFuture;
import org.mirah.typer.BaseTypeFuture;
import org.mirah.typer.ErrorType;
import org.mirah.typer.FuturePrinter;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;

public class AssignableTypeFuture
extends BaseTypeFuture {
    private boolean resolving;
    private ReentrantLock lock;
    private static Logger log = Logger.getLogger(AssignableTypeFuture.class.getName());
    private LinkedHashMap declarations;
    private LinkedHashMap assignments = new LinkedHashMap();
    private boolean checking;

    public AssignableTypeFuture(Position position) {
        super(position);
        this.declarations = new LinkedHashMap();
        this.lock = new ReentrantLock();
    }

    public TypeFuture declare(TypeFuture type, Position position) {
        TypeFuture typeFuture;
        AssignableTypeFuture$3 assignableTypeFuture$3 = new AssignableTypeFuture$3();
        try {
            this.lock.lock();
            if (this.declarations.containsKey(type)) {
                log.finest("already visited declaration for " + type);
                typeFuture = (TypeFuture)this.declarations.get(type);
            } else if (this.declarations.isEmpty()) {
                log.finest("first declaration as " + type);
                assignableTypeFuture$3.base_type = this;
                type.onUpdate(new AssignableTypeFuture$4(assignableTypeFuture$3));
                this.position_set(position);
                this.declarations.put(type, this);
                typeFuture = this;
            } else {
                Set gensym0 = ((HashMap)this.declarations).keySet();
                ArrayList<ResolvedType> gensym1 = new ArrayList<ResolvedType>(gensym0.size());
                for (TypeFuture future : gensym0) {
                    gensym1.add(future.resolve());
                }
                ArrayList<ResolvedType> earlier_declarations = gensym1;
                String msg = "Type redeclared as " + type.resolve() + " from " + earlier_declarations;
                log.finest(msg);
                ArrayList arrayList = new ArrayList(2);
                ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
                arrayList2.add(msg);
                arrayList2.add(position);
                arrayList.add(arrayList2);
                ArrayList<Object> arrayList3 = new ArrayList<Object>(2);
                arrayList3.add("First declared");
                arrayList3.add(this.position());
                arrayList.add(arrayList3);
                TypeFuture declared_type_error = new ErrorType(arrayList);
                this.declarations.put(type, declared_type_error);
                this.resolved((ResolvedType)((Object)declared_type_error));
                typeFuture = declared_type_error;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return typeFuture;
    }

    public TypeFuture assign(TypeFuture value, Position position) {
        TypeFuture typeFuture;
        AssignableTypeFuture$1 assignableTypeFuture$1 = new AssignableTypeFuture$1();
        try {
            this.lock.lock();
            if (this.assignments.containsKey(value)) {
                typeFuture = (TypeFuture)this.assignments.get(value);
            } else {
                assignableTypeFuture$1.assignment = new AssignmentFuture(this, value, position);
                this.assignments.put(value, assignableTypeFuture$1.assignment);
                assignableTypeFuture$1.variable = this;
                value.onUpdate(new AssignableTypeFuture$2(assignableTypeFuture$1));
                typeFuture = assignableTypeFuture$1.assignment;
            }
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return typeFuture;
    }

    public ErrorType incompatibleWith(ResolvedType value, Position position) {
        ArrayList arrayList = new ArrayList(1);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(2);
        arrayList2.add("Cannot assign " + value + " to " + this.inferredType());
        arrayList2.add(position);
        arrayList.add(arrayList2);
        return new ErrorType(arrayList);
    }

    public boolean hasDeclaration() {
        boolean bl;
        try {
            this.lock.lock();
            bl = !this.declarations.isEmpty();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return bl;
    }

    public Collection assignedValues(boolean includeParent, boolean includeChildren) {
        Collection collection;
        try {
            this.lock.lock();
            collection = ((HashMap)this.assignments).keySet();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return collection;
    }

    public TypeFuture declaredType() {
        TypeFuture typeFuture;
        try {
            this.lock.lock();
            typeFuture = this.declarations.isEmpty() ? null : (TypeFuture)((HashMap)this.declarations).keySet().iterator().next();
            this.lock.unlock();
        }
        catch (Throwable throwable) {
            this.lock.unlock();
            throw throwable;
        }
        return typeFuture;
    }

    @Override
    public void dump(FuturePrinter out) {
        out.write("resolved: ");
        super.dump(out);
        if (this.hasDeclaration()) {
            out.write("declared: ");
            out.printFuture(this.declaredType());
        }
        for (TypeFuture value : this.assignedValues(true, true)) {
            out.printFuture(value);
            if (value.isResolved()) continue;
            out.writeLine("(resolved: " + value.resolve() + ")");
        }
    }

    @Override
    public Map getComponents() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.hasDeclaration()) {
            map.put("declaration", this.declaredType());
        }
        map.put("values", this.assignedValues(true, true));
        return map;
    }

    public void checkAssignments() {
        if (this.hasDeclaration()) {
            return;
        }
        if (this.checking) {
            return;
        }
        try {
            this.checking = true;
            ResolvedType type = null;
            ResolvedType error = null;
            LinkedHashSet values = new LinkedHashSet(this.assignedValues(true, true));
            HashSet<TypeFuture> errors = new HashSet<TypeFuture>();
            ResolvedType saved_type = this.isResolved() ? this.resolve() : null;
            for (TypeFuture value : values) {
                if (value.isResolved()) {
                    ResolvedType resolved = value.resolve();
                    if (resolved.isError()) {
                        log.finest(this + ": found error " + resolved);
                        errors.add(value);
                        if (error != null) continue;
                        error = resolved;
                        continue;
                    }
                    log.finest(this + ": adding type " + resolved);
                    if (type != null) {
                        type = type.widen(value.resolve());
                        continue;
                    }
                    type = resolved;
                    continue;
                }
                errors.add(value);
            }
            ResolvedType $or$1 = type;
            log.finer(this + ": checkAssignments: resolving as " + $or$1 + ($or$1 != null ? $or$1 : error));
            ResolvedType $or$2 = type;
            this.resolved($or$2 != null ? $or$2 : error);
            log.finest(this + ": checkAssignments: checking for conflicts " + saved_type + " " + type);
            if ((saved_type != null ? type : null) != null) {
                for (TypeFuture value : values) {
                    boolean is_resolved = value.isResolved() ? !value.resolve().isError() : false;
                    boolean $or$3 = is_resolved;
                    if ($or$3 ? $or$3 : errors.contains(value)) continue;
                    log.fine(this + ": checkAssignments: conflict found, reverting to " + saved_type);
                    this.resolved(saved_type);
                    this.checking = false;
                    return;
                }
            }
            this.checking = false;
        }
        catch (Throwable throwable) {
            this.checking = false;
            throw throwable;
        }
    }

    @Override
    public ResolvedType resolve() {
        if (!this.isResolved()) {
            this.lock.lock();
            try {
                if (!this.resolving) {
                    this.resolving = true;
                    if (this.hasDeclaration()) {
                        log.finer(this + ": Resolving declarations");
                        for (TypeFuture t : ((HashMap)this.declarations).keySet()) {
                            t.resolve();
                        }
                        log.finer(this + ": done");
                    } else {
                        log.finer(this + ": Resolving assignments");
                        for (TypeFuture v : this.assignedValues(true, true)) {
                            v.resolve();
                        }
                        log.finer(this + ": done");
                    }
                    this.resolving = false;
                }
                this.lock.unlock();
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
        }
        return super.resolve();
    }
}

