/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FormalArgument;
import mirah.lang.ast.FunctionalCall;
import mirah.lang.ast.Hash;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.LocalAssignment;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.Position;
import mirah.lang.ast.SimpleString;
import org.mirah.jvm.mirrors.MirrorScope;
import org.mirah.typer.BetterClosureBuilder;
import org.mirah.typer.BindingAdjuster$1;
import org.mirah.typer.BindingAdjuster$2;
import org.mirah.typer.BindingAdjuster$3;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeFuture;

public class BindingAdjuster
extends NodeScanner {
    private ClosureDefinition binding_klass_node;
    private Map blockToBindings;
    private MirrorScope parent_scope;
    private List captured;
    private BetterClosureBuilder builder;
    private TypeFuture binding_type;
    private Map bindingLocalNamesToTypes;
    private Stack blocks;
    private String bindingName;
    private static Logger log = Logger.getLogger(BindingAdjuster.class.getName());

    public BindingAdjuster(BetterClosureBuilder builder, String bindingName, MirrorScope parent_scope, Map blockToBindings, Map bindingLocalNamesToTypes) {
        this.builder = builder;
        this.captured = parent_scope.capturedLocals();
        this.blockToBindings = blockToBindings;
        this.bindingLocalNamesToTypes = bindingLocalNamesToTypes;
        this.blocks = new Stack();
        this.parent_scope = parent_scope;
        this.bindingName = bindingName;
    }

    public void adjust(Node node) {
        BindingAdjuster$1 bindingAdjuster$1 = new BindingAdjuster$1();
        log.fine("adjusting " + node);
        log.fine("captures for " + this.bindingName + ": " + this.parent_scope.capturedLocals());
        if (this.captured.isEmpty()) {
            log.fine("no need for binding adjustment here. Nothing captured");
            return;
        }
        if (this.parent_scope.declared_binding_type() != null) {
            log.fine("no need for binding adjustment here. already bound to " + this.parent_scope.declared_binding_type());
            return;
        }
        String name = this.builder.temp_name_from_outer_scope(node, "ZBinding");
        log.fine("building binding " + name + " with captures " + this.captured);
        ClosureDefinition binding_klass = this.builder.build_class(node.position(), null, name);
        List gensym4 = this.captured;
        ArrayList<HashEntry> gensym5 = new ArrayList<HashEntry>(gensym4.size());
        for (String bindingAdjuster$1.cap : gensym4) {
            ResolvedType type = this.parent_scope.getLocalType(bindingAdjuster$1.cap, node.position()).resolve();
            gensym5.add(new HashEntry(new SimpleString(bindingAdjuster$1.cap), new Constant(new SimpleString(type.name()))));
        }
        ArrayList<HashEntry> entries = gensym5;
        SimpleString simpleString = new SimpleString("attr_accessor");
        ArrayList<Hash> arrayList = new ArrayList<Hash>(1);
        arrayList.add(new Hash(node.position(), entries));
        FunctionalCall attr_def = new FunctionalCall(simpleString, arrayList, null);
        binding_klass.body().insert(0, attr_def);
        ResolvedType binding_type = this.builder.infer(binding_klass).resolve();
        if (this.parent_scope.declared_binding_type() != null) {
            throw new Exception("parent_scope had declared_binding_type already " + this.parent_scope);
        }
        this.parent_scope.declared_binding_type_set(binding_type);
        this.bindingLocalNamesToTypes.put(this.bindingName, binding_type);
        Call binding_new_call = new Call(node.position(), new Constant(new SimpleString(name)), new SimpleString("new"), new ArrayList(0), null);
        this.builder.typer().workaroundASTBug(binding_new_call);
        LocalAssignment assign_binding_dot_new = new LocalAssignment(node.position(), new SimpleString(this.bindingName), binding_new_call);
        log.fine("inserted binding assign / binding class ");
        this.builder.insert_into_body((NodeList)node, assign_binding_dot_new);
        this.builder.insert_into_body((NodeList)node, binding_klass);
        this.binding_type = this.builder.infer(binding_klass);
        this.binding_klass_node = binding_klass;
        this.builder.infer(assign_binding_dot_new);
        log.fine("binding assignment inference done");
        log.fine("replacing references to captures");
        Node mdef = node.findAncestor(new BindingAdjuster$2(bindingAdjuster$1));
        Node block_parent = node.findAncestor(new BindingAdjuster$3(bindingAdjuster$1));
        Arguments arguments = mdef != null ? ((MethodDefinition)mdef).arguments() : (block_parent != null ? ((Block)block_parent).arguments() : null);
        node.accept(this, new Integer(1));
        log.fine("finished phase one of capture replacement");
        ArrayList<String> arg_names = new ArrayList<String>(0);
        if (arguments.required() != null) {
            for (FormalArgument a : arguments.required()) {
                arg_names.add(a.name().identifier());
            }
        }
        if (arguments.optional() != null) {
            for (FormalArgument a : arguments.optional()) {
                arg_names.add(a.name().identifier());
            }
        }
        if (arguments.rest() != null) {
            arg_names.add(arguments.rest().name().identifier());
        }
        if (arguments.required2() != null) {
            for (FormalArgument a : arguments.required2()) {
                arg_names.add(a.name().identifier());
            }
        }
        if (arguments.block() != null) {
            arg_names.add(arguments.block().name().identifier());
        }
        log.fine("adding assignments from args to captures");
        for (String arg : arg_names) {
            if (!this.captured.contains(arg)) continue;
            NodeImpl nodeImpl = this.blockAccessNode(node.position());
            SimpleString simpleString2 = new SimpleString(arg + "_set");
            ArrayList<LocalAccess> arrayList2 = new ArrayList<LocalAccess>(1);
            arrayList2.add(new LocalAccess(node.position(), new SimpleString(arg)));
            Call addition = new Call(nodeImpl, simpleString2, arrayList2, null);
            this.builder.typer().workaroundASTBug(addition);
            ((NodeList)node).insert(2, addition);
            this.builder.infer(addition);
        }
        log.fine("done replacing references");
    }

    @Override
    public boolean enterClosureDefinition(ClosureDefinition node, Object blah) {
        return this.binding_klass_node != node;
    }

    @Override
    public Object exitClosureDefinition(ClosureDefinition node, Object blah) {
        Object v0 = null;
        return null;
    }

    @Override
    public boolean enterBlock(Block node, Object blah) {
        this.blocks.push(node);
        Map $ptemp$1 = this.blockToBindings;
        Object $ptemp$2 = this.blocks.peek();
        Object $or$3 = $ptemp$1.get($ptemp$2);
        if ($or$3 == null) {
            $ptemp$1.put($ptemp$2, new HashSet());
        }
        return true;
    }

    @Override
    public Object exitBlock(Block node, Object blah) {
        return this.blocks.pop();
    }

    public Object maybeNoteBlockBinding() {
        for (Block block : this.blocks) {
            ((Collection)this.blockToBindings.get(block)).add(this.bindingName);
        }
        return null;
    }

    public NodeImpl blockAccessNode(Position position) {
        SimpleString name_node = new SimpleString(this.bindingName);
        return this.blocks.isEmpty() ? new LocalAccess(position, name_node) : new FieldAccess(position, name_node);
    }

    @Override
    public Object exitLocalAssignment(LocalAssignment local, Object blah) {
        String local_name = local.name().identifier();
        if (!this.captured.contains(local_name)) {
            return null;
        }
        log.finest("enterLocalAssignment: replacing " + local.name().identifier() + " with " + this.bindingName + "." + local.name().identifier() + "=");
        log.finest("  Type: " + this.builder.typer().getInferredType(local));
        this.maybeNoteBlockBinding();
        Node new_value = local.value();
        new_value.setParent(null);
        NodeImpl nodeImpl = this.blockAccessNode(local.position());
        SimpleString simpleString = new SimpleString(local.name().identifier() + "_set");
        ArrayList<Node> arrayList = new ArrayList<Node>(1);
        arrayList.add(new_value);
        Call replacement = new Call(nodeImpl, simpleString, arrayList, null);
        this.builder.typer().workaroundASTBug(replacement);
        this.replaceSelf(local, replacement);
        local.value().setParent(replacement);
        this.builder.typer().learnType(replacement.target(), this.binding_type);
        this.builder.typer().infer(new_value);
        return this.builder.typer().infer(replacement);
    }

    @Override
    public Object exitLocalAccess(LocalAccess local, Object blah) {
        Call replacement;
        block2: {
            String local_name = local.name().identifier();
            if (!this.captured.contains(local_name)) {
                return null;
            }
            log.finest("enterLocalAccess: replacing " + local.name().identifier() + " with " + this.bindingName + "." + local.name().identifier() + "=");
            log.finest("  Type: " + this.builder.typer().getInferredType(local));
            this.maybeNoteBlockBinding();
            replacement = new Call(this.blockAccessNode(local.position()), new SimpleString(local.position(), local.name().identifier()), new ArrayList(0), null);
            this.builder.typer().workaroundASTBug(replacement);
            this.replaceSelf(local, replacement);
            this.builder.typer().learnType(replacement.target(), this.binding_type);
            log.fine("does replacement have parent?: " + replacement.parent());
            if (replacement.parent() instanceof NodeList) {
                log.fine("does replacement parent 0th child: " + ((NodeList)replacement.parent()).get(0));
            }
            if (replacement.parent() == null) break block2;
            log.fine("does replacement have parent?: " + replacement.parent().parent());
        }
        return this.builder.typer().infer(replacement);
    }

    public Node replaceSelf(Node me, Node replacement) {
        return me.parent().replaceChild(me, replacement);
    }
}

