/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.BindingReference;
import mirah.lang.ast.Block;
import mirah.lang.ast.Call;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.Constant;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.LocalAccess;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.Position;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.Script;
import mirah.lang.ast.SimpleString;
import org.mirah.typer.ClosureBuilder$1;
import org.mirah.typer.ClosureBuilder$2;
import org.mirah.typer.ClosureBuilder$3;
import org.mirah.typer.ClosureBuilder$4;
import org.mirah.typer.ClosureBuilderer;
import org.mirah.typer.MethodType;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.Scope;
import org.mirah.typer.Scoper;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.TypeSystem;
import org.mirah.typer.Typer;

public class ClosureBuilder
implements ClosureBuilderer {
    private Scoper scoper;
    private TypeSystem types;
    private static Logger log = Logger.getLogger(ClosureBuilder.class.getName());
    private Typer typer;

    @Override
    public void finish() {
    }

    @Override
    public void add_todo(Block block, ResolvedType parent_type) {
        boolean $or$1;
        Scope new_scope = this.typer.addNestedScope(block);
        this.typer.logger().fine("block is closure with scope " + new_scope);
        if (block.arguments() != null) {
            this.typer.infer(block.arguments());
        }
        if (!(($or$1 = parent_type.isError()) ? $or$1 : block.parent() == null)) {
            this.insert_closure(block, parent_type);
        }
    }

    public ClosureBuilder(Typer typer) {
        this.typer = typer;
        this.types = typer.type_system();
        this.scoper = typer.scoper();
    }

    @Override
    public TypeFuture insert_closure(Block block, ResolvedType parent_type) {
        Node new_node = this.prepare_regular_closure(block, parent_type);
        CallSite parent = (CallSite)block.parent();
        this.replace_block_with_closure_in_call(parent, block, new_node);
        return this.infer(new_node);
    }

    public Call prepare(Block block, ResolvedType parent_type) {
        return (Call)this.prepare_regular_closure(block, parent_type);
    }

    public Node prepare_regular_closure(Block block, ResolvedType parent_type) {
        Scope parent_scope = this.get_scope(block);
        ClosureDefinition klass = this.build_closure_class(block, parent_type, parent_scope);
        if (this.contains_methods(block)) {
            this.copy_methods(klass, block, parent_scope);
        } else {
            this.build_method(klass, block, parent_type, parent_scope);
        }
        return this.new_closure_call_node(block, klass);
    }

    public void replace_block_with_closure_in_call(CallSite parent, Block block, Node new_node) {
        if (block == parent.block()) {
            parent.block_set(null);
            parent.parameters().add(new_node);
        } else {
            new_node.setParent(null);
            parent.replaceChild(block, new_node);
        }
    }

    public NodeList find_enclosing_body(Block block) {
        Node enclosing_node = this.find_enclosing_node(block);
        return this.get_body(enclosing_node);
    }

    public NodeList get_body(Node node) {
        return node instanceof MethodDefinition ? ((MethodDefinition)node).body() : ((Script)node).body();
    }

    public Node find_enclosing_node(Node block) {
        ClosureBuilder$1 closureBuilder$1 = new ClosureBuilder$1();
        return block.findAncestor(new ClosureBuilder$2(closureBuilder$1));
    }

    public String temp_name_from_outer_scope(Node block, String scoped_name) {
        String string;
        ClosureBuilder$3 closureBuilder$3 = new ClosureBuilder$3();
        Node class_or_script = block.findAncestor(new ClosureBuilder$4(closureBuilder$3));
        if (class_or_script instanceof ClassDefinition) {
            string = ((ClassDefinition)class_or_script).name().identifier();
        } else {
            String $or$4 = class_or_script.position().source().name();
            String source_name = $or$4 != null ? $or$4 : "DashE";
            String id = "";
            int gensym1 = 0;
            String[] gensym0 = new File(source_name).getName().replace(".duby|.mirah", "").split("[_-]");
            if (gensym1 < gensym0.length) {
                do {
                    String word = gensym0[gensym1];
                    id = id + word.substring(0, 1).toUpperCase() + word.substring(1);
                } while (++gensym1 < gensym0.length);
            }
            string = id;
        }
        String outer_name = string;
        return this.get_scope(class_or_script).temp(outer_name + "$" + scoped_name);
    }

    public ClosureDefinition build_closure_class(Block block, ResolvedType parent_type, Scope parent_scope) {
        ClosureDefinition klass = this.build_class(block.position(), parent_type, this.temp_name_from_outer_scope(block, "Closure"));
        NodeList enclosing_body = this.find_enclosing_body(block);
        Scope $ptemp$5 = parent_scope;
        ResolvedType $or$6 = $ptemp$5.binding_type();
        if ($or$6 == null) {
            String name = this.temp_name_from_outer_scope(klass, "Binding");
            log.fine("building binding " + name);
            ClosureDefinition binding_klass = this.build_class(klass.position(), null, name);
            this.insert_into_body(enclosing_body, binding_klass);
            $ptemp$5.binding_type_set(this.infer(binding_klass).resolve());
        }
        Constant binding_type_name = this.makeTypeName(klass.position(), parent_scope.binding_type());
        this.build_constructor(enclosing_body, klass, binding_type_name);
        this.insert_into_body(enclosing_body, klass);
        return klass;
    }

    public Scope get_scope(Node block) {
        return this.scoper.getScope(block);
    }

    public Call new_closure_call_node(Block block, Node klass) {
        TypeFuture closure_type = this.infer(klass);
        Constant target = this.makeTypeName(block.position(), closure_type.resolve());
        Position position = block.position();
        SimpleString simpleString = new SimpleString("new");
        ArrayList<BindingReference> arrayList = new ArrayList<BindingReference>(1);
        arrayList.add(new BindingReference());
        return new Call(position, target, simpleString, arrayList, null);
    }

    public ClosureDefinition build_class(Position position, ResolvedType parent_type, String name) {
        List list;
        if (parent_type != null ? parent_type.isInterface() : false) {
            log.fine("making anon class w/ interface type " + parent_type);
            ArrayList arrayList = new ArrayList(1);
            list = arrayList;
            arrayList.add(this.makeTypeName(position, parent_type));
        } else {
            list = Collections.emptyList();
        }
        List interfaces = list;
        boolean $or$7 = parent_type == null;
        Constant superclass = ($or$7 ? $or$7 : parent_type.isInterface()) ? null : this.makeTypeName(position, parent_type);
        Constant constant = null;
        if (name != null) {
            constant = new Constant(position, new SimpleString(position, name));
        }
        return new ClosureDefinition(position, constant, superclass, Collections.emptyList(), interfaces, null);
    }

    public Constant makeTypeName(Position position, ResolvedType type) {
        return new Constant(position, new SimpleString(position, type.name()));
    }

    public Constant makeTypeName(Position position, ClassDefinition type) {
        return new Constant(position, new SimpleString(position, type.name().identifier()));
    }

    public void copy_methods(ClassDefinition klass, Block block, Scope parent_scope) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                MethodDefinition cloned = (MethodDefinition)node.clone();
                this.set_parent_scope(cloned, parent_scope);
                klass.body().add(cloned);
            } while (++i < gensym0);
        }
    }

    public boolean contains_methods(Block block) {
        int i = 0;
        int gensym0 = block.body_size();
        if (i < gensym0) {
            do {
                Node node;
                if (!((node = block.body(i)) instanceof MethodDefinition)) continue;
                return true;
            } while (++i < gensym0);
        }
        return false;
    }

    public void build_method(ClassDefinition klass, Block block, ResolvedType iface, Scope parent_scope) {
        List methods = this.types.getAbstractMethods(iface);
        if (methods.size() == 0) {
            log.warning("No abstract methods in " + iface);
            return;
        }
        if (methods.size() > 1) {
            throw new UnsupportedOperationException("Multiple abstract methods in " + iface + ": " + methods);
        }
        for (Object _m : methods) {
            Arguments args;
            MethodType mtype = (MethodType)_m;
            SimpleString name = new SimpleString(block.position(), mtype.name());
            Arguments arguments = args = block.arguments() != null ? (Arguments)block.arguments().clone() : new Arguments(block.position(), Collections.emptyList(), Collections.emptyList(), null, Collections.emptyList(), null);
            while (args.required().size() < mtype.parameterTypes().size()) {
                RequiredArgument arg = new RequiredArgument(block.position(), new SimpleString("arg" + args.required().size()), null);
                args.required().add(arg);
            }
            Constant return_type = this.makeTypeName(block.position(), mtype.returnType());
            MethodDefinition method = new MethodDefinition(block.position(), name, args, return_type, null, null);
            method.body_set((NodeList)block.body().clone());
            this.set_parent_scope(method, parent_scope);
            klass.body().add(method);
        }
    }

    public void build_constructor(NodeList enclosing_body, ClassDefinition klass, Constant binding_type_name) {
        Position position = klass.position();
        ArrayList<RequiredArgument> arrayList = new ArrayList<RequiredArgument>(1);
        arrayList.add(new RequiredArgument(new SimpleString("binding"), binding_type_name));
        Arguments args = new Arguments(position, arrayList, Collections.emptyList(), null, Collections.emptyList(), null);
        FieldAssign body = new FieldAssign(new SimpleString("binding"), new LocalAccess(new SimpleString("binding")), null);
        SimpleString simpleString = new SimpleString("initialize");
        SimpleString simpleString2 = new SimpleString("void");
        ArrayList<FieldAssign> arrayList2 = new ArrayList<FieldAssign>(1);
        arrayList2.add(body);
        ConstructorDefinition constructor = new ConstructorDefinition(simpleString, args, simpleString2, arrayList2, null);
        klass.body().add(constructor);
    }

    public NodeList insert_into_body(NodeList enclosing_body, ClassDefinition klass) {
        NodeList nodeList = enclosing_body;
        nodeList.insert(0, klass);
        return nodeList;
    }

    public TypeFuture infer(Node node) {
        return this.typer.infer(node);
    }

    public Scope set_parent_scope(MethodDefinition method, Scope parent_scope) {
        Scope scope = this.scoper.addScope(method);
        scope.parent_set(parent_scope);
        return scope;
    }
}

