/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.typer.simple;

import java.io.PrintStream;
import java.io.PrintWriter;
import mirah.lang.ast.Arguments;
import mirah.lang.ast.ClassDefinition;
import mirah.lang.ast.ClosureDefinition;
import mirah.lang.ast.ConstructorDefinition;
import mirah.lang.ast.FieldAccess;
import mirah.lang.ast.FieldAssign;
import mirah.lang.ast.MethodDefinition;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeScanner;
import mirah.lang.ast.RequiredArgument;
import mirah.lang.ast.RequiredArgumentList;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.Unquote;
import org.mirah.typer.TypeFuture;
import org.mirah.typer.Typer;
import org.mirah.typer.simple.PrintStreamAdapter;

public class TypePrinter2
extends NodeScanner {
    private int indent = 0;
    private Object[] args;
    private int lineLength;
    private Typer typer;
    private PrintWriter out;

    public TypePrinter2(Typer typer) {
        this(typer, System.out);
    }

    public TypePrinter2(Typer typer, PrintWriter writer) {
        this.typer = typer;
        this.args = new Object[1];
        this.args[0] = "";
        this.out = writer;
        this.lineLength = 0;
    }

    public TypePrinter2(Typer typer, PrintStream writer) {
        this(typer, new PrintWriter(new PrintStreamAdapter(writer)));
    }

    public void printIndent() {
        block0: {
            this.lineLength += this.indent;
            if (this.indent <= 0) break block0;
            this.out.printf("%" + this.indent + "s", this.args);
        }
    }

    @Override
    public Object exitClassDefinition(ClassDefinition node, Object arg) {
        this.out.print("\n");
        this.indent -= 2;
        this.printIndent();
        PrintWriter printWriter = this.out;
        printWriter.print("end\n");
        return printWriter;
    }

    @Override
    public boolean enterClassDefinition(ClassDefinition node, Object arg) {
        this.printClass(node);
        return false;
    }

    @Override
    public boolean enterClosureDefinition(ClosureDefinition node, Object arg) {
        this.printClass(node);
        return false;
    }

    @Override
    public boolean enterConstructorDefinition(ConstructorDefinition node, Object arg) {
        return this.enterMethodDefinition(node, arg);
    }

    @Override
    public boolean enterMethodDefinition(MethodDefinition node, Object arg) {
        TypeFuture type = this.typer.getInferredType(node);
        this.printIndent();
        this.out.print("$TODOAnnotations\n");
        this.printIndent();
        this.out.print("def ");
        this.out.print("(self.)");
        this.out.print(node.name().identifier());
        node.arguments().accept(this, arg);
        type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print("# " + type.resolve());
        }
        this.indent += 2;
        node.body().accept(this, arg);
        this.indent -= 2;
        this.printIndent();
        this.out.print("end\n");
        return false;
    }

    @Override
    public boolean enterRequiredArgumentList(RequiredArgumentList node, Object arg) {
        return true;
    }

    @Override
    public boolean enterRequiredArgument(RequiredArgument node, Object arg) {
        block1: {
            TypeFuture type;
            this.printIndent();
            this.out.print(node.name().identifier());
            if (node.type() != null) {
                this.out.print(": " + node.type().typeref());
            }
            if ((type = this.typer.getInferredType(node)) == null) break block1;
            this.out.print("# " + type.resolve() + "\n");
        }
        return false;
    }

    @Override
    public boolean enterArguments(Arguments node, Object arg) {
        this.out.print("(\n");
        this.indent += 2;
        return true;
    }

    @Override
    public Object exitArguments(Arguments node, Object arg) {
        this.printIndent();
        this.out.print(")");
        this.indent += 2;
        return null;
    }

    @Override
    public boolean enterFieldAccess(FieldAccess node, Object arg) {
        this.out.print("@" + node.name().identifier());
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print("# " + type.resolve());
        }
        this.out.println();
        return false;
    }

    @Override
    public boolean enterFieldAssign(FieldAssign node, Object arg) {
        this.out.print("@" + node.name().identifier() + " =");
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print("# " + type.resolve());
        }
        this.out.println();
        node.value().accept(this, arg);
        return false;
    }

    public Object printClass(ClassDefinition node) {
        this.printIndent();
        this.out.print("$TODO Annotations\n");
        this.printIndent();
        this.out.print("class " + node.name().identifier());
        if (node.superclass() != null) {
            this.out.print("< " + node.superclass().typeref().name());
        }
        this.out.print("\n");
        this.indent += 2;
        if (node.interfaces().size() > 0) {
            for (TypeName iface : node.interfaces()) {
                this.printIndent();
                this.out.print("implements " + iface.typeref().name() + "\n");
            }
        }
        return this.scan(node.body());
    }

    @Override
    public boolean enterDefault(Node node, Object arg) {
        this.printIndent();
        this.out.print(node);
        TypeFuture type = this.typer.getInferredType(node);
        if (type != null) {
            this.out.print("# " + type.resolve());
        }
        this.out.println();
        this.indent += 2;
        return true;
    }

    @Override
    public boolean enterUnquote(Unquote node, Object arg) {
        super.enterUnquote(node, arg);
        if (node.object() != null) {
            if (node.object() instanceof Node) {
                ((Node)node.object()).accept(this, arg);
            } else {
                this.printIndent();
                this.out.print(node.object());
                this.out.println();
            }
        }
        return node.object() == null;
    }

    @Override
    public Object exitDefault(Node node, Object arg) {
        this.indent -= 2;
        return null;
    }
}

