/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mirah.util.CommandLineOption;
import org.mirah.util.OptionCallback;

public class OptionParser {
    private Map flagMap;
    private String usage;
    private ArrayList options;

    public OptionParser(String usage) {
        this.usage = usage;
        this.options = new ArrayList();
        this.flagMap = new HashMap(16);
    }

    public void addFlag(List names, String help, Runnable cb) {
        this.add(new CommandLineOption(names, help, cb));
    }

    public void addFlag(List names, String placeholder, String help, OptionCallback cb) {
        this.add(new CommandLineOption(names, placeholder, help, cb));
    }

    public void add(CommandLineOption flag) {
        this.options.add(flag);
        for (Object n : flag.names()) {
            this.flagMap.put(n, flag);
        }
    }

    public List parse(String[] options) {
        boolean options_finished = false;
        ArrayList<String> filenames = new ArrayList<String>();
        OptionCallback value_parser = null;
        int gensym1 = 0;
        String[] gensym0 = options;
        if (gensym1 < gensym0.length) {
            do {
                String arg = gensym0[gensym1];
                if (options_finished) {
                    filenames.add(arg);
                    continue;
                }
                if (value_parser != null) {
                    value_parser.run(arg);
                    value_parser = null;
                    continue;
                }
                if ("--".equals(arg)) {
                    options_finished = true;
                    continue;
                }
                if (arg.startsWith("--")) {
                    value_parser = this.parseOption(arg.substring(2), "--");
                    continue;
                }
                if (arg.startsWith("-")) {
                    value_parser = this.parseOption(arg.substring(1), "-");
                    continue;
                }
                filenames.add(arg);
            } while (++gensym1 < gensym0.length);
        }
        return filenames;
    }

    public OptionCallback parseOption(String arg, String dashes) {
        OptionCallback optionCallback;
        CommandLineOption option = (CommandLineOption)this.flagMap.get(arg);
        if (option == null) {
            throw new IllegalArgumentException("Unrecognized flag: " + dashes + arg);
        }
        if (option.option_callback() != null) {
            optionCallback = option.option_callback();
        } else {
            option.callback().run();
            optionCallback = null;
        }
        return optionCallback;
    }

    public Object printUsage() {
        System.out.println(this.usage);
        for (CommandLineOption flag : this.options) {
            boolean first_name = true;
            for (String n : flag.names()) {
                if (!first_name) {
                    System.out.print(", ");
                }
                first_name = false;
                if (n.length() == 1) {
                    System.out.print("-" + n);
                } else {
                    System.out.print("--" + n);
                }
                if (flag.placeholder() == null) continue;
                System.out.print(" ");
                System.out.print(flag.placeholder());
            }
            System.out.println("");
            System.out.print("\t");
            System.out.println(flag.help());
        }
        return null;
    }
}

