/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.CodeSource;
import org.mirah.util.TooManyErrorsException;

public class SimpleDiagnostics
implements DiagnosticListener {
    private Pattern newline = Pattern.compile("\\r?\\n");
    private int errors = 0;
    private HashMap prefixes = new HashMap();
    private int max_errors;

    public SimpleDiagnostics(boolean color) {
        if (color) {
            this.prefixes.put(Diagnostic.Kind.ERROR, "\u001b[1m\u001b[31mERROR\u001b[0m: ");
            this.prefixes.put(Diagnostic.Kind.MANDATORY_WARNING, "\u001b[1m\u001b[33mWARNING\u001b[0m: ");
            this.prefixes.put(Diagnostic.Kind.WARNING, "\u001b[1m\u001b[33mWARNING\u001b[0m: ");
            this.prefixes.put(Diagnostic.Kind.NOTE, "");
            this.prefixes.put(Diagnostic.Kind.OTHER, "");
        } else {
            this.prefixes.put(Diagnostic.Kind.ERROR, "ERROR: ");
            this.prefixes.put(Diagnostic.Kind.MANDATORY_WARNING, "WARNING: ");
            this.prefixes.put(Diagnostic.Kind.WARNING, "WARNING: ");
            this.prefixes.put(Diagnostic.Kind.NOTE, "");
            this.prefixes.put(Diagnostic.Kind.OTHER, "");
        }
        this.max_errors = 20;
    }

    public void setMaxErrors(int count) {
        this.max_errors = count;
    }

    public int errorCount() {
        return this.errors;
    }

    public void log(Diagnostic.Kind kind, String position, String message) {
        if (position != null) {
            System.err.println(position);
        }
        System.err.print(this.prefixes.get((Object)kind));
        System.err.println(message);
    }

    /*
     * WARNING - void declaration
     */
    public void report(Diagnostic diagnostic) {
        String string;
        CodeSource source;
        void diagnostic2;
        Object var2_2 = null;
        if (Diagnostic.Kind.ERROR == diagnostic2.getKind()) {
            ++this.errors;
        }
        if (diagnostic2.getSource() instanceof CodeSource) {
            source = (CodeSource)diagnostic2.getSource();
        }
        if (source != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = source.name();
            objectArray[1] = new Long(diagnostic2.getLineNumber());
            string = String.format("%s:%d:%n", objectArray);
        } else {
            string = null;
        }
        String position = string;
        String message = diagnostic2.getMessage(Locale.getDefault());
        if (source != null) {
            String[] lines;
            long start_col;
            StringBuffer buffer = new StringBuffer(message);
            String newline = String.format("%n", new Object[0]);
            buffer.append(newline);
            int target_line = Math.max(0, (int)(diagnostic2.getLineNumber() - (long)source.initialLine()));
            long l = start_col = target_line == 0 ? diagnostic2.getColumnNumber() - (long)source.initialColumn() : diagnostic2.getColumnNumber() - (long)1;
            if (start_col < (long)0) {
                start_col = 0;
            }
            if (target_line < (lines = this.newline.split(source.contents())).length) {
                String line = lines[target_line];
                buffer.append(line);
                buffer.append(newline);
                char[] space = new char[(int)start_col];
                Arrays.fill(space, (char)32);
                buffer.append(space);
                long length = Math.min(diagnostic2.getEndPosition() - diagnostic2.getStartPosition(), (long)line.length() - start_col);
                char[] underline = new char[(int)Math.max(length, (long)1)];
                Arrays.fill(underline, (char)94);
                buffer.append(underline);
                message = buffer.toString();
            }
        }
        this.log(diagnostic2.getKind(), position, message);
        boolean bl = this.errors > this.max_errors ? this.max_errors > 0 : false;
        if (bl) {
            throw new TooManyErrorsException();
        }
    }
}

