/*
 * Decompiled with CFR 0.152.
 */
package mirah.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Logger;
import mirah.impl.Tokens;
import org.mirah.mmeta.BaseParser;
import org.mirah.mmeta.SyntaxError;

public class MirahLexer {
    private static final Logger logger = Logger.getLogger(MirahLexer.class.getName());
    private static final int EOF = -1;
    private Input input;
    private BaseParser parser;
    private State state;
    private ArrayList<BaseParser.Token<Tokens>> tokens = new ArrayList();
    private EnumSet<Tokens> beginTokens;
    private EnumSet<Tokens> argTokens;
    private EnumSet<Tokens> endTokens;
    private boolean spaceSeen = false;
    private boolean isBEG = true;
    private boolean isARG = false;
    private boolean isEND = false;

    public MirahLexer(String string, char[] chars, BaseParser parser) {
        this(new StringInput(string, chars));
        this.parser = parser;
    }

    public MirahLexer(Input input) {
        this.input = input;
        this.pushState(new StandardLexer());
        this.argTokens = EnumSet.of(Tokens.tSuper, Tokens.tYield, Tokens.tIDENTIFIER, Tokens.tCONSTANT, Tokens.tFID);
        this.beginTokens = EnumSet.range(Tokens.tBang, Tokens.tOpAssign);
        this.beginTokens.addAll(EnumSet.of(Tokens.tElse, new Tokens[]{Tokens.tCase, Tokens.tEnsure, Tokens.tElsif, Tokens.tNot, Tokens.tThen, Tokens.tFor, Tokens.tReturn, Tokens.tIf, Tokens.tIn, Tokens.tDo, Tokens.tUntil, Tokens.tUnless, Tokens.tOr, Tokens.tWhen, Tokens.tAnd, Tokens.tBegin, Tokens.tWhile, Tokens.tNL, Tokens.tSemi, Tokens.tColon, Tokens.tSlash, Tokens.tLBrace, Tokens.tLBrack, Tokens.tLParen, Tokens.tDots}));
        this.beginTokens.addAll(EnumSet.range(Tokens.tComma, Tokens.tRocket));
        this.endTokens = EnumSet.of(Tokens.tDot, new Tokens[]{Tokens.tCharacter, Tokens.tSQuote, Tokens.tDQuote, Tokens.tRParen, Tokens.tRBrace, Tokens.tRBrack, Tokens.tRegexEnd, Tokens.tInteger, Tokens.tFloat, Tokens.tInstVar, Tokens.tClassVar, Tokens.tEnd, Tokens.tSelf, Tokens.tFalse, Tokens.tTrue, Tokens.tRetry, Tokens.tBreak, Tokens.tNil, Tokens.tNext, Tokens.tRedo, Tokens.tClass, Tokens.tDef});
    }

    private boolean isBEG() {
        return this.isBEG;
    }

    private boolean isARG() {
        return this.isARG;
    }

    private boolean isEND() {
        return this.isEND;
    }

    private void pushState(Lexer lexer) {
        this.state = new State(this.state, lexer);
    }

    private void pushForOneToken(Lexer lexer) {
        this.state = new State(this.state, lexer, true);
    }

    private void popState() {
        if (this.state.previous != null) {
            this.state = this.state.previous;
        }
    }

    public Tokens simpleLex() {
        boolean shouldPop = this.state.justOnce;
        Tokens type = this.state.lexer.skipWhitespace(this, this.input);
        if (type != null) {
            this.spaceSeen = true;
            return type;
        }
        type = this.state.lexer.lex(this, this.input);
        if (shouldPop) {
            this.popState();
        }
        this.spaceSeen = false;
        this.isBEG = this.beginTokens.contains((Object)type);
        this.isARG = this.argTokens.contains((Object)type);
        this.isEND = this.endTokens.contains((Object)type);
        return type;
    }

    public BaseParser.Token<Tokens> lex(int pos) {
        return this.lex(pos, true, true);
    }

    public BaseParser.Token<Tokens> lex(int pos, boolean skipWhitespaceAndAllComments) {
        return this.lex(pos, skipWhitespaceAndAllComments, skipWhitespaceAndAllComments);
    }

    public BaseParser.Token<Tokens> lex(int pos, boolean skipWhitespaceAndComments, boolean skipJavaDocs) {
        int start;
        Tokens type;
        if (pos < this.input.pos()) {
            ListIterator<BaseParser.Token<Tokens>> it = this.tokens.listIterator(this.tokens.size());
            while (it.hasPrevious()) {
                BaseParser.Token<Tokens> savedToken = it.previous();
                if (pos < savedToken.pos || pos > savedToken.startpos) continue;
                logger.fine("Warning, uncached token " + savedToken.type + " at " + pos);
                this.parser._pos = savedToken.endpos;
                return savedToken;
            }
            throw new IllegalArgumentException("" + pos + " < " + this.input.pos());
        }
        if (!this.input.hasNext()) {
            return this.parser.build_token(this.state.hereDocs.isEmpty() ? Tokens.tEOF : Tokens.tHereDocBegin, pos, pos);
        }
        do {
            start = this.input.pos();
            type = this.simpleLex();
        } while (skipWhitespaceAndComments && (type == Tokens.tWhitespace || type == Tokens.tComment) || skipJavaDocs && type == Tokens.tJavaDoc);
        this.parser._pos = this.input.pos();
        BaseParser.Token<Tokens> token = this.parser.build_token(type, pos, start);
        this.tokens.add(token);
        return token;
    }

    void noteNewline() {
        if (this.parser != null) {
            this.parser.note_newline(this.input.pos());
        }
    }

    public Tokens unterminatedComment() {
        if (this.parser == null) {
            return Tokens.tPartialComment;
        }
        throw new SyntaxError("terminated comment", "*/", this.parser._pos, this.parser._string, this.parser._list);
    }

    public Object getState() {
        if (this.state.previous == null && this.state.hereDocs.isEmpty() && this.state.braceDepth < 32) {
            int compressed = 0;
            if (this.isBEG) {
                compressed = 1;
            } else if (this.isEND) {
                compressed = 2;
            } else if (this.isARG) {
                compressed = this.spaceSeen ? 4 : 3;
            }
            return compressed |= this.state.braceDepth << 3;
        }
        return new CombinedState(this);
    }

    public void restore(Object state) {
        if (state instanceof CombinedState) {
            CombinedState cs = (CombinedState)state;
            this.state = cs.state;
            this.spaceSeen = cs.spaceSeen;
            this.isBEG = cs.isBEG;
            this.isARG = cs.isARG;
            this.isEND = cs.isEND;
        } else {
            int compressed = (Integer)state;
            this.state = new State(null, new StandardLexer());
            this.state.braceDepth = compressed >> 3 & 0x1F;
            this.spaceSeen = false;
            this.isEND = false;
            this.isARG = false;
            this.isBEG = false;
            switch (compressed & 7) {
                case 1: {
                    this.isBEG = true;
                    break;
                }
                case 2: {
                    this.isEND = true;
                    break;
                }
                case 4: {
                    this.spaceSeen = true;
                }
                case 3: {
                    this.isARG = true;
                }
            }
        }
    }

    private static class StandardLexer
    implements Lexer {
        private StandardLexer() {
        }

        @Override
        public Tokens lex(MirahLexer l, Input i) {
            Tokens type = this.processFirstChar(l, i);
            type = this.checkKeyword(type, i);
            return this.readRestOfToken(type, l, i);
        }

        @Override
        public Tokens skipWhitespace(MirahLexer l, Input i) {
            boolean found_whitespace = false;
            int c = i.read();
            block6: while (c != -1) {
                switch (c) {
                    case 9: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 32: {
                        found_whitespace = true;
                        break;
                    }
                    case 92: {
                        if (!i.consume('\n')) break block6;
                        l.noteNewline();
                        found_whitespace = true;
                        break;
                    }
                    case 35: {
                        if (found_whitespace) break block6;
                        i.consumeLine();
                        return Tokens.tComment;
                    }
                    case 47: {
                        if (!i.consume('*')) break block6;
                        return this.readBlockComment(l, i);
                    }
                    default: {
                        break block6;
                    }
                }
                c = i.read();
            }
            i.backup(1);
            if (found_whitespace) {
                return Tokens.tWhitespace;
            }
            return null;
        }

        private Tokens readBlockComment(MirahLexer l, Input i) {
            boolean javadoc = i.peek() == 42;
            int c = i.read();
            while (c != -1) {
                switch (c) {
                    case 10: {
                        l.noteNewline();
                        break;
                    }
                    case 42: {
                        if (!i.consume('/')) break;
                        return javadoc ? Tokens.tJavaDoc : Tokens.tComment;
                    }
                    case 47: {
                        if (!i.consume('*')) break;
                        this.readBlockComment(l, i);
                    }
                }
                c = i.read();
            }
            return l.unterminatedComment();
        }

        private Tokens processFirstChar(MirahLexer l, Input i) {
            Tokens type = null;
            int c0 = i.read();
            switch (c0) {
                case -1: {
                    if (((MirahLexer)l).state.hereDocs.isEmpty()) {
                        type = Tokens.tEOF;
                        break;
                    }
                    type = Tokens.tHereDocBegin;
                    break;
                }
                case 36: {
                    type = Tokens.tDollar;
                    break;
                }
                case 64: {
                    if (i.consume("@`")) {
                        type = Tokens.tClassVarBacktick;
                        break;
                    }
                    if (i.consume('@') && i.hasNext()) {
                        type = Tokens.tClassVar;
                        break;
                    }
                    if (i.consume('`')) {
                        type = Tokens.tInstVarBacktick;
                        break;
                    }
                    if (!i.hasNext()) break;
                    type = Tokens.tInstVar;
                    break;
                }
                case 95: {
                    if (i.consume("_ENCODING__")) {
                        type = Tokens.t__ENCODING__;
                        break;
                    }
                    if (i.consume("_FILE__")) {
                        type = Tokens.t__FILE__;
                        break;
                    }
                    if (i.consume("_LINE__")) {
                        type = Tokens.t__LINE__;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 66: {
                    if (i.consume("EGIN")) {
                        type = Tokens.tBEGIN;
                        break;
                    }
                    type = Tokens.tCONSTANT;
                    break;
                }
                case 69: {
                    if (i.consume("ND")) {
                        type = Tokens.tEND;
                        break;
                    }
                    type = Tokens.tCONSTANT;
                    break;
                }
                case 97: {
                    if (i.consume("lias")) {
                        type = Tokens.tAlias;
                        break;
                    }
                    if (i.consume("nd")) {
                        type = Tokens.tAnd;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 98: {
                    if (i.consume("egin")) {
                        type = Tokens.tBegin;
                        break;
                    }
                    if (i.consume("reak")) {
                        type = Tokens.tBreak;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 99: {
                    if (i.consume("ase")) {
                        type = Tokens.tCase;
                        break;
                    }
                    if (i.consume("lass")) {
                        type = Tokens.tClass;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 100: {
                    if (i.consume("efined")) {
                        type = Tokens.tDefined;
                        break;
                    }
                    if (i.consume("efmacro")) {
                        type = Tokens.tDefmacro;
                        break;
                    }
                    if (i.consume("ef")) {
                        type = Tokens.tDef;
                        break;
                    }
                    if (i.consume("o")) {
                        type = Tokens.tDo;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 101: {
                    if (i.consume("lse")) {
                        type = Tokens.tElse;
                        break;
                    }
                    if (i.consume("lsif")) {
                        type = Tokens.tElsif;
                        break;
                    }
                    if (i.consume("nd")) {
                        type = Tokens.tEnd;
                        break;
                    }
                    if (i.consume("nsure")) {
                        type = Tokens.tEnsure;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 102: {
                    if (i.consume("alse")) {
                        type = Tokens.tFalse;
                        break;
                    }
                    if (i.consume("or")) {
                        type = Tokens.tFor;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 105: {
                    if (i.consume("f")) {
                        type = Tokens.tIf;
                        break;
                    }
                    if (i.consume("mplements")) {
                        type = Tokens.tImplements;
                        break;
                    }
                    if (i.consume("mport")) {
                        type = Tokens.tImport;
                        break;
                    }
                    if (i.consume("nterface")) {
                        type = Tokens.tInterface;
                        break;
                    }
                    if (i.consume("n")) {
                        type = Tokens.tIn;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 109: {
                    if (i.consume("acro")) {
                        type = Tokens.tMacro;
                        break;
                    }
                    if (i.consume("odule")) {
                        type = Tokens.tModule;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 110: {
                    if (i.consume("ext")) {
                        type = Tokens.tNext;
                        break;
                    }
                    if (i.consume("il")) {
                        type = Tokens.tNil;
                        break;
                    }
                    if (i.consume("ot")) {
                        type = Tokens.tNot;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 111: {
                    if (i.consume("r")) {
                        type = Tokens.tOr;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 112: {
                    if (i.consume("ackage")) {
                        type = Tokens.tPackage;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 114: {
                    if (i.consume("aise")) {
                        type = Tokens.tRaise;
                        break;
                    }
                    if (i.consume("edo")) {
                        type = Tokens.tRedo;
                        break;
                    }
                    if (i.consume("escue")) {
                        type = Tokens.tRescue;
                        break;
                    }
                    if (i.consume("etry")) {
                        type = Tokens.tRetry;
                        break;
                    }
                    if (i.consume("eturn")) {
                        type = Tokens.tReturn;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 115: {
                    if (i.consume("elf")) {
                        type = Tokens.tSelf;
                        break;
                    }
                    if (i.consume("uper")) {
                        type = Tokens.tSuper;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 116: {
                    if (i.consume("hen")) {
                        type = Tokens.tThen;
                        break;
                    }
                    if (i.consume("rue")) {
                        type = Tokens.tTrue;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 117: {
                    if (i.consume("ndef")) {
                        type = Tokens.tUndef;
                        break;
                    }
                    if (i.consume("nless")) {
                        type = Tokens.tUnless;
                        break;
                    }
                    if (i.consume("ntil")) {
                        type = Tokens.tUntil;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 119: {
                    if (i.consume("hen")) {
                        type = Tokens.tWhen;
                        break;
                    }
                    if (i.consume("hile")) {
                        type = Tokens.tWhile;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 121: {
                    if (i.consume("ield")) {
                        type = Tokens.tYield;
                        break;
                    }
                    type = Tokens.tIDENTIFIER;
                    break;
                }
                case 10: {
                    l.noteNewline();
                    if (((MirahLexer)l).state.hereDocs.isEmpty()) {
                        type = Tokens.tNL;
                        break;
                    }
                    type = Tokens.tHereDocBegin;
                    l.pushState(((MirahLexer)l).state.hereDocs.removeFirst());
                    break;
                }
                case 47: {
                    if (l.isBEG()) {
                        l.pushState(new RegexLexer());
                        type = Tokens.tRegexBegin;
                        break;
                    }
                    if (!i.hasNext()) {
                        type = Tokens.tSlash;
                        break;
                    }
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    if (l.isARG() && l.spaceSeen && !Character.isWhitespace(i.peek())) {
                        type = Tokens.tRegexBegin;
                        break;
                    }
                    type = Tokens.tSlash;
                    break;
                }
                case 39: {
                    l.pushState(new SStringLexer());
                    type = Tokens.tSQuote;
                    break;
                }
                case 34: {
                    l.pushState(new DStringLexer());
                    type = Tokens.tDQuote;
                    break;
                }
                case 58: {
                    if (i.consume(':')) {
                        type = Tokens.tColons;
                        break;
                    }
                    type = Tokens.tColon;
                    break;
                }
                case 46: {
                    if (i.consume('.')) {
                        type = Tokens.tDots;
                        break;
                    }
                    type = Tokens.tDot;
                    break;
                }
                case 40: {
                    type = Tokens.tLParen;
                    break;
                }
                case 41: {
                    type = Tokens.tRParen;
                    break;
                }
                case 91: {
                    type = Tokens.tLBrack;
                    break;
                }
                case 93: {
                    type = Tokens.tRBrack;
                    break;
                }
                case 123: {
                    l.state.lbrace();
                    type = Tokens.tLBrace;
                    break;
                }
                case 125: {
                    l.state.rbrace(l);
                    type = Tokens.tRBrace;
                    break;
                }
                case 59: {
                    type = Tokens.tSemi;
                    break;
                }
                case 33: {
                    if (i.consume('=')) {
                        if (i.consume('=')) {
                            type = Tokens.tNEE;
                            break;
                        }
                        type = Tokens.tNE;
                        break;
                    }
                    if (i.consume('~')) {
                        type = Tokens.tNMatch;
                        break;
                    }
                    type = Tokens.tBang;
                    break;
                }
                case 60: {
                    if (i.consume('=')) {
                        if (i.consume('>')) {
                            type = Tokens.tLEG;
                            break;
                        }
                        type = Tokens.tLE;
                        break;
                    }
                    if (i.consume('<')) {
                        if (i.consume('<')) {
                            if (!i.consume('=')) break;
                            type = Tokens.tOpAssign;
                            break;
                        }
                        if (i.consume('=')) {
                            type = Tokens.tOpAssign;
                            break;
                        }
                        type = Tokens.tLShift;
                        break;
                    }
                    type = Tokens.tLT;
                    break;
                }
                case 62: {
                    if (i.consume('=')) {
                        type = Tokens.tGE;
                        break;
                    }
                    if (i.consume('>')) {
                        if (i.consume('=')) {
                            type = Tokens.tOpAssign;
                            break;
                        }
                        if (i.consume('>')) {
                            type = Tokens.tRRShift;
                            break;
                        }
                        type = Tokens.tRShift;
                        break;
                    }
                    type = Tokens.tGT;
                    break;
                }
                case 63: {
                    type = Tokens.tQuestion;
                    break;
                }
                case 61: {
                    if (i.consume('>')) {
                        type = Tokens.tRocket;
                        break;
                    }
                    if (i.consume('~')) {
                        type = Tokens.tMatch;
                        break;
                    }
                    if (i.consume('=')) {
                        if (i.consume('=')) {
                            type = Tokens.tEEEQ;
                            break;
                        }
                        type = Tokens.tEEQ;
                        break;
                    }
                    type = Tokens.tEQ;
                    break;
                }
                case 38: {
                    if (i.consume('&')) {
                        if (i.consume('=')) {
                            type = Tokens.tAndEq;
                            break;
                        }
                        type = Tokens.tAmpers;
                        break;
                    }
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tAmper;
                    break;
                }
                case 124: {
                    if (i.consume('|')) {
                        if (i.consume('=')) {
                            type = Tokens.tOrEq;
                            break;
                        }
                        type = Tokens.tPipes;
                        break;
                    }
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tPipe;
                    break;
                }
                case 42: {
                    if (i.consume('*')) {
                        if (i.consume('=')) {
                            type = Tokens.tOpAssign;
                            break;
                        }
                        type = Tokens.tStars;
                        break;
                    }
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tStar;
                    break;
                }
                case 43: {
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tPlus;
                    break;
                }
                case 45: {
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tMinus;
                    break;
                }
                case 37: {
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tPercent;
                    break;
                }
                case 94: {
                    if (i.consume('=')) {
                        type = Tokens.tOpAssign;
                        break;
                    }
                    type = Tokens.tCaret;
                    break;
                }
                case 126: {
                    type = Tokens.tTilde;
                    break;
                }
                case 96: {
                    type = Tokens.tBacktick;
                    break;
                }
                case 44: {
                    type = Tokens.tComma;
                    break;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    type = Tokens.tDigit;
                    break;
                }
                default: {
                    if (c0 >= 65 && c0 <= 90 || Character.isUpperCase(c0)) {
                        type = Tokens.tCONSTANT;
                        break;
                    }
                    if (c0 >= 55296 && c0 <= 56319) {
                        if (Character.isUpperCase(i.finishCodepoint())) {
                            type = Tokens.tCONSTANT;
                            break;
                        }
                        type = Tokens.tIDENTIFIER;
                        break;
                    }
                    type = c0 >= 97 && c0 <= 122 || c0 > 127 && Character.isLetter(c0) ? Tokens.tIDENTIFIER : Tokens.tUNKNOWN;
                }
            }
            return type;
        }

        private Tokens checkKeyword(Tokens type, Input i) {
            int c1;
            if (Tokens.tClassVar.compareTo(type) > 0 && ((c1 = i.peek()) >= 55296 && c1 <= 57343 || Character.isLetterOrDigit(c1) || c1 == 95)) {
                type = type == Tokens.tBEGIN || type == Tokens.tEND ? Tokens.tCONSTANT : Tokens.tIDENTIFIER;
            }
            return type;
        }

        private Tokens readRestOfToken(Tokens type, MirahLexer l, Input i) {
            switch (type) {
                case tDigit: {
                    return this.readNumber(i);
                }
                case tQuestion: {
                    return this.readCharacter(i);
                }
                case tLShift: {
                    return this.readHereDocIdentifier(l, i);
                }
            }
            if (Tokens.tFID.compareTo(type) >= 0) {
                return this.readName(i, type);
            }
            return type;
        }

        private Tokens readName(Input i, Tokens type) {
            int start = i.pos();
            int c = i.read();
            while (c != -1) {
                if (c <= 127) {
                    if (!(c == 95 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122)) {
                        if (c != 63 && c != 33) break;
                        if (i.consume('=')) {
                            i.backup(1);
                            break;
                        }
                        return Tokens.tFID;
                    }
                } else if ((c < 55296 || c > 57343) && !Character.isLetterOrDigit(c)) break;
                c = i.read();
            }
            i.backup(1);
            if (type == Tokens.tInstVar && i.pos() == start) {
                type = Tokens.tAt;
            }
            return type;
        }

        private void readDigits(Input i, boolean oct, boolean dec, boolean hex) {
            int c = i.read();
            while (c != -1) {
                switch (c) {
                    case 48: 
                    case 49: 
                    case 95: {
                        break;
                    }
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        if (oct) break;
                        i.backup(1);
                        return;
                    }
                    case 56: 
                    case 57: {
                        if (dec) break;
                        i.backup(1);
                        return;
                    }
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: {
                        if (hex) break;
                        i.backup(1);
                        return;
                    }
                    default: {
                        i.backup(1);
                        return;
                    }
                }
                c = i.read();
            }
            i.backup(1);
        }

        private Tokens readNumber(Input i) {
            if (!i.hasNext()) {
                return Tokens.tInteger;
            }
            boolean oct = true;
            boolean dec = true;
            boolean hex = false;
            boolean maybeFloat = true;
            i.backup(1);
            if (i.consume('0')) {
                switch (i.read()) {
                    case 68: 
                    case 100: {
                        maybeFloat = false;
                        break;
                    }
                    case 66: 
                    case 98: {
                        maybeFloat = false;
                        dec = false;
                        oct = false;
                        break;
                    }
                    case 88: 
                    case 120: {
                        hex = true;
                        maybeFloat = false;
                        break;
                    }
                    case 46: 
                    case 69: 
                    case 101: {
                        i.backup(1);
                        break;
                    }
                    case 79: 
                    case 111: {
                        dec = false;
                        break;
                    }
                    default: {
                        i.backup(1);
                        maybeFloat = false;
                        dec = false;
                    }
                }
            }
            this.readDigits(i, oct, dec, hex);
            if (maybeFloat && i.hasNext()) {
                if (i.consume('.')) {
                    if (this.readFraction(i)) {
                        return Tokens.tFloat;
                    }
                    i.backup(1);
                } else if (i.consume('e') || i.consume('E')) {
                    this.readExponent(i);
                    return Tokens.tFloat;
                }
            }
            return Tokens.tInteger;
        }

        private boolean readFraction(Input i) {
            int start = i.pos();
            this.readDigits(i, true, true, false);
            if (start == i.pos()) {
                return false;
            }
            if (i.hasNext() && (i.consume('e') || i.consume('E'))) {
                this.readExponent(i);
                return true;
            }
            return true;
        }

        private void readExponent(Input i) {
            i.consume('-');
            this.readDigits(i, true, true, false);
        }

        private boolean isIdentifierChar(int c) {
            if (c == -1) {
                return false;
            }
            return Character.isLetterOrDigit(c) || c == 95 || c >= 55296 && c <= 56319;
        }

        private Tokens readCharacter(Input i) {
            if (!i.hasNext()) {
                return Tokens.tQuestion;
            }
            int c = i.read();
            if (c == -1 || Character.isWhitespace(c)) {
                i.backup(1);
                return Tokens.tQuestion;
            }
            if ((c == 95 || Character.isLetterOrDigit(c)) && this.isIdentifierChar(i.peek())) {
                i.backup(1);
                return Tokens.tQuestion;
            }
            if (c >= 55296 && c <= 56319) {
                i.skip(1);
                if (this.isIdentifierChar(i.peek())) {
                    i.backup(2);
                    return Tokens.tQuestion;
                }
                return Tokens.tCharacter;
            }
            if (c != 92) {
                return Tokens.tCharacter;
            }
            block3: while (-1 != (c = i.read())) {
                switch (c) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: 
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 69: 
                    case 70: 
                    case 85: 
                    case 97: 
                    case 98: 
                    case 99: 
                    case 100: 
                    case 101: 
                    case 102: 
                    case 117: 
                    case 120: {
                        continue block3;
                    }
                }
            }
            if (c == -1 || Character.isWhitespace(c)) {
                i.backup(1);
            }
            return Tokens.tCharacter;
        }

        private Tokens readHereDocIdentifier(MirahLexer l, Input i) {
            int start = i.pos();
            boolean allowIndented = false;
            if (!i.hasNext() || l.isEND() || l.isARG() && !l.spaceSeen) {
                return Tokens.tLShift;
            }
            if (i.consume('-')) {
                allowIndented = true;
            }
            char quote = '\u0000';
            if (i.consume('\"')) {
                quote = '\"';
            } else if (i.consume('\'')) {
                quote = '\'';
            }
            int id_start = i.pos();
            int c = i.read();
            while (c != -1 && this.isIdentifierChar(c)) {
                c = i.read();
            }
            i.backup(1);
            if (i.pos() == id_start) {
                return Tokens.tLShift;
            }
            CharSequence id = i.readBack(i.pos() - id_start);
            if (quote != '\u0000' && !i.consume(quote)) {
                i.backup(i.pos() - start);
                return Tokens.tLShift;
            }
            ((MirahLexer)l).state.hereDocs.add(new HereDocLexer(id.toString(), allowIndented, quote != '\''));
            return Tokens.tHereDocId;
        }
    }

    private static class HereDocLexer
    extends BaseLexer {
        private final String marker;
        private final boolean allowIndented;
        private final boolean allowStrEv;

        public HereDocLexer(String marker, boolean allowIndented, boolean allowStrEv) {
            this.marker = marker;
            this.allowIndented = allowIndented;
            this.allowStrEv = allowStrEv;
        }

        @Override
        public Tokens lex(MirahLexer l, Input i) {
            if (this.readMarker(i, true)) {
                l.popState();
                return Tokens.tHereDocEnd;
            }
            if (this.allowStrEv && i.consume('#') && (i.consume('{') || i.consume('@'))) {
                return this.readStrEv(l, i);
            }
            int c = i.read();
            while (c != -1) {
                if (c == 10) {
                    if (this.readMarker(i, false)) {
                        return Tokens.tStringContent;
                    }
                } else if (this.allowStrEv && c == 35 && (i.consume('{') || i.consume('@'))) {
                    i.backup(2);
                    return Tokens.tStringContent;
                }
                c = i.read();
            }
            i.backup(1);
            return Tokens.tStringContent;
        }

        private boolean readMarker(Input i, boolean consume) {
            int size = 0;
            int c = i.read();
            if (this.allowIndented) {
                while (" \t\r\f\u000b".indexOf(c) != -1) {
                    ++size;
                    c = i.read();
                }
            }
            i.backup(1);
            if (i.consume(this.marker)) {
                size += this.marker.length();
                if (i.hasNext() && i.peek() != 10) {
                    i.backup(size);
                    return false;
                }
                if (!consume) {
                    i.backup(size);
                }
                return true;
            }
            i.backup(size);
            return false;
        }

        private Tokens readStrEv(MirahLexer l, Input i) {
            i.backup(1);
            if (i.consume('{')) {
                l.pushState(((MirahLexer)l).state.previous.lexer);
                return Tokens.tStrEvBegin;
            }
            if (i.peek() == 64) {
                l.pushForOneToken(((MirahLexer)l).state.previous.lexer);
                return Tokens.tStrEvBegin;
            }
            return Tokens.tUNKNOWN;
        }
    }

    private static class RegexLexer
    extends DStringLexer {
        private RegexLexer() {
        }

        @Override
        public boolean isEndOfString(int c) {
            return c == 47;
        }

        @Override
        public Tokens readEndOfString(Input i) {
            int c = i.read();
            while (c != -1 && Character.isLetter(c)) {
                c = i.read();
            }
            i.backup(1);
            return Tokens.tRegexEnd;
        }
    }

    private static class DStringLexer
    extends BaseLexer {
        private DStringLexer() {
        }

        @Override
        public Tokens lex(MirahLexer l, Input i) {
            int c = i.read();
            if (this.isEndOfString(c)) {
                l.popState();
                return this.readEndOfString(i);
            }
            switch (c) {
                case 92: {
                    this.readEscape(i);
                    return Tokens.tEscape;
                }
                case 35: {
                    int c2 = i.read();
                    if (c2 == 123) {
                        l.pushState(((MirahLexer)l).state.previous.lexer);
                        return Tokens.tStrEvBegin;
                    }
                    if (c2 == 64) {
                        i.backup(1);
                        l.pushForOneToken(((MirahLexer)l).state.previous.lexer);
                        return Tokens.tStrEvBegin;
                    }
                    i.backup(1);
                    break;
                }
                case 10: {
                    l.noteNewline();
                }
            }
            this.readRestOfString(l, i);
            return Tokens.tStringContent;
        }

        public Tokens readEndOfString(Input i) {
            return Tokens.tDQuote;
        }

        public boolean isEndOfString(int c) {
            return c == 34;
        }

        private void readEscape(Input i) {
            int c = i.read();
            switch (c) {
                case 120: {
                    i.skip(2);
                    return;
                }
                case 117: {
                    i.skip(4);
                    return;
                }
                case 85: {
                    i.skip(8);
                    return;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int c1 = i.read();
                    int c2 = i.read();
                    if (c1 >= 48 && c1 <= 55 && c2 >= 48 && c2 <= 55) {
                        return;
                    }
                    i.backup(2);
                }
            }
            if (c >= 55296 && c <= 57343) {
                i.skip(1);
            }
        }

        private void readRestOfString(MirahLexer l, Input i) {
            int c = 0;
            c = i.read();
            while (c != -1) {
                if (this.isEndOfString(c)) {
                    i.backup(1);
                    break;
                }
                if (c == 35) {
                    int c2 = i.read();
                    if (c2 == 123 || c2 == 64) {
                        i.backup(2);
                        break;
                    }
                    i.backup(1);
                } else {
                    if (c == 92) {
                        i.backup(1);
                        break;
                    }
                    if (c == 10) {
                        l.noteNewline();
                    }
                }
                c = i.read();
            }
            if (c == -1) {
                i.backup(1);
            }
        }
    }

    private static class SStringLexer
    extends BaseLexer {
        private SStringLexer() {
        }

        private boolean isEscape(Input i) {
            return i.consume('\'') || i.consume('\\');
        }

        @Override
        public Tokens lex(MirahLexer l, Input i) {
            int c0 = i.read();
            switch (c0) {
                case 39: {
                    l.popState();
                    return Tokens.tSQuote;
                }
                case 92: {
                    if (!this.isEscape(i)) break;
                    return Tokens.tEscape;
                }
                case 10: {
                    l.noteNewline();
                }
            }
            this.readRestOfString(l, i);
            return Tokens.tStringContent;
        }

        private void readRestOfString(MirahLexer l, Input i) {
            int c = 0;
            c = i.read();
            while (c != -1) {
                if (c == 10) {
                    l.noteNewline();
                }
                if (c == 39) {
                    i.backup(1);
                    break;
                }
                if (c == 92 && this.isEscape(i)) {
                    i.backup(2);
                    break;
                }
                c = i.read();
            }
            if (c == -1) {
                i.backup(1);
            }
        }
    }

    private static class CombinedState {
        private final State state;
        private final boolean isBEG;
        private final boolean isARG;
        private final boolean isEND;
        private final boolean spaceSeen;

        public CombinedState(MirahLexer l) {
            this.state = l.state.clone();
            this.isBEG = l.isBEG();
            this.isARG = l.isARG();
            this.isEND = l.isEND();
            this.spaceSeen = l.spaceSeen;
        }
    }

    protected static class State
    implements Cloneable {
        public final Lexer lexer;
        public final State previous;
        public final boolean justOnce;
        public int braceDepth;
        public final LinkedList<Lexer> hereDocs = new LinkedList();

        public State(State previous, Lexer lexer, boolean justOnce) {
            this.previous = previous;
            this.lexer = lexer;
            this.justOnce = justOnce;
        }

        public State(State previous, Lexer lexer) {
            this(previous, lexer, false);
        }

        public void lbrace() {
            ++this.braceDepth;
        }

        public void rbrace(MirahLexer ml) {
            --this.braceDepth;
            if (this.braceDepth == -1) {
                ml.popState();
            }
        }

        public State clone() {
            State clone = new State(this.previous == null ? null : this.previous.clone(), this.lexer, this.justOnce);
            clone.braceDepth = this.braceDepth;
            clone.hereDocs.addAll(this.hereDocs);
            return clone;
        }
    }

    private static abstract class BaseLexer
    implements Lexer {
        private BaseLexer() {
        }

        @Override
        public Tokens skipWhitespace(MirahLexer l, Input i) {
            return null;
        }
    }

    protected static interface Lexer {
        public Tokens skipWhitespace(MirahLexer var1, Input var2);

        public Tokens lex(MirahLexer var1, Input var2);
    }

    public static class StringInput
    implements Input {
        private int pos = 0;
        private final String string;
        private final char[] chars;
        private final int end;

        public StringInput(String string, char[] chars) {
            this.string = string;
            this.chars = chars;
            this.end = chars.length;
        }

        @Override
        public int pos() {
            return this.pos;
        }

        @Override
        public int read() {
            if (this.pos >= this.end) {
                this.pos = this.end + 1;
                return -1;
            }
            return this.chars[this.pos++];
        }

        @Override
        public boolean consume(char c) {
            if (this.read() == c) {
                return true;
            }
            --this.pos;
            return false;
        }

        @Override
        public boolean consume(String s) {
            if (this.string.startsWith(s, this.pos)) {
                this.pos += s.length();
                return true;
            }
            return false;
        }

        @Override
        public void backup(int amount) {
            this.pos -= amount;
        }

        @Override
        public void skip(int amount) {
            this.pos = this.pos < this.end - amount ? (this.pos += amount) : this.end;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.end;
        }

        @Override
        public void consumeLine() {
            this.pos = this.string.indexOf(10, this.pos);
            if (this.pos == -1) {
                this.pos = this.end;
            }
        }

        @Override
        public int peek() {
            int result = this.read();
            --this.pos;
            return result;
        }

        @Override
        public int finishCodepoint() {
            int size = 1;
            if (this.pos < this.end - 1) {
                ++this.pos;
                ++size;
            }
            return this.string.codePointAt(this.pos - size);
        }

        @Override
        public CharSequence readBack(int length) {
            return this.string.substring(this.pos - length, this.pos);
        }
    }

    public static interface Input {
        public int pos();

        public int read();

        public boolean consume(char var1);

        public boolean consume(String var1);

        public void backup(int var1);

        public void skip(int var1);

        public boolean hasNext();

        public void consumeLine();

        public int peek();

        public int finishCodepoint();

        public CharSequence readBack(int var1);
    }
}

