/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.List;
import mirah.lang.ast.Block;
import mirah.lang.ast.CallSite;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Named;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeImpl;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.Position;
import mirah.lang.ast.PositionImpl;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.TypeRefImpl;

public class Call
extends NodeImpl
implements Named,
TypeName,
CallSite {
    private Identifier name;
    private Block block;
    private NodeList parameters;
    private Node target;

    public Call() {
    }

    public Call(Position position) {
        this.position_set(position);
    }

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitCall(this, arg);
    }

    @Override
    public Node target() {
        return this.target;
    }

    public void target_set(Node value) {
        Node clone;
        if (value == this.target) {
            return;
        }
        this.childRemoved(this.target);
        this.target = value = (clone = this.childAdded(value));
    }

    @Override
    public Identifier name() {
        return this.name;
    }

    public void name_set(Identifier value) {
        if (value == this.name) {
            return;
        }
        this.childRemoved(this.name);
        Node clone = this.childAdded(value);
        this.name = value = (Identifier)clone;
    }

    @Override
    public NodeList parameters() {
        return this.parameters;
    }

    public void parameters_set(NodeList value) {
        if (value == this.parameters) {
            return;
        }
        this.childRemoved(this.parameters);
        Node clone = this.childAdded(value);
        this.parameters = value = (NodeList)clone;
    }

    public Node parameters(int i) {
        Node node = this.parameters.get(i);
        return node;
    }

    public int parameters_size() {
        if (this.parameters != null) {
            return this.parameters.size();
        }
        return 0;
    }

    @Override
    public Block block() {
        return this.block;
    }

    @Override
    public void block_set(Block value) {
        if (value == this.block) {
            return;
        }
        this.childRemoved(this.block);
        Node clone = this.childAdded(value);
        this.block = value = (Block)clone;
    }

    public Call(Position position, Node target, Identifier name, List parameters, Block block) {
        this.position_set(position);
        this.target_set(target);
        this.name_set(name);
        this.parameters_set(new NodeList(position, parameters));
        this.block_set(block);
    }

    public Call(Node target, Identifier name, List parameters, Block block) {
        this.target_set(target);
        this.name_set(name);
        this.parameters_set(new NodeList(this.position(), parameters));
        this.block_set(block);
    }

    @Override
    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        Node clone = this.childAdded(newChild);
        if (this.target() == oldChild) {
            this.target_set(clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.name() == oldChild) {
            this.name_set((Identifier)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        if (this.block() == oldChild) {
            this.block_set((Block)clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        throw new IllegalArgumentException("No child " + oldChild);
    }

    @Override
    public void removeChild(Node child) {
        if (this.target() == child) {
            this.target_set(null);
            return;
        }
        if (this.name() == child) {
            this.name_set(null);
            return;
        }
        if (this.block() == child) {
            this.block_set(null);
            return;
        }
        throw new IllegalArgumentException("No child " + child);
    }

    @Override
    public void initCopy() {
        block3: {
            super.initCopy();
            if (this.target() != null) {
                this.target = this.childAdded((Node)this.target().clone());
            }
            if (this.name() != null) {
                this.name = (Identifier)this.childAdded((Node)this.name().clone());
            }
            if (this.parameters() != null) {
                this.parameters = (NodeList)this.childAdded((Node)this.parameters().clone());
            }
            if (this.block() == null) break block3;
            this.block = (Block)this.childAdded((Node)this.block().clone());
        }
    }

    public TypeRef typeref(boolean maybeCast) {
        if (this.parameters().size() > 1) {
            return null;
        }
        boolean bl = this.parameters().size() == 1 ? !maybeCast : false;
        if (bl) {
            return null;
        }
        if (!(this.target() instanceof TypeName)) {
            return null;
        }
        TypeRef target_typeref = ((TypeName)this.target()).typeref();
        if (target_typeref == null) {
            return null;
        }
        Position position = PositionImpl.add(this.name().position(), target_typeref.position());
        if ("[]".equals(this.name().identifier())) {
            return new TypeRefImpl(target_typeref.name(), true, false, position);
        }
        String name = target_typeref.name() + "." + this.name().identifier();
        return new TypeRefImpl(name, false, false, position);
    }
}

