/*
 * Decompiled with CFR 0.152.
 */
package mirah.lang.ast;

import java.util.LinkedList;
import mirah.lang.ast.CloneListener;
import mirah.lang.ast.Named;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeFilter;
import mirah.lang.ast.NodeVisitor;
import mirah.lang.ast.Position;
import org.mirah.macros.anno.Extensions;

@Extensions(macros={"mirah.lang.ast.NodeImpl$Extension1", "mirah.lang.ast.NodeImpl$Extension2", "mirah.lang.ast.NodeImpl$Extension3", "mirah.lang.ast.NodeImpl$Extension4", "mirah.lang.ast.NodeImpl$Extension5", "mirah.lang.ast.NodeImpl$Extension6", "mirah.lang.ast.NodeImpl$Extension7", "mirah.lang.ast.NodeImpl$Extension8"})
public class NodeImpl
implements Node {
    private Node parent;
    private LinkedList clone_listeners = new LinkedList();
    private Position position;
    private Node originalNode;

    @Override
    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitOther(this, arg);
    }

    @Override
    public Position position() {
        return this.position;
    }

    public void position_set(Position value) {
        this.position = value;
    }

    @Override
    public Node parent() {
        return this.parent;
    }

    @Override
    public Node originalNode() {
        return this.originalNode;
    }

    @Override
    public Node findAncestor(Class type) {
        boolean $or$1;
        Node node = this;
        while (!(($or$1 = node == null) ? $or$1 : type.isInstance(node))) {
            node = node.parent();
        }
        return node;
    }

    @Override
    public Node findAncestor(NodeFilter filter) {
        boolean $or$2;
        Node node = this;
        while (!(($or$2 = node == null) ? $or$2 : filter.matchesNode(node))) {
            node = node.parent();
        }
        return node;
    }

    public String toString() {
        String name = this instanceof Named ? ":" + ((Named)((Object)this)).name() : "";
        return "<" + this.getClass().getName() + name + ">";
    }

    @Override
    public Object clone() {
        NodeImpl cloned = (NodeImpl)super.clone();
        cloned.initCopy();
        this.fireWasCloned(cloned);
        return cloned;
    }

    @Override
    public void setParent(Node parent) {
        this.parent = parent;
    }

    @Override
    public void setOriginalNode(Node node) {
        this.originalNode = node;
    }

    @Override
    public void whenCloned(CloneListener listener) {
        this.clone_listeners.add(listener);
    }

    public NodeImpl() {
    }

    public NodeImpl(Position position) {
        this.position_set(position);
    }

    public Node childAdded(Node child) {
        if (child == null) {
            return child;
        }
        boolean bl = child.parent() != null ? child.parent() != this : false;
        if (bl) {
            child = (Node)child.clone();
        }
        child.setParent(this);
        return child;
    }

    public Node childRemoved(Node child) {
        if (child == null) {
            return null;
        }
        child.setParent(null);
        return child;
    }

    public void fireWasCloned(Node clone) {
        for (Object listener : this.clone_listeners) {
            ((CloneListener)listener).wasCloned(this, clone);
        }
    }

    public void initCopy() {
        this.parent = null;
        this.clone_listeners = new LinkedList();
    }
}

