/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.impl;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.ListIterator;
import java.util.logging.Logger;
import mirahparser.impl.MirahLexer;
import mirahparser.impl.Tokens;
import mmeta.BaseParser;
import mmeta.SyntaxError;

/*
 * Exception performing whole class analysis ignored.
 */
public class MirahLexer {
    private static final Logger logger = Logger.getLogger(MirahLexer.class.getName());
    private static final int EOF = -1;
    private Input input;
    private BaseParser parser;
    private State state;
    private ArrayList<BaseParser.Token<Tokens>> tokens = new ArrayList();
    private EnumSet<Tokens> beginTokens;
    private EnumSet<Tokens> argTokens;
    private EnumSet<Tokens> endTokens;
    private boolean spaceSeen = false;
    private boolean isBEG = true;
    private boolean isARG = false;
    private boolean isEND = false;

    public MirahLexer(String string, char[] chars, BaseParser parser) {
        this((Input)new StringInput(string, chars));
        this.parser = parser;
    }

    public MirahLexer(Input input) {
        this.input = input;
        this.pushState((Lexer)new StandardLexer(null));
        this.argTokens = EnumSet.of(Tokens.tSuper, Tokens.tYield, Tokens.tIDENTIFIER, Tokens.tCONSTANT, Tokens.tFID);
        this.beginTokens = EnumSet.range(Tokens.tBang, Tokens.tOpAssign);
        this.beginTokens.addAll(EnumSet.of(Tokens.tElse, new Tokens[]{Tokens.tCase, Tokens.tEnsure, Tokens.tElsif, Tokens.tNot, Tokens.tThen, Tokens.tFor, Tokens.tReturn, Tokens.tIf, Tokens.tIn, Tokens.tDo, Tokens.tUntil, Tokens.tUnless, Tokens.tOr, Tokens.tWhen, Tokens.tAnd, Tokens.tBegin, Tokens.tWhile, Tokens.tNL, Tokens.tSemi, Tokens.tColon, Tokens.tSlash, Tokens.tLBrace, Tokens.tLBrack, Tokens.tLParen, Tokens.tDots}));
        this.beginTokens.addAll(EnumSet.range(Tokens.tComma, Tokens.tRocket));
        this.endTokens = EnumSet.of(Tokens.tDot, new Tokens[]{Tokens.tCharacter, Tokens.tSQuote, Tokens.tDQuote, Tokens.tRParen, Tokens.tRBrace, Tokens.tRBrack, Tokens.tRegexEnd, Tokens.tInteger, Tokens.tFloat, Tokens.tInstVar, Tokens.tClassVar, Tokens.tEnd, Tokens.tSelf, Tokens.tFalse, Tokens.tTrue, Tokens.tRetry, Tokens.tBreak, Tokens.tNil, Tokens.tNext, Tokens.tRedo, Tokens.tClass, Tokens.tDef});
    }

    private boolean isBEG() {
        return this.isBEG;
    }

    private boolean isARG() {
        return this.isARG;
    }

    private boolean isEND() {
        return this.isEND;
    }

    private void pushState(Lexer lexer) {
        this.state = new State(this.state, lexer);
    }

    private void pushForOneToken(Lexer lexer) {
        this.state = new State(this.state, lexer, true);
    }

    private void popState() {
        if (this.state.previous != null) {
            this.state = this.state.previous;
        }
    }

    public Tokens simpleLex() {
        boolean shouldPop = this.state.justOnce;
        Tokens type = this.state.lexer.skipWhitespace(this, this.input);
        if (type != null) {
            this.spaceSeen = true;
            return type;
        }
        type = this.state.lexer.lex(this, this.input);
        if (shouldPop) {
            this.popState();
        }
        this.spaceSeen = false;
        this.isBEG = this.beginTokens.contains(type);
        this.isARG = this.argTokens.contains(type);
        this.isEND = this.endTokens.contains(type);
        return type;
    }

    public BaseParser.Token<Tokens> lex(int pos) {
        return this.lex(pos, true, true);
    }

    public BaseParser.Token<Tokens> lex(int pos, boolean skipWhitespaceAndAllComments) {
        return this.lex(pos, skipWhitespaceAndAllComments, skipWhitespaceAndAllComments);
    }

    public BaseParser.Token<Tokens> lex(int pos, boolean skipWhitespaceAndComments, boolean skipJavaDocs) {
        int start;
        Tokens type;
        if (pos < this.input.pos()) {
            ListIterator it = this.tokens.listIterator(this.tokens.size());
            while (it.hasPrevious()) {
                BaseParser.Token savedToken = (BaseParser.Token)it.previous();
                if (pos < savedToken.pos || pos > savedToken.startpos) continue;
                logger.fine("Warning, uncached token " + savedToken.type + " at " + pos);
                this.parser._pos = savedToken.endpos;
                return savedToken;
            }
            throw new IllegalArgumentException("" + pos + " < " + this.input.pos());
        }
        if (!this.input.hasNext()) {
            return this.parser.build_token((Enum)(this.state.hereDocs.isEmpty() ? Tokens.tEOF : Tokens.tHereDocBegin), pos, pos);
        }
        do {
            start = this.input.pos();
            type = this.simpleLex();
        } while (skipWhitespaceAndComments && (type == Tokens.tWhitespace || type == Tokens.tComment) || skipJavaDocs && type == Tokens.tJavaDoc);
        this.parser._pos = this.input.pos();
        BaseParser.Token token = this.parser.build_token((Enum)type, pos, start);
        this.tokens.add(token);
        return token;
    }

    void noteNewline() {
        if (this.parser != null) {
            this.parser.note_newline(this.input.pos());
        }
    }

    public Tokens unterminatedComment() {
        if (this.parser == null) {
            return Tokens.tPartialComment;
        }
        throw new SyntaxError("terminated comment", "*/", this.parser._pos, this.parser._string, this.parser._list);
    }

    public Object getState() {
        if (this.state.previous == null && this.state.hereDocs.isEmpty() && this.state.braceDepth < 32) {
            int compressed = 0;
            if (this.isBEG) {
                compressed = 1;
            } else if (this.isEND) {
                compressed = 2;
            } else if (this.isARG) {
                compressed = this.spaceSeen ? 4 : 3;
            }
            return compressed |= this.state.braceDepth << 3;
        }
        return new CombinedState(this);
    }

    public void restore(Object state) {
        if (state instanceof CombinedState) {
            CombinedState cs = (CombinedState)state;
            this.state = CombinedState.access$1300((CombinedState)cs);
            this.spaceSeen = CombinedState.access$1400((CombinedState)cs);
            this.isBEG = CombinedState.access$1500((CombinedState)cs);
            this.isARG = CombinedState.access$1600((CombinedState)cs);
            this.isEND = CombinedState.access$1700((CombinedState)cs);
        } else {
            int compressed = (Integer)state;
            this.state = new State(null, (Lexer)new StandardLexer(null));
            this.state.braceDepth = compressed >> 3 & 0x1F;
            this.spaceSeen = false;
            this.isEND = false;
            this.isARG = false;
            this.isBEG = false;
            switch (compressed & 7) {
                case 1: {
                    this.isBEG = true;
                    break;
                }
                case 2: {
                    this.isEND = true;
                    break;
                }
                case 4: {
                    this.spaceSeen = true;
                }
                case 3: {
                    this.isARG = true;
                }
            }
        }
    }

    static /* synthetic */ void access$000(MirahLexer x0) {
        x0.popState();
    }

    static /* synthetic */ State access$100(MirahLexer x0) {
        return x0.state;
    }

    static /* synthetic */ boolean access$200(MirahLexer x0) {
        return x0.isBEG();
    }

    static /* synthetic */ boolean access$300(MirahLexer x0) {
        return x0.isARG();
    }

    static /* synthetic */ boolean access$400(MirahLexer x0) {
        return x0.isEND();
    }

    static /* synthetic */ boolean access$500(MirahLexer x0) {
        return x0.spaceSeen;
    }

    static /* synthetic */ void access$700(MirahLexer x0, Lexer x1) {
        x0.pushState(x1);
    }

    static /* synthetic */ void access$800(MirahLexer x0, Lexer x1) {
        x0.pushForOneToken(x1);
    }
}

