/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.lang.ast;

import java.util.LinkedList;
import mirahparser.lang.ast.CloneListener;
import mirahparser.lang.ast.Named;
import mirahparser.lang.ast.Node;
import mirahparser.lang.ast.NodeFilter;
import mirahparser.lang.ast.NodeVisitor;
import mirahparser.lang.ast.Position;
import org.mirah.macros.anno.Extensions;

@Extensions(macros={"mirahparser.lang.ast.NodeImpl$Extension1", "mirahparser.lang.ast.NodeImpl$Extension2", "mirahparser.lang.ast.NodeImpl$Extension3", "mirahparser.lang.ast.NodeImpl$Extension4", "mirahparser.lang.ast.NodeImpl$Extension5", "mirahparser.lang.ast.NodeImpl$Extension6", "mirahparser.lang.ast.NodeImpl$Extension7", "mirahparser.lang.ast.NodeImpl$Extension8"})
public class NodeImpl
implements Node {
    private Node parent;
    private LinkedList clone_listeners = new LinkedList();
    private Position position;
    private Node originalNode;

    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitOther((Node)this, arg);
    }

    public Position position() {
        return this.position;
    }

    public void position_set(Position value) {
        this.position = value;
    }

    public Node parent() {
        return this.parent;
    }

    public Node originalNode() {
        return this.originalNode;
    }

    public Node findAncestor(Class type) {
        boolean $or$1;
        Node node = (Node)this;
        while (!(($or$1 = node == null) ? $or$1 : type.isInstance(node))) {
            node = node.parent();
        }
        return node;
    }

    public Node findAncestor(NodeFilter filter) {
        boolean $or$2;
        Node node = (Node)this;
        while (!(($or$2 = node == null) ? $or$2 : filter.matchesNode(node))) {
            node = node.parent();
        }
        return node;
    }

    public String toString() {
        String name = this instanceof Named ? ":" + ((Named)this).name() : "";
        return "<" + this.getClass().getName() + name + ">";
    }

    public Object clone() {
        NodeImpl cloned = (NodeImpl)super.clone();
        cloned.initCopy();
        this.fireWasCloned((Node)cloned);
        return cloned;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }

    public void setOriginalNode(Node node) {
        this.originalNode = node;
    }

    public void whenCloned(CloneListener listener) {
        this.clone_listeners.add(listener);
    }

    public NodeImpl() {
    }

    public NodeImpl(Position position) {
        this.position_set(position);
    }

    public Node childAdded(Node child) {
        if (child == null) {
            return child;
        }
        boolean bl = child.parent() != null ? child.parent() != this : false;
        if (bl) {
            child = (Node)child.clone();
        }
        child.setParent((Node)this);
        return child;
    }

    public Node childRemoved(Node child) {
        if (child == null) {
            return null;
        }
        child.setParent(null);
        return child;
    }

    public void fireWasCloned(Node clone) {
        for (Object listener : this.clone_listeners) {
            ((CloneListener)listener).wasCloned((Node)this, clone);
        }
    }

    public void initCopy() {
        this.parent = null;
        this.clone_listeners = new LinkedList();
    }
}

