/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.lang.ast;

import mirahparser.lang.ast.CodeSource;
import mirahparser.lang.ast.Position;

public class PositionImpl
implements Position {
    private int endLine;
    private int endColumn;
    private int startChar;
    private int startColumn;
    private int startLine;
    private int endChar;
    private CodeSource source;

    public PositionImpl(CodeSource source, int startChar, int startLine, int startColumn, int endChar, int endLine, int endColumn) {
        this.source = source;
        this.startChar = startChar;
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endChar = endChar;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public String toString() {
        return "source:" + (this.source() != null ? this.source().name() : null) + " start:" + this.startLine() + " " + this.startColumn() + " end: " + this.endLine() + " " + this.endColumn();
    }

    public CodeSource source() {
        return this.source;
    }

    public int startChar() {
        return this.startChar;
    }

    public int startLine() {
        return this.startLine;
    }

    public int startColumn() {
        return this.startColumn;
    }

    public int endChar() {
        return this.endChar;
    }

    public int endLine() {
        return this.endLine;
    }

    public int endColumn() {
        return this.endColumn;
    }

    public Position add(Position other) {
        if (other == null) {
            return this;
        }
        return this.source.equals(other.source()) ? (Position)new PositionImpl(this.source, Math.min(this.startChar, other.startChar()), Math.min(this.startLine, other.startLine()), Math.min(this.startColumn, other.startColumn()), Math.max(this.endChar, other.endChar()), Math.max(this.endLine, other.endLine()), Math.max(this.endColumn, other.endColumn())) : (Position)this;
    }

    public static Position add(Position a, Position b) {
        return (a != null ? b : null) != null ? a.add(b) : (a != null ? a : b);
    }
}

