/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.lang.ast;

import mirahparser.lang.ast.CodeSource;

public class StringCodeSource
implements CodeSource {
    private int startCol;
    private String code;
    private int startLine;
    private String name;

    public StringCodeSource(String name, String code) {
        this.name = name;
        this.code = code;
        this.startLine = 1;
        this.startCol = 1;
    }

    public StringCodeSource(String name, String code, int startLine, int startCol) {
        this.name = name;
        this.code = code;
        this.startLine = startLine;
        this.startCol = startCol;
    }

    public String name() {
        return this.name;
    }

    public String contents() {
        return this.code;
    }

    public String substring(int startPos, int endPos) {
        return this.code.substring(startPos, endPos);
    }

    public int initialLine() {
        return this.startLine;
    }

    public int initialColumn() {
        return this.startCol;
    }

    public String toString() {
        return this.name + " " + this.code + " " + this.startLine + ":" + this.startCol;
    }
}

