/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.lang.ast;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import mirahparser.lang.ast.Node;
import mirahparser.lang.ast.NodeImpl;
import mirahparser.lang.ast.NodeVisitor;
import mirahparser.lang.ast.Position;
import mirahparser.lang.ast.StringPiece;
import mirahparser.lang.ast.StringPieceListIterator;

public class StringPieceList
extends NodeImpl
implements Iterable {
    private ArrayList children;

    public void common_init(int size) {
        this.children = size < 0 ? new ArrayList() : new ArrayList(size);
    }

    public StringPieceList() {
        this.common_init(-1);
    }

    public StringPieceList(Position position) {
        this.position_set(position);
        this.common_init(-1);
    }

    public StringPieceList(List children) {
        if (children != null) {
            this.common_init(children.size());
            Position startPosition = null;
            Position endPosition = null;
            for (Node _node : children) {
                Node node = _node;
                if (node == null) continue;
                this.children.add(this.childAdded(node));
                if (startPosition == null) {
                    startPosition = node.position();
                }
                endPosition = node.position();
            }
            if (!this.children.isEmpty()) {
                this.position_set(startPosition.add(endPosition));
            }
        } else {
            this.common_init(-1);
        }
    }

    public StringPieceList(Position position, List children) {
        this.position_set(position);
        if (children != null) {
            this.common_init(children.size());
            for (Node node : children) {
                this.children.add(this.childAdded(node));
            }
        } else {
            this.common_init(-1);
        }
    }

    public int size() {
        return this.children.size();
    }

    public StringPiece get(int i) {
        Object child = this.children.get(i);
        return (StringPiece)child;
    }

    public StringPiece set(int i, StringPiece node) {
        block0: {
            StringPiece current = this.get(i);
            if (current == node) break block0;
            this.childRemoved((Node)current);
            this.children.set(i, this.childAdded((Node)node));
        }
        return node;
    }

    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        int i = this.children.indexOf(oldChild);
        Node clone = this.childAdded(newChild);
        this.set(i, (StringPiece)clone);
        clone.setOriginalNode(oldChild);
        return clone;
    }

    public void removeChild(Node child) {
        this.children.remove(child);
    }

    public void initCopy() {
        super.initCopy();
        ArrayList<Node> new_children = new ArrayList<Node>(this.children.size());
        for (Object child : this.children) {
            new_children.add(child != null ? this.childAdded((Node)((Node)child).clone()) : null);
        }
        this.children = new_children;
    }

    public void add(StringPiece node) {
        this.children.add(this.childAdded((Node)node));
    }

    public void insert(int i, StringPiece node) {
        this.children.add(i, this.childAdded((Node)node));
    }

    public StringPiece remove(int i) {
        Node node = (Node)this.children.remove(i);
        this.childRemoved(node);
        return (StringPiece)node;
    }

    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitStringPieceList(this, arg);
    }

    public Iterator iterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int start) {
        return new StringPieceListIterator(this, start);
    }
}

