/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.lang.ast;

import java.util.ListIterator;
import java.util.NoSuchElementException;
import mirahparser.lang.ast.StringPiece;
import mirahparser.lang.ast.StringPieceList;

public class StringPieceListIterator
implements ListIterator {
    private StringPieceList listNode;
    private int nextIndex;
    private int lastIndex;

    public StringPieceListIterator(StringPieceList list, int start) {
        boolean $or$1;
        boolean bl = $or$1 = start < 0;
        if ($or$1 ? $or$1 : start > list.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.nextIndex = start;
        this.lastIndex = -1;
        this.listNode = list;
    }

    public void add(Object o) {
        StringPiece node = (StringPiece)o;
        this.listNode.insert(this.nextIndex, node);
        ++this.nextIndex;
        this.lastIndex = -1;
    }

    @Override
    public boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    @Override
    public boolean hasNext() {
        return this.nextIndex < this.listNode.size();
    }

    @Override
    public Object next() {
        if (this.nextIndex >= this.listNode.size()) {
            this.lastIndex = -1;
            throw new NoSuchElementException();
        }
        this.lastIndex = this.nextIndex++;
        return this.listNode.get(this.nextIndex - 1);
    }

    @Override
    public int nextIndex() {
        return this.nextIndex;
    }

    public Object previous() {
        if (this.nextIndex > 0) {
            --this.nextIndex;
        } else {
            this.lastIndex = -1;
            throw new NoSuchElementException();
        }
        this.lastIndex = this.nextIndex();
        return this.listNode.get(this.nextIndex);
    }

    @Override
    public int previousIndex() {
        return this.nextIndex - 1;
    }

    @Override
    public void remove() {
        boolean $or$2;
        boolean bl = $or$2 = this.lastIndex == -1;
        if ($or$2 ? $or$2 : this.lastIndex == this.listNode.size()) {
            throw new IllegalStateException();
        }
        this.listNode.remove(this.lastIndex);
        this.nextIndex = this.lastIndex;
        this.lastIndex = -1;
    }

    public void set(Object o) {
        boolean $or$3;
        boolean bl = $or$3 = this.lastIndex == -1;
        if ($or$3 ? $or$3 : this.lastIndex == this.listNode.size()) {
            throw new IllegalStateException();
        }
        StringPiece node = (StringPiece)o;
        this.listNode.set(this.lastIndex, node);
    }
}

