/*
 * Decompiled with CFR 0.152.
 */
package mirahparser.lang.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mirahparser.lang.ast.Arguments;
import mirahparser.lang.ast.BlockArgument;
import mirahparser.lang.ast.Constant;
import mirahparser.lang.ast.FieldAccess;
import mirahparser.lang.ast.Fixnum;
import mirahparser.lang.ast.Hash;
import mirahparser.lang.ast.Identifier;
import mirahparser.lang.ast.LocalAccess;
import mirahparser.lang.ast.Named;
import mirahparser.lang.ast.Node;
import mirahparser.lang.ast.NodeImpl;
import mirahparser.lang.ast.NodeVisitor;
import mirahparser.lang.ast.OptionalArgument;
import mirahparser.lang.ast.Position;
import mirahparser.lang.ast.RequiredArgument;
import mirahparser.lang.ast.RestArgument;
import mirahparser.lang.ast.SimpleString;
import mirahparser.lang.ast.TypeName;
import mirahparser.lang.ast.TypeRef;
import mirahparser.lang.ast.TypeRefImpl;

public class Unquote
extends NodeImpl
implements TypeName,
Identifier {
    private Node value;
    private Object object;

    public Unquote() {
    }

    public Unquote(Position position) {
        this.position_set(position);
    }

    public Object accept(NodeVisitor visitor, Object arg) {
        return visitor.visitUnquote(this, arg);
    }

    public Node value() {
        return this.value;
    }

    public void value_set(Node value) {
        Node clone;
        if (value == this.value) {
            return;
        }
        this.childRemoved(this.value);
        this.value = value = (clone = this.childAdded(value));
    }

    public Object object() {
        return this.object;
    }

    public void object_set(Object value) {
        this.object = value;
    }

    public Unquote(Position position, Node value) {
        this.position_set(position);
        this.value_set(value);
    }

    public Unquote(Node value) {
        this.value_set(value);
    }

    public Node replaceChild(Node oldChild, Node newChild) {
        if (oldChild == newChild) {
            return newChild;
        }
        Node clone = this.childAdded(newChild);
        if (this.value() == oldChild) {
            this.value_set(clone);
            clone.setOriginalNode(oldChild);
            return clone;
        }
        throw new IllegalArgumentException("No child " + oldChild);
    }

    public void removeChild(Node child) {
        if (this.value() == child) {
            this.value_set(null);
            return;
        }
        throw new IllegalArgumentException("No child " + child);
    }

    public void initCopy() {
        block0: {
            super.initCopy();
            if (this.value() == null) break block0;
            this.value = this.childAdded((Node)this.value().clone());
        }
    }

    public String identifier() {
        Object $or$1 = this.object;
        Object obj = $or$1 != null ? $or$1 : this.value;
        return this.identifierNode(obj).identifier();
    }

    public Identifier identifierNode(Object obj) {
        Identifier identifier;
        if (obj instanceof Identifier) {
            identifier = (Identifier)obj;
        } else if (obj instanceof Named) {
            identifier = ((Named)obj).name();
        } else if (obj instanceof String) {
            identifier = new SimpleString((String)obj);
        } else {
            throw new UnsupportedOperationException(obj + " is not an Identifier");
        }
        return identifier;
    }

    public TypeRef typeref(Object obj) {
        TypeRef typeRef;
        if (obj == null) {
            Object $or$2 = this.object;
            Object object = obj = $or$2 != null ? $or$2 : this.value;
        }
        if (obj instanceof TypeRef) {
            typeRef = (TypeRef)obj;
        } else if (obj instanceof TypeName) {
            typeRef = ((TypeName)obj).typeref();
        } else if (obj instanceof Identifier) {
            Identifier id = (Identifier)obj;
            typeRef = new TypeRefImpl(id.identifier(), false, false, id.position());
        } else if (obj instanceof String) {
            typeRef = new TypeRefImpl((String)obj);
        } else {
            throw new UnsupportedOperationException(obj + " does not name a type");
        }
        return typeRef;
    }

    public List nodes() {
        List list;
        Object value = this.object();
        if (value == null) {
            return Collections.emptyList();
        }
        boolean bl = (value instanceof Iterable ? !(value instanceof Hash) : false) ? !(value instanceof Node) : false;
        if (bl) {
            List values = new ArrayList();
            for (Object o : (Iterable)value) {
                values.add(this.nodeValue(o));
            }
            list = values;
        } else {
            list = Collections.singletonList(this.nodeValue(value));
        }
        return list;
    }

    public Node node() {
        return this.nodeValue(this.object());
    }

    public Node nodeValue(Object value) {
        Object object;
        if (value == null) {
            return null;
        }
        if (value instanceof Node) {
            return (Node)value;
        }
        if (value instanceof Integer) {
            return new Fixnum(this.position(), (long)((Integer)value).intValue());
        }
        if (!(value instanceof String)) {
            throw new IllegalArgumentException("Bad unquote value for node " + value + "  (" + value.getClass() + ")");
        }
        String strvalue = (String)value;
        if ("@".equals(strvalue.substring(0, 1))) {
            object = (Node)new FieldAccess(this.position(), (Identifier)new SimpleString(this.position(), strvalue.substring(1)));
        } else {
            SimpleString strnode = new SimpleString(this.position(), strvalue);
            boolean $or$3 = Character.isUpperCase(strvalue.charAt(0));
            object = ($or$3 ? $or$3 : strvalue.indexOf(".") >= 0) ? (Node)new Constant(this.position(), (Identifier)strnode) : new LocalAccess(this.position(), (Identifier)strnode);
        }
        return object;
    }

    public Arguments arguments() {
        Arguments arguments;
        boolean $or$4 = this.object() instanceof Arguments;
        if ($or$4 ? $or$4 : this.object() == null) {
            arguments = (Arguments)this.object();
        } else if (this.object() instanceof List) {
            Arguments args = Arguments.empty((Position)this.position());
            for (Object o : (List)this.object()) {
                this.add_arg(args, this.arg_item(o));
            }
            arguments = args;
        } else {
            Arguments args = Arguments.empty((Position)this.position());
            this.add_arg(args, this.arg_item(this.object()));
            arguments = args;
        }
        return arguments;
    }

    public Arguments add_arg(Arguments args, Node node) {
        if (node instanceof OptionalArgument) {
            args.optional().add((OptionalArgument)node);
        } else if (node instanceof RestArgument) {
            args.rest_set((RestArgument)node);
        } else if (node instanceof BlockArgument) {
            args.block_set((BlockArgument)node);
        } else {
            RequiredArgument arg = (RequiredArgument)node;
            boolean bl = (args.required2().size() == 0 ? args.rest() == null : false) ? args.optional().size() == 0 : false;
            if (bl) {
                args.required().add(arg);
            } else {
                args.required2().add(arg);
            }
        }
        return args;
    }

    public Node arg_item(Object object) {
        Node node;
        boolean $or$5 = object instanceof RequiredArgument;
        boolean $or$6 = $or$5 ? $or$5 : object instanceof OptionalArgument;
        boolean $or$7 = $or$6 ? $or$6 : object instanceof RestArgument;
        if ($or$7 ? $or$7 : object instanceof BlockArgument) {
            node = (Node)object;
        } else if (object instanceof Identifier) {
            Identifier id = (Identifier)object;
            node = new RequiredArgument(id.position(), id, null);
        } else if (object instanceof String) {
            node = new RequiredArgument(this.position(), (Identifier)new SimpleString(this.position(), (String)object), null);
        } else if (object instanceof List) {
            List l = (List)object;
            Object nameobj = l.get(0);
            TypeRef type = l.size() > 1 ? this.typeref(l.get(1)) : null;
            Identifier name = this.identifierNode(nameobj);
            node = new RequiredArgument(name.position(), name, (TypeName)type);
        } else {
            throw new IllegalArgumentException("Bad unquote value for arg " + this.value() + " (" + this.value().getClass() + ")");
        }
        return node;
    }
}

