/*
 * Decompiled with CFR 0.152.
 */
package org.mirah;

import java.io.UnsupportedEncodingException;
import java.security.SecureClassLoader;
import java.util.Map;

public class MirahClassLoader
extends SecureClassLoader {
    private Map<String, String> class_map;

    public MirahClassLoader(ClassLoader parent, Map class_map) {
        super(parent);
        this.class_map = class_map;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        if (this.class_map.containsKey(name)) {
            try {
                String value = this.class_map.get(name);
                byte[] bytes = null;
                bytes = value instanceof byte[] ? (byte[])value : value.getBytes("ISO-8859-1");
                return this.defineClass(name.replace('/', '.'), bytes, 0, bytes.length);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ClassNotFoundException(name, ex);
            }
        }
        throw new ClassNotFoundException(name);
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.findLoadedClass(name.replace('/', '.'));
        if (cls == null) {
            cls = this.class_map.containsKey(name) ? this.findClass(name) : super.loadClass(name, false);
        }
        if (resolve) {
            this.resolveClass(cls);
        }
        return cls;
    }
}

