/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.ast;

import java.util.ArrayList;
import mirah.lang.ast.Constant;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Node;
import mirah.lang.ast.NodeList;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.TypeNameList;
import org.mirah.ast.BaseNodeState;
import org.mirah.ast.VisitorState;
import org.mirah.macros.Compiler;

public class ListNodeState
extends BaseNodeState {
    private VisitorState visitors;

    public ListNodeState(Compiler mirah, Node type, VisitorState visitors) {
        super(mirah, type);
        this.visitors = visitors;
        if (visitors == null) {
            throw new NullPointerException();
        }
    }

    public NodeList init_list(Identifier type) {
        String type_name = type.identifier();
        String visitor_method = "visit" + this.name();
        this.visitors.addList(this.name());
        String iterator_name = this.name() + "Iterator";
        TypeNameList interfaces = this.enclosing_class(type).interfaces();
        if (interfaces == null) {
            interfaces = new TypeNameList();
            this.enclosing_class(type).interfaces_set(interfaces);
            this.mirah().typer().infer(interfaces);
        }
        Constant iterable = new Constant(new SimpleString("Iterable"));
        interfaces.add(iterable);
        this.mirah().typer().infer(iterable);
        Compiler compiler = this.mirah();
        ArrayList<Object> arrayList = new ArrayList<Object>(15);
        arrayList.add(type_name);
        arrayList.add(this.mirah().cast(type_name, "child"));
        arrayList.add(type_name);
        arrayList.add(type_name);
        arrayList.add(this.mirah().cast(type_name, "clone"));
        arrayList.add(type_name);
        arrayList.add(type_name);
        arrayList.add(type_name);
        arrayList.add(this.mirah().cast(type_name, "node"));
        arrayList.add(visitor_method);
        arrayList.add(iterator_name);
        arrayList.add(iterator_name);
        arrayList.add(this.name());
        arrayList.add(this.mirah().cast(type_name, "o"));
        arrayList.add(this.mirah().cast(type_name, "o"));
        return (NodeList)compiler.deserializeAst("mirah-parser/src/org/mirah/ast/meta.mirah", 210, 7, "import java.util.Iterator\n      import java.util.ListIterator\n      import java.util.List\n\n      def common_init(size:int):void\n        if size < 0\n          @children = java::util::ArrayList.new\n        else\n          @children = java::util::ArrayList.new(size)\n        end\n      end\n\n      def initialize()\n        common_init(-1)\n      end\n\n      def initialize(position:Position)\n        self.position = position\n        common_init(-1)\n      end\n\n      def initialize(children:List)\n        if children\n          common_init(children.size)\n          startPosition = nil\n          endPosition = nil\n          children.each do |_node:Node|\n            node = Node(_node)\n            if node\n              @children.add(childAdded(node))\n              startPosition ||= node.position\n              endPosition = node.position\n            end\n          end\n          unless @children.isEmpty\n            self.position = startPosition + endPosition\n          end\n        else\n          common_init(-1)\n        end\n        nil\n      end\n\n      def initialize(position:Position, children:List)\n        self.position = position\n        if children\n          common_init(children.size)\n          children.each {|node:Node| @children.add(childAdded(Node(node)))}\n        else\n          common_init(-1)\n        end\n        nil\n      end\n\n      def size:int\n        @children.size\n      end\n\n      def get(i:int): `type_name`\n        child = @children.get(i)\n        `mirah.cast(type_name, 'child')`\n      end\n\n      def set(i:int, node:`type_name`): `type_name`\n        current = get(i)\n        if current != node\n          childRemoved(current)\n          @children.set(i, childAdded(node))\n        end\n        node\n      end\n\n      def replaceChild(oldChild:Node, newChild:Node):Node\n        if oldChild == newChild\n          return newChild\n        end\n        i = @children.indexOf(oldChild)\n        clone = childAdded(newChild)\n        set(i, `mirah.cast(type_name, 'clone')`)\n        clone.setOriginalNode(oldChild)\n        clone\n      end\n\n      def removeChild(child:Node):void\n        @children.remove(child)\n      end\n\n      def initCopy:void\n        super\n        new_children = java::util::ArrayList.new(@children.size)\n        @children.each {|child| new_children.add(child ? childAdded(Node(Node(child).clone)) : nil)}\n        @children = new_children\n      end\n\n      def add(node:`type_name`):void\n        @children.add(childAdded(node))\n      end\n\n      def insert(i:int, node:`type_name`):void\n        @children.add(i, childAdded(node))\n      end\n\n      def remove(i:int): `type_name`\n        node = Node(@children.remove(i))\n        childRemoved(node)\n        `mirah.cast(type_name, 'node')`\n      end\n\n      def accept(visitor, arg):Object\n        visitor.`visitor_method`(self, arg)\n      end\n\n#      public\n      def iterator:Iterator\n        listIterator(0)\n      end\n\n      def listIterator(start:int = 0):ListIterator\n        `iterator_name`.new(self, start)\n      end\n      \n      class `iterator_name` implements java.util.ListIterator\n        def initialize(list:`name`, start:int)\n          raise IndexOutOfBoundsException if (start < 0 || start > list.size)\n          @nextIndex = start\n          @lastIndex = -1\n          @listNode = list\n        end\n\n        def add(o)\n          node = `mirah.cast(type_name, 'o')`\n          @listNode.insert(@nextIndex, node)\n          @nextIndex += 1\n          @lastIndex = -1\n        end\n\n        def hasPrevious\n          @nextIndex > 0\n        end\n\n        def hasNext\n          @nextIndex < @listNode.size\n        end\n\n        def next\n          if @nextIndex < @listNode.size\n            @lastIndex = @nextIndex\n            @nextIndex += 1\n          else\n            @lastIndex = -1\n            raise java::util::NoSuchElementException\n          end\n          @listNode.get(@nextIndex - 1)\n        end\n\n        def nextIndex\n          @nextIndex\n        end\n\n        def previous\n          if @nextIndex > 0\n            @nextIndex -= 1\n            @lastIndex = nextIndex\n          else\n            @lastIndex = -1\n            raise java::util::NoSuchElementException\n          end\n          @listNode.get(@nextIndex)\n        end\n\n        def previousIndex\n          @nextIndex - 1\n        end\n\n        def remove\n          if @lastIndex == -1 || @lastIndex == @listNode.size\n            raise IllegalStateException\n          end\n          @listNode.remove(@lastIndex)\n          @nextIndex = @lastIndex\n          @lastIndex = -1\n        end\n\n        def set(o)\n          if @lastIndex == -1 || @lastIndex == @listNode.size\n            raise IllegalStateException\n          end\n          node = `mirah.cast(type_name, 'o')`\n          @listNode.set(@lastIndex, node)\n        end\n      end\n", arrayList);
    }
}

