/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import mirah.lang.ast.Annotation;
import mirah.lang.ast.AnnotationList;
import mirah.lang.ast.Array;
import mirah.lang.ast.Boolean;
import mirah.lang.ast.Fixnum;
import mirah.lang.ast.Float;
import mirah.lang.ast.HashEntry;
import mirah.lang.ast.Identifier;
import mirah.lang.ast.Node;
import mirah.lang.ast.SimpleString;
import mirah.lang.ast.TypeName;
import mirah.lang.ast.TypeRef;
import mirah.lang.ast.Unquote;
import org.mirah.jvm.compiler.AnnotationVisitorFactory;
import org.mirah.jvm.compiler.BaseCompiler;
import org.mirah.jvm.compiler.ClassAnnotationFactory;
import org.mirah.jvm.compiler.FieldAnnotationFactory;
import org.mirah.jvm.compiler.MethodAnnotationFactory;
import org.mirah.jvm.types.JVMMethod;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.mirah.typer.ResolvedType;
import org.mirah.typer.TypeSystem;
import org.mirah.util.Context;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class AnnotationCompiler
extends BaseCompiler {
    private static org.mirah.util.Logger log = org.mirah.util.Logger.getLogger(AnnotationCompiler.class.getName());

    public AnnotationCompiler(Context context) {
        super(context);
    }

    public void compile(AnnotationList annotations, ClassVisitor visitor) {
        this.compile(annotations, new ClassAnnotationFactory(visitor));
    }

    public void compile(AnnotationList annotations, MethodVisitor visitor) {
        this.compile(annotations, new MethodAnnotationFactory(visitor));
    }

    public void compile(AnnotationList annotations, FieldVisitor visitor) {
        this.compile(annotations, new FieldAnnotationFactory(visitor));
    }

    public void compile(AnnotationList annotations, AnnotationVisitorFactory factory) {
        int i = 0;
        int gensym0 = annotations.size();
        if (i < gensym0) {
            do {
                Annotation anno;
                if ((anno = annotations.get(i)).type().typeref().name().startsWith("org.mirah.jvm.")) continue;
                JVMType type = this.getInferredType(anno);
                if (!JVMTypeUtils.isAnnotation(type)) {
                    this.reportError(type.name() + " is not an annotation", anno.position());
                    continue;
                }
                String retention = type.retention();
                if ("SOURCE".equals(retention)) {
                    Logger gensym1 = log.internal_logger();
                    if (!gensym1.isLoggable(Level.FINE)) continue;
                    gensym1.fine("Skipping source annotation " + type.name());
                    continue;
                }
                Logger gensym2 = log.internal_logger();
                if (gensym2.isLoggable(Level.FINE)) {
                    gensym2.fine("Compiling " + retention + " annotation " + type.name());
                }
                AnnotationVisitor visitor = factory.create(type.getAsmType().getDescriptor(), "RUNTIME".equals(retention));
                this.compileValues(anno, visitor);
                visitor.visitEnd();
            } while (++i < gensym0);
        }
    }

    public void compileValues(Annotation anno, AnnotationVisitor visitor) {
        JVMType type = this.getInferredType(anno);
        int i = 0;
        int gensym0 = anno.values_size();
        if (i < gensym0) {
            do {
                HashEntry entry = anno.values(i);
                String name = ((Identifier)entry.key()).identifier();
                Node value = entry.value();
                JVMMethod method = type.getMethod(name, Collections.emptyList());
                if (method == null) {
                    this.reportError("No method " + type.name() + "." + name + "()", entry.key().position());
                    continue;
                }
                JVMType value_type = method.returnType();
                this.compileValue(visitor, name, value, value_type);
            } while (++i < gensym0);
        }
    }

    public void compileValue(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        if (JVMTypeUtils.isArray(type)) {
            this.compileArray(visitor, name, value, type.getComponentType());
        } else if (JVMTypeUtils.isEnum(type)) {
            this.compileEnum(visitor, name, value, type);
        } else if (JVMTypeUtils.isAnnotation(type)) {
            this.compileAnnotation(visitor, name, value, type);
        } else if (JVMTypeUtils.isPrimitive(type)) {
            this.compilePrimitive(visitor, name, value, type);
        } else if ("java.lang.String".equals(type.name())) {
            this.compileString(visitor, name, value);
        } else if ("java.lang.Class".equals(type.name())) {
            this.compileClass(visitor, name, value);
        } else {
            this.reportError("Unsupported annotation value " + type.name(), value.position());
        }
    }

    public void compileArray(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        Iterable values;
        if (value instanceof Unquote) {
            values = ((Unquote)value).nodes();
        } else if (value instanceof Array) {
            values = ((Array)value).values();
        } else {
            this.reportError("Expected an array, found " + value.getClass(), value.position());
            return;
        }
        AnnotationVisitor child = visitor.visitArray(name);
        for (Node n : values) {
            this.compileValue(child, null, n, type);
        }
        child.visitEnd();
    }

    public void compileEnum(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        if (!(value instanceof Identifier)) {
            this.reportError("Expected an identifier, found " + value.getClass(), value.position());
            return;
        }
        String value_name = ((Identifier)value).identifier();
        if (!type.hasStaticField(value_name)) {
            this.reportError("Cannot find enum value " + type.name() + "." + value_name, value.position());
            return;
        }
        visitor.visitEnum(name, type.getAsmType().getDescriptor(), value_name);
    }

    public void compileAnnotation(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        if (value instanceof Unquote) {
            value = ((Unquote)value).node();
        }
        if (!(value instanceof Annotation)) {
            this.reportError("Expected an annotation, found " + value.getClass(), value.position());
            return;
        }
        JVMType subtype = this.getInferredType(value);
        AnnotationVisitor child = visitor.visitAnnotation(name, subtype.getAsmType().getDescriptor());
        this.compileValues((Annotation)value, child);
        child.visitEnd();
    }

    public void compilePrimitive(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        if (value instanceof Unquote) {
            value = ((Unquote)value).node();
        }
        if ("boolean".equals(type.name())) {
            this.compileBool(visitor, name, value);
        } else {
            boolean $or$1 = "float".equals(type.name());
            if ($or$1 ? $or$1 : "double".equals(type.name())) {
                this.compileFloat(visitor, name, value, type);
            } else {
                this.compileInt(visitor, name, value, type);
            }
        }
    }

    public void compileBool(AnnotationVisitor visitor, String name, Node value) {
        if (!(value instanceof Boolean)) {
            this.reportError("Expected a boolean, found " + value.getClass(), value.position());
            return;
        }
        visitor.visit(name, ((Boolean)value).value());
    }

    public void compileFloat(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        if (!(value instanceof Float)) {
            this.reportError("Expected a float, found " + value.getClass(), value.position());
            return;
        }
        double double_value = ((Float)value).value();
        Number asm_value = "float".equals(type.name()) ? (Number)java.lang.Float.valueOf((float)double_value) : (Number)double_value;
        visitor.visit(name, asm_value);
    }

    public void compileInt(AnnotationVisitor visitor, String name, Node value, JVMType type) {
        boolean $or$2;
        Comparable<Byte> asm_value;
        if (!(value instanceof Fixnum)) {
            this.reportError("Expected a " + type.name() + " literal, found " + value.getClass(), value.position());
            return;
        }
        long long_value = ((Fixnum)value).value();
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;
        if ("byte".equals(type.name())) {
            min = Byte.MIN_VALUE;
            max = Byte.MAX_VALUE;
            asm_value = (byte)long_value;
        } else if ("char".equals(type.name())) {
            min = Character.MIN_VALUE;
            max = Character.MAX_VALUE;
            asm_value = Character.valueOf((char)long_value);
        } else if ("short".equals(type.name())) {
            min = Short.MIN_VALUE;
            max = Short.MAX_VALUE;
            asm_value = (short)long_value;
        } else if ("int".equals(type.name())) {
            min = Integer.MIN_VALUE;
            max = Integer.MAX_VALUE;
            asm_value = (int)long_value;
        } else if ("long".equals(type.name())) {
            asm_value = long_value;
        } else {
            this.reportError("Unsupported primitive type " + type.name(), value.position());
            return;
        }
        boolean bl = $or$2 = long_value < min;
        if ($or$2 ? $or$2 : long_value > max) {
            this.reportError("Value " + long_value + " out of " + type.name() + " range", value.position());
            return;
        }
        visitor.visit(name, asm_value);
    }

    public void compileString(AnnotationVisitor visitor, String name, Node value) {
        if (value instanceof Unquote) {
            value = ((Unquote)value).node();
        }
        if (!(value instanceof SimpleString)) {
            this.reportError("Expected a string literal, found " + value.getClass(), value.position());
            return;
        }
        visitor.visit(name, ((SimpleString)value).value());
    }

    public void compileClass(AnnotationVisitor visitor, String name, Node value) {
        if (!(value instanceof TypeName)) {
            this.reportError("Expected a class, found " + value.getClass(), value.position());
            return;
        }
        TypeRef typeref = ((TypeName)value).typeref();
        ResolvedType klass = ((TypeSystem)this.context().get(TypeSystem.class)).get(this.getScope(value), typeref).resolve();
        if (klass.isError()) {
            this.reportError("Cannot find class " + typeref.name(), value.position());
            return;
        }
        visitor.visit(name, ((JVMType)klass).getAsmType());
    }
}

