/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.Map;
import javax.tools.DiagnosticListener;
import mirah.lang.ast.Script;
import org.mirah.jvm.compiler.AnnotationCompiler;
import org.mirah.jvm.compiler.Backend$1;
import org.mirah.jvm.compiler.Backend$2;
import org.mirah.jvm.compiler.BytecodeConsumer;
import org.mirah.jvm.compiler.JvmVersion;
import org.mirah.jvm.compiler.ProxyCleanup;
import org.mirah.jvm.compiler.ScriptCleanup;
import org.mirah.jvm.compiler.ScriptCompiler;
import org.mirah.macros.Compiler;
import org.mirah.typer.Typer;
import org.mirah.util.Context;
import org.mirah.util.SimpleDiagnostics;

public class Backend {
    private SimpleDiagnostics diagnostics;
    private Context context;
    private ScriptCompiler compiler;

    public Backend(Context context) {
        this.context = context;
        this.diagnostics = (SimpleDiagnostics)context.get(SimpleDiagnostics.class);
        this.context.add(Compiler.class, ((Typer)this.context.get(Typer.class)).macro_compiler());
        this.context.add(AnnotationCompiler.class, new AnnotationCompiler(this.context));
        this.compiler = new ScriptCompiler(this.context);
        if ((JvmVersion)this.context.get(JvmVersion.class) == null) {
            this.context.add(JvmVersion.class, new JvmVersion());
        }
    }

    public Backend(Typer typer) {
        this.context = new Context();
        this.context.add(Typer.class, typer);
        this.diagnostics = new SimpleDiagnostics(true);
        this.context.add(DiagnosticListener.class, this.diagnostics);
        this.context.add(Compiler.class, typer.macro_compiler());
        this.context.add(AnnotationCompiler.class, new AnnotationCompiler(this.context));
        this.compiler = new ScriptCompiler(this.context);
    }

    public void visit(Script script, Object arg) {
        this.clean(script, arg);
        this.compile(script, arg);
    }

    public void clean(Script script, Object arg) {
        script.accept(new ProxyCleanup(), arg);
        script.accept(new ScriptCleanup(this.context), arg);
    }

    public void compile(Script script, Object arg) {
        script.accept(this.compiler, arg);
    }

    public Object generate(BytecodeConsumer consumer) {
        if (this.diagnostics.errorCount() > 0) {
            throw new UnsupportedOperationException("Compilation failed");
        }
        return this.compiler.generate(consumer);
    }

    public static String write_out_file(Backend macro_backend, Map class_map, String destination) {
        new Backend$1().class_map = class_map;
        new Backend$1().destination = destination;
        Backend$1 backend$1 = new Backend$1();
        backend$1.first_class_name = null;
        macro_backend.generate(new Backend$2(backend$1));
        return backend$1.first_class_name;
    }
}

