/*
 * Decompiled with CFR 0.152.
 */
package org.mirah.jvm.compiler;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import mirah.lang.ast.CodeSource;
import mirah.lang.ast.Position;
import org.mirah.jvm.compiler.LocalInfo;
import org.mirah.jvm.compiler.LocalInitializerAdapter;
import org.mirah.jvm.types.JVMType;
import org.mirah.jvm.types.JVMTypeUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class Bytecode
extends GeneratorAdapter {
    private CodeSource codesource;
    private int nextLocal;
    private int firstLocal;
    private int flags;
    private LocalInitializerAdapter mv;
    private Label endLabel;
    private LinkedHashMap locals;
    private int currentLine;

    public Bytecode(int flags, Method method, ClassVisitor klass, CodeSource codesource) {
        this.mv = new LocalInitializerAdapter(klass.visitMethod(flags, method.getName(), method.getDescriptor(), null, null), flags, method.getDescriptor());
        super(Opcodes.ASM4, this.mv, flags, method.getName(), method.getDescriptor());
        this.endLabel = this.newLabel();
        this.locals = new LinkedHashMap();
        this.firstLocal = this.nextLocal = 0;
        this.codesource = codesource;
        this.currentLine = -1;
        this.flags = flags;
    }

    public int instruction_count() {
        return this.mv.instruction_count();
    }

    public LinkedList arguments() {
        LocalInfo info;
        LinkedList<LocalInfo> args = new LinkedList<LocalInfo>();
        Iterator gensym0 = this.locals.values().iterator();
        while (gensym0.hasNext() && (info = (LocalInfo)gensym0.next()).index() < this.firstLocal) {
            args.add(info);
        }
        return args;
    }

    public int declareArg(String name, JVMType type) {
        this.declareLocal(name, type.getAsmType());
        this.firstLocal = this.nextLocal;
        return this.firstLocal;
    }

    public LocalInfo declareLocal(String name, JVMType type) {
        return this.declareLocal(name, type.getAsmType());
    }

    public LocalInfo declareLocal(String name, Type type) {
        Object object;
        LinkedHashMap $ptemp$1 = this.locals;
        String $ptemp$2 = name;
        Object $or$3 = $ptemp$1.get($ptemp$2);
        if ($or$3 != null) {
            object = $or$3;
        } else {
            int index = this.nextLocal;
            this.nextLocal += type.getSize();
            LocalInfo val0 = new LocalInfo(name, index, type, this.mark(), this.endLabel);
            $ptemp$1.put($ptemp$2, val0);
            object = val0;
        }
        return (LocalInfo)object;
    }

    public void storeLocal(String name, JVMType type) {
        this.storeLocal(name, type.getAsmType());
    }

    public void storeLocal(String name, Type type) {
        LocalInfo info = this.declareLocal(name, type);
        this.visitVarInsn(info.type().getOpcode(Opcodes.ISTORE), info.index());
    }

    public void loadLocal(String name) {
        LocalInfo info = (LocalInfo)this.locals.get(name);
        if (info == null) {
            throw new Exception("missing local " + name + " in list " + this.locals.keySet());
        }
        this.visitVarInsn(info.type().getOpcode(Opcodes.ILOAD), info.index());
    }

    @Override
    public void endMethod() {
        if (0 == (this.flags & (Opcodes.ACC_NATIVE | Opcodes.ACC_ABSTRACT))) {
            this.mark(this.endLabel);
            for (Object info : this.locals.values()) {
                ((LocalInfo)info).declare(this);
            }
        }
        super.endMethod();
    }

    public int recordPosition(Position position, boolean atEnd) {
        int n;
        boolean bl = position != null ? position.source() == this.codesource : false;
        if (bl) {
            int line;
            int n2 = line = atEnd ? position.endLine() : position.startLine();
            if (line != this.currentLine) {
                this.visitLineNumber(line, this.mark());
                n = this.currentLine = line;
            } else {
                n = 0;
            }
        } else {
            n = 0;
        }
        return n;
    }

    public void pushNil() {
        this.push((String)null);
    }

    public Bytecode pop(JVMType type) {
        Bytecode bytecode;
        int size = type.getAsmType().getSize();
        if (size == 1) {
            Bytecode bytecode2 = this;
            bytecode = bytecode2;
            bytecode2.pop();
        } else if (size == 2) {
            Bytecode bytecode3 = this;
            bytecode = bytecode3;
            bytecode3.pop2();
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    public Bytecode dup(JVMType type) {
        Bytecode bytecode;
        int size = type.getAsmType().getSize();
        if (size == 1) {
            Bytecode bytecode2 = this;
            bytecode = bytecode2;
            bytecode2.dup();
        } else if (size == 2) {
            Bytecode bytecode3 = this;
            bytecode = bytecode3;
            bytecode3.dup2();
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    public Bytecode dupX1(JVMType type) {
        Bytecode bytecode;
        int size = type.getAsmType().getSize();
        if (size == 1) {
            Bytecode bytecode2 = this;
            bytecode = bytecode2;
            bytecode2.dupX1();
        } else if (size == 2) {
            Bytecode bytecode3 = this;
            bytecode = bytecode3;
            bytecode3.dup2X1();
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    public Bytecode dupX2(JVMType type) {
        Bytecode bytecode;
        int size = type.getAsmType().getSize();
        if (size == 1) {
            Bytecode bytecode2 = this;
            bytecode = bytecode2;
            bytecode2.dupX2();
        } else if (size == 2) {
            Bytecode bytecode3 = this;
            bytecode = bytecode3;
            bytecode3.dup2X2();
        } else {
            bytecode = null;
        }
        return bytecode;
    }

    public void convertValue(JVMType currentType, JVMType wantedType) {
        block0: {
            block3: {
                block2: {
                    block1: {
                        if (currentType.equals(wantedType)) break block0;
                        if (!(JVMTypeUtils.isPrimitive(currentType) ? JVMTypeUtils.isPrimitive(wantedType) : false)) break block1;
                        this.cast(currentType.getAsmType(), wantedType.getAsmType());
                        break block0;
                    }
                    if (!JVMTypeUtils.isPrimitive(currentType)) break block2;
                    this.box(currentType.getAsmType());
                    break block0;
                }
                if (!JVMTypeUtils.isPrimitive(wantedType)) break block3;
                this.unbox(wantedType.getAsmType());
                break block0;
            }
            if (wantedType.assignableFrom(currentType)) break block0;
            this.checkCast(wantedType.getAsmType());
        }
    }

    public void invokeSpecial(Type type, Method method) {
        this.invokeConstructor(type, method);
    }

    public void ifCmp(Type type, int mode, boolean negated, Label label) {
        int sort = type.getSort();
        boolean negated_float = negated & (sort == Type.FLOAT | sort == Type.DOUBLE);
        if (negated_float) {
            boolean greater;
            boolean $or$4;
            boolean bl = $or$4 = mode == GeneratorAdapter.GE;
            boolean bl2 = $or$4 ? $or$4 : (greater = mode == GeneratorAdapter.GT);
            if (sort == Type.FLOAT) {
                this.mv.visitInsn(greater ? Opcodes.FCMPG : Opcodes.FCMPL);
            } else {
                this.mv.visitInsn(greater ? Opcodes.DCMPG : Opcodes.DCMPL);
            }
            this.mv.visitJumpInsn(mode, label);
        } else {
            this.ifCmp(type, mode, label);
        }
    }
}

